/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.credential.CredentialModel;
import org.keycloak.exportimport.ExportOptions;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.MemberRepresentation;
import org.keycloak.representations.idm.MembershipType;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.federated.UserFederatedStorageProvider;

public class ExportUtils {
    public static RealmRepresentation exportRealm(KeycloakSession session, RealmModel realm, boolean includeUsers, boolean internal) {
        ExportOptions opts = new ExportOptions(includeUsers, true, true, false, false);
        return ExportUtils.exportRealm(session, realm, opts, internal);
    }

    public static RealmRepresentation exportRealm(KeycloakSession session, RealmModel realm, ExportOptions options, boolean internal) {
        RealmRepresentation rep = ModelToRepresentation.toRepresentation((KeycloakSession)session, (RealmModel)realm, (boolean)internal, (boolean)true);
        ModelToRepresentation.exportAuthenticationFlows((KeycloakSession)session, (RealmModel)realm, (RealmRepresentation)rep);
        ModelToRepresentation.exportRequiredActions((RealmModel)realm, (RealmRepresentation)rep);
        rep.setKeycloakVersion(Version.VERSION);
        rep.setClientScopes(realm.getClientScopesStream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList()));
        rep.setDefaultDefaultClientScopes(realm.getDefaultClientScopesStream(true).map(ClientScopeModel::getName).collect(Collectors.toList()));
        rep.setDefaultOptionalClientScopes(realm.getDefaultClientScopesStream(false).map(ClientScopeModel::getName).collect(Collectors.toList()));
        LinkedList clients = new LinkedList();
        if (options.isClientsIncluded()) {
            List clientReps = ModelToRepresentation.filterValidRepresentations((Stream)realm.getClientsStream(), app -> {
                ClientRepresentation clientRepresentation = ExportUtils.exportClient(session, app);
                clients.add(app);
                return clientRepresentation;
            }).collect(Collectors.toList());
            rep.setClients(clientReps);
        }
        if (options.isGroupsAndRolesIncluded()) {
            ModelToRepresentation.exportGroups((KeycloakSession)session, (RealmModel)realm, (RealmRepresentation)rep);
            HashMap<String, List<RoleRepresentation>> clientRolesReps = new HashMap<String, List<RoleRepresentation>>();
            List<RoleRepresentation> realmRoleReps = ExportUtils.exportRoles(realm.getRolesStream());
            RolesRepresentation rolesRep = new RolesRepresentation();
            if (!realmRoleReps.isEmpty()) {
                rolesRep.setRealm(realmRoleReps);
            }
            if (options.isClientsIncluded()) {
                for (ClientModel client : clients) {
                    Stream currentAppRoles = client.getRolesStream();
                    List<RoleRepresentation> currentAppRoleReps = ExportUtils.exportRoles(currentAppRoles);
                    clientRolesReps.put(client.getClientId(), currentAppRoleReps);
                }
                if (!clientRolesReps.isEmpty()) {
                    rolesRep.setClient(clientRolesReps);
                }
            }
            rep.setRoles(rolesRep);
        }
        HashMap<String, List> clientScopeReps = new HashMap<String, List>();
        if (options.isClientsIncluded()) {
            ArrayList allClients = new ArrayList(clients);
            for (ClientModel client : allClients) {
                Set clientScopes = client.getScopeMappingsStream().collect(Collectors.toSet());
                ScopeMappingRepresentation scopeMappingRep = null;
                for (RoleModel scope : clientScopes) {
                    if (scope.getContainer() instanceof RealmModel) {
                        if (scopeMappingRep == null) {
                            scopeMappingRep = rep.clientScopeMapping(client.getClientId());
                        }
                        scopeMappingRep.role(scope.getName());
                        continue;
                    }
                    ClientModel app2 = (ClientModel)scope.getContainer();
                    String appName = app2.getClientId();
                    List currentAppScopes = clientScopeReps.computeIfAbsent(appName, k -> new ArrayList());
                    ScopeMappingRepresentation currentClientScope = null;
                    for (ScopeMappingRepresentation scopeMapping : currentAppScopes) {
                        if (!client.getClientId().equals(scopeMapping.getClient())) continue;
                        currentClientScope = scopeMapping;
                        break;
                    }
                    if (currentClientScope == null) {
                        currentClientScope = new ScopeMappingRepresentation();
                        currentClientScope.setClient(client.getClientId());
                        currentAppScopes.add(currentClientScope);
                    }
                    currentClientScope.role(scope.getName());
                }
            }
        }
        realm.getClientScopesStream().forEach(clientScope -> {
            Set clientScopes = clientScope.getScopeMappingsStream().collect(Collectors.toSet());
            ScopeMappingRepresentation scopeMappingRep = null;
            for (RoleModel scope : clientScopes) {
                if (scope.getContainer() instanceof RealmModel) {
                    if (scopeMappingRep == null) {
                        scopeMappingRep = rep.clientScopeScopeMapping(clientScope.getName());
                    }
                    scopeMappingRep.role(scope.getName());
                    continue;
                }
                ClientModel app = (ClientModel)scope.getContainer();
                String appName = app.getClientId();
                List currentAppScopes = clientScopeReps.computeIfAbsent(appName, k -> new ArrayList());
                ScopeMappingRepresentation currentClientTemplateScope = null;
                for (ScopeMappingRepresentation scopeMapping : currentAppScopes) {
                    if (!clientScope.getName().equals(scopeMapping.getClientScope())) continue;
                    currentClientTemplateScope = scopeMapping;
                    break;
                }
                if (currentClientTemplateScope == null) {
                    currentClientTemplateScope = new ScopeMappingRepresentation();
                    currentClientTemplateScope.setClientScope(clientScope.getName());
                    currentAppScopes.add(currentClientTemplateScope);
                }
                currentClientTemplateScope.role(scope.getName());
            }
        });
        if (!clientScopeReps.isEmpty()) {
            rep.setClientScopeMappings(clientScopeReps);
        }
        if (options.isUsersIncluded()) {
            List federatedUsers;
            UserFederatedStorageProvider userFederatedStorageProvider;
            users = session.users().searchForUserStream(realm, Collections.emptyMap()).map(user -> ExportUtils.exportUser(session, realm, user, options, internal)).collect(Collectors.toList());
            if (!users.isEmpty()) {
                rep.setUsers(users);
            }
            if ((userFederatedStorageProvider = ExportUtils.userFederatedStorage(session)) != null && !(federatedUsers = ExportUtils.userFederatedStorage(session).getStoredUsersStream(realm, Integer.valueOf(0), Integer.valueOf(-1)).map(user -> ExportUtils.exportFederatedUser(session, realm, user, options)).collect(Collectors.toList())).isEmpty()) {
                rep.setFederatedUsers(federatedUsers);
            }
        } else if (options.isClientsIncluded() && options.isOnlyServiceAccountsIncluded()) {
            users = new LinkedList();
            for (ClientModel app3 : clients) {
                UserModel user2;
                if (!app3.isServiceAccountsEnabled() || app3.isPublicClient() || app3.isBearerOnly() || (user2 = session.users().getServiceAccount(app3)) == null) continue;
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user2, options, internal);
                users.add(userRep);
            }
            if (!users.isEmpty()) {
                rep.setUsers(users);
            }
        }
        MultivaluedHashMap<String, ComponentExportRepresentation> components = ExportUtils.exportComponents(realm, realm.getId());
        rep.setComponents(components);
        rep.setLocalizationTexts(realm.getRealmLocalizationTexts());
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) && !options.isPartial()) {
            OrganizationProvider orgProvider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
            orgProvider.getAllStream().map(model -> {
                OrganizationRepresentation org = ModelToRepresentation.toRepresentation((OrganizationModel)model, (boolean)false);
                orgProvider.getMembersStream(model, (Map)null, null, null, null).forEach(user -> {
                    MemberRepresentation member = new MemberRepresentation();
                    member.setUsername(user.getUsername());
                    member.setMembershipType(orgProvider.isManagedMember(model, user) ? MembershipType.MANAGED : MembershipType.UNMANAGED);
                    org.addMember(member);
                });
                orgProvider.getIdentityProviders(model).map(b -> {
                    IdentityProviderRepresentation broker = new IdentityProviderRepresentation();
                    broker.setAlias(b.getAlias());
                    return broker;
                }).forEach(arg_0 -> ((OrganizationRepresentation)org).addIdentityProvider(arg_0));
                return org;
            }).forEach(arg_0 -> ((RealmRepresentation)rep).addOrganization(arg_0));
        }
        return rep;
    }

    public static MultivaluedHashMap<String, ComponentExportRepresentation> exportComponents(RealmModel realm, String parentId) {
        MultivaluedHashMap components = new MultivaluedHashMap();
        realm.getComponentsStream(parentId).forEach(component -> {
            ComponentExportRepresentation compRep = new ComponentExportRepresentation();
            compRep.setId(component.getId());
            compRep.setProviderId(component.getProviderId());
            compRep.setConfig(component.getConfig());
            compRep.setName(component.getName());
            compRep.setSubType(component.getSubType());
            compRep.setSubComponents(ExportUtils.exportComponents(realm, component.getId()));
            components.add((Object)component.getProviderType(), (Object)compRep);
        });
        return components;
    }

    public static ClientRepresentation exportClient(KeycloakSession session, ClientModel client) {
        ClientRepresentation clientRep = ModelToRepresentation.toRepresentation((ClientModel)client, (KeycloakSession)session);
        clientRep.setSecret(client.getSecret());
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION)) {
            clientRep.setAuthorizationSettings(ModelToRepresentation.toResourceServerRepresentation((KeycloakSession)session, (ClientModel)client));
        }
        return clientRep;
    }

    public static List<RoleRepresentation> exportRoles(Stream<RoleModel> roles) {
        return roles.map(ExportUtils::exportRole).collect(Collectors.toList());
    }

    public static RoleRepresentation exportRole(RoleModel role) {
        RoleRepresentation roleRep = ModelToRepresentation.toRepresentation((RoleModel)role);
        Set composites = role.getCompositesStream().collect(Collectors.toSet());
        if (composites != null && composites.size() > 0) {
            HashSet<String> compositeRealmRoles = null;
            HashMap<String, ArrayList<String>> compositeClientRoles = null;
            for (RoleModel composite : composites) {
                ClientModel app;
                String appName;
                ArrayList<String> currentAppComposites;
                RoleContainerModel crContainer = composite.getContainer();
                if (crContainer instanceof RealmModel) {
                    if (compositeRealmRoles == null) {
                        compositeRealmRoles = new HashSet<String>();
                    }
                    compositeRealmRoles.add(composite.getName());
                    continue;
                }
                if (compositeClientRoles == null) {
                    compositeClientRoles = new HashMap<String, ArrayList<String>>();
                }
                if ((currentAppComposites = (ArrayList<String>)compositeClientRoles.get(appName = (app = (ClientModel)crContainer).getClientId())) == null) {
                    currentAppComposites = new ArrayList<String>();
                    compositeClientRoles.put(appName, currentAppComposites);
                }
                currentAppComposites.add(composite.getName());
            }
            RoleRepresentation.Composites compRep = new RoleRepresentation.Composites();
            if (compositeRealmRoles != null) {
                compRep.setRealm(compositeRealmRoles);
            }
            if (compositeClientRoles != null) {
                compRep.setClient(compositeClientRoles);
            }
            roleRep.setComposites(compRep);
        }
        return roleRep;
    }

    public static UserRepresentation exportUser(KeycloakSession session, RealmModel realm, UserModel user, ExportOptions options, boolean internal) {
        String clientInternalId;
        ClientModel client;
        UserRepresentation userRep = ModelToRepresentation.toRepresentation((KeycloakSession)session, (RealmModel)realm, (UserModel)user);
        List socialLinkReps = session.users().getFederatedIdentitiesStream(realm, user).map(ExportUtils::exportSocialLink).collect(Collectors.toList());
        if (socialLinkReps.size() > 0) {
            userRep.setFederatedIdentities(socialLinkReps);
        }
        if (options.isGroupsAndRolesIncluded()) {
            Set roles = user.getRoleMappingsStream().collect(Collectors.toSet());
            ArrayList<String> realmRoleNames = new ArrayList<String>();
            HashMap<String, ArrayList<String>> clientRoleNames = new HashMap<String, ArrayList<String>>();
            for (RoleModel role : roles) {
                if (role.getContainer() instanceof RealmModel) {
                    realmRoleNames.add(role.getName());
                    continue;
                }
                ClientModel client2 = (ClientModel)role.getContainer();
                String clientId = client2.getClientId();
                ArrayList<String> currentClientRoles = (ArrayList<String>)clientRoleNames.get(clientId);
                if (currentClientRoles == null) {
                    currentClientRoles = new ArrayList<String>();
                    clientRoleNames.put(clientId, currentClientRoles);
                }
                currentClientRoles.add(role.getName());
            }
            if (realmRoleNames.size() > 0) {
                userRep.setRealmRoles(realmRoleNames);
            }
            if (clientRoleNames.size() > 0) {
                userRep.setClientRoles(clientRoleNames);
            }
        }
        if (internal) {
            List credReps = user.credentialManager().getStoredCredentialsStream().map(ExportUtils::exportCredential).collect(Collectors.toList());
            userRep.setCredentials(credReps);
        }
        userRep.setFederationLink(user.getFederationLink());
        List consentReps = session.users().getConsentsStream(realm, user.getId()).map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        if (consentReps.size() > 0) {
            userRep.setClientConsents(consentReps);
        }
        int notBefore = session.users().getNotBeforeOfUser(realm, user);
        userRep.setNotBefore(Integer.valueOf(notBefore));
        if (user.getServiceAccountClientLink() != null && (client = realm.getClientById(clientInternalId = user.getServiceAccountClientLink())) != null) {
            userRep.setServiceAccountClientId(client.getClientId());
        }
        if (options.isGroupsAndRolesIncluded()) {
            List groups = user.getGroupsStream().filter(g -> GroupModel.Type.REALM.equals((Object)g.getType())).map(ModelToRepresentation::buildGroupPath).collect(Collectors.toList());
            userRep.setGroups(groups);
        }
        return userRep;
    }

    public static FederatedIdentityRepresentation exportSocialLink(FederatedIdentityModel socialLink) {
        FederatedIdentityRepresentation socialLinkRep = new FederatedIdentityRepresentation();
        socialLinkRep.setIdentityProvider(socialLink.getIdentityProvider());
        socialLinkRep.setUserId(socialLink.getUserId());
        socialLinkRep.setUserName(socialLink.getUserName());
        return socialLinkRep;
    }

    public static CredentialRepresentation exportCredential(CredentialModel userCred) {
        return ModelToRepresentation.toRepresentation((CredentialModel)userCred);
    }

    public static void exportUsersToStream(KeycloakSession session, RealmModel realm, List<UserModel> usersToExport, ObjectMapper mapper, OutputStream os) throws IOException {
        ExportUtils.exportUsersToStream(session, realm, usersToExport, mapper, os, new ExportOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportUsersToStream(KeycloakSession session, RealmModel realm, List<UserModel> usersToExport, ObjectMapper mapper, OutputStream os, ExportOptions options) throws IOException {
        JsonFactory factory = mapper.getFactory();
        try (JsonGenerator generator = factory.createGenerator(os, JsonEncoding.UTF8);){
            if (mapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                generator.useDefaultPrettyPrinter();
            }
            generator.writeStartObject();
            generator.writeStringField("realm", realm.getName());
            generator.writeFieldName("users");
            generator.writeStartArray();
            for (UserModel user : usersToExport) {
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user, options, true);
                generator.writeObject((Object)userRep);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }

    public static void exportFederatedUsersToStream(KeycloakSession session, RealmModel realm, List<String> usersToExport, ObjectMapper mapper, OutputStream os) throws IOException {
        ExportUtils.exportFederatedUsersToStream(session, realm, usersToExport, mapper, os, new ExportOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFederatedUsersToStream(KeycloakSession session, RealmModel realm, List<String> usersToExport, ObjectMapper mapper, OutputStream os, ExportOptions options) throws IOException {
        JsonFactory factory = mapper.getFactory();
        try (JsonGenerator generator = factory.createGenerator(os, JsonEncoding.UTF8);){
            if (mapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                generator.useDefaultPrettyPrinter();
            }
            generator.writeStartObject();
            generator.writeStringField("realm", realm.getName());
            generator.writeFieldName("federatedUsers");
            generator.writeStartArray();
            for (String userId : usersToExport) {
                UserRepresentation userRep = ExportUtils.exportFederatedUser(session, realm, userId, options);
                generator.writeObject((Object)userRep);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }

    public static UserRepresentation exportFederatedUser(KeycloakSession session, RealmModel realm, String id, ExportOptions options) {
        List socialLinkReps;
        List requiredActions;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setId(id);
        MultivaluedHashMap attributes = ExportUtils.userFederatedStorage(session).getAttributes(realm, id);
        if (attributes.size() > 0) {
            HashMap attrs = new HashMap();
            attrs.putAll(attributes);
            userRep.setAttributes(attrs);
        }
        if ((requiredActions = ExportUtils.userFederatedStorage(session).getRequiredActionsStream(realm, id).collect(Collectors.toList())).size() > 0) {
            userRep.setRequiredActions(requiredActions);
        }
        if ((socialLinkReps = ExportUtils.userFederatedStorage(session).getFederatedIdentitiesStream(id, realm).map(ExportUtils::exportSocialLink).collect(Collectors.toList())).size() > 0) {
            userRep.setFederatedIdentities(socialLinkReps);
        }
        if (options.isGroupsAndRolesIncluded()) {
            Set roles = ExportUtils.userFederatedStorage(session).getRoleMappingsStream(realm, id).collect(Collectors.toSet());
            ArrayList<String> realmRoleNames = new ArrayList<String>();
            HashMap<String, ArrayList<String>> clientRoleNames = new HashMap<String, ArrayList<String>>();
            for (RoleModel role : roles) {
                if (role.getContainer() instanceof RealmModel) {
                    realmRoleNames.add(role.getName());
                    continue;
                }
                ClientModel client = (ClientModel)role.getContainer();
                String clientId = client.getClientId();
                ArrayList<String> currentClientRoles = (ArrayList<String>)clientRoleNames.get(clientId);
                if (currentClientRoles == null) {
                    currentClientRoles = new ArrayList<String>();
                    clientRoleNames.put(clientId, currentClientRoles);
                }
                currentClientRoles.add(role.getName());
            }
            if (realmRoleNames.size() > 0) {
                userRep.setRealmRoles(realmRoleNames);
            }
            if (clientRoleNames.size() > 0) {
                userRep.setClientRoles(clientRoleNames);
            }
        }
        List credReps = ExportUtils.userFederatedStorage(session).getStoredCredentialsStream(realm, id).map(ExportUtils::exportCredential).collect(Collectors.toList());
        userRep.setCredentials(credReps);
        List consentReps = session.users().getConsentsStream(realm, id).map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        if (consentReps.size() > 0) {
            userRep.setClientConsents(consentReps);
        }
        int notBefore = ExportUtils.userFederatedStorage(session).getNotBeforeOfUser(realm, userRep.getId());
        userRep.setNotBefore(Integer.valueOf(notBefore));
        if (options.isGroupsAndRolesIncluded()) {
            List groups = ExportUtils.userFederatedStorage(session).getGroupsStream(realm, id).map(ModelToRepresentation::buildGroupPath).collect(Collectors.toList());
            userRep.setGroups(groups);
        }
        return userRep;
    }

    private static UserFederatedStorageProvider userFederatedStorage(KeycloakSession session) {
        return (UserFederatedStorageProvider)session.getProvider(UserFederatedStorageProvider.class);
    }
}

