/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedClientScope
extends AbstractRevisioned
implements InRealm {
    private String name;
    private String description;
    private String realm;
    private String protocol;
    private Set<String> scope = new HashSet<String>();
    private Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
    private Map<String, String> attributes = new HashMap<String, String>();

    public CachedClientScope(Long revision, RealmModel realm, ClientScopeModel model) {
        super(revision, model.getId());
        this.name = model.getName();
        this.description = model.getDescription();
        this.realm = realm.getId();
        this.protocol = model.getProtocol();
        this.protocolMappers.addAll(model.getProtocolMappersStream().collect(Collectors.toSet()));
        this.scope.addAll(model.getScopeMappingsStream().map(RoleModel::getId).collect(Collectors.toSet()));
        this.attributes.putAll(model.getAttributes());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

