/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoReserved;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@ProtoTypeId(value=65596)
@ProtoReserved(value={7}, names={"id"})
public class AuthenticatedClientSessionEntity
extends SessionEntity {
    @Deprecated(since="26.4", forRemoval=true)
    public static final String LAST_TIMESTAMP_REMOTE = "lstr";
    @Deprecated(since="26.4", forRemoval=true)
    public static final String CLIENT_ID_NOTE = "clientId";
    private String authMethod;
    private String redirectUri;
    private volatile int timestamp;
    private String action;
    private Map<String, String> notes = new ConcurrentHashMap<String, String>();
    private volatile String userSessionId;
    private volatile String clientId;
    private volatile String userId;

    public AuthenticatedClientSessionEntity() {
    }

    @ProtoField(value=2)
    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @ProtoField(value=3)
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @ProtoField(value=4)
    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public int getUserSessionStarted() {
        String started = this.getNotes().get("userSessionStartedAt");
        return started == null ? this.timestamp : Integer.parseInt(started);
    }

    public int getStarted() {
        String started = this.getNotes().get("startedAt");
        return started == null ? this.timestamp : Integer.parseInt(started);
    }

    public boolean isUserSessionRememberMe() {
        return Boolean.parseBoolean(this.getNotes().get("userSessionRememberMe"));
    }

    @ProtoField(value=9)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.getNotes().put(CLIENT_ID_NOTE, clientId);
        this.clientId = clientId;
    }

    @ProtoField(value=5)
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @ProtoField(value=6, mapImplementation=ConcurrentHashMap.class)
    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    @ProtoField(value=10)
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatedClientSessionEntity that = (AuthenticatedClientSessionEntity)o;
        return Objects.equals(this.userSessionId, that.userSessionId) && Objects.equals(this.clientId, that.clientId);
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(this.userSessionId);
        result = 31 * result + Objects.hashCode(this.clientId);
        return result;
    }

    @ProtoFactory
    AuthenticatedClientSessionEntity(String realmId, String authMethod, String redirectUri, int timestamp, String action, Map<String, String> notes, String userSessionId, String clientId, String userId) {
        super(realmId);
        this.authMethod = authMethod;
        this.redirectUri = redirectUri;
        this.timestamp = timestamp;
        this.action = action;
        this.notes = notes;
        this.userSessionId = userSessionId;
        this.clientId = clientId;
        this.userId = userId;
    }

    @ProtoField(value=8)
    public String getUserSessionId() {
        return this.userSessionId;
    }

    public void setUserSessionId(String userSessionId) {
        this.userSessionId = userSessionId;
    }

    public static AuthenticatedClientSessionEntity create(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity();
        entity.setRealmId(realm.getId());
        entity.setClientId(client.getId());
        entity.setTimestamp(Time.currentTime());
        entity.getNotes().put("startedAt", String.valueOf(entity.getTimestamp()));
        entity.getNotes().put("userSessionStartedAt", String.valueOf(userSession.getStarted()));
        if (userSession.isRememberMe()) {
            entity.getNotes().put("userSessionRememberMe", "true");
        }
        entity.setUserId(userSession.getUser().getId());
        return entity;
    }

    public static AuthenticatedClientSessionEntity createFromModel(AuthenticatedClientSessionModel model) {
        AuthenticatedClientSessionEntity entity = AuthenticatedClientSessionEntity.create(model.getRealm(), model.getClient(), model.getUserSession());
        entity.setNotes(model.getNotes() == null ? new ConcurrentHashMap() : model.getNotes());
        return entity;
    }
}

