/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.RealmModel;

public class OAuth2DeviceUserCodeModel {
    private static final String DEVICE_CODE_NOTE = "dc";
    private final RealmModel realm;
    private final String deviceCode;
    private final String userCode;

    public OAuth2DeviceUserCodeModel(RealmModel realm, String deviceCode, String userCode) {
        this.realm = realm;
        this.deviceCode = deviceCode;
        this.userCode = userCode;
    }

    public static OAuth2DeviceUserCodeModel fromCache(RealmModel realm, String userCode, Map<String, String> data) {
        return new OAuth2DeviceUserCodeModel(realm, userCode, data);
    }

    private OAuth2DeviceUserCodeModel(RealmModel realm, String userCode, Map<String, String> data) {
        this.realm = realm;
        this.userCode = userCode;
        this.deviceCode = data.get(DEVICE_CODE_NOTE);
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public static String createKey(RealmModel realm, String userCode) {
        return String.format("%s.uc.%s", realm.getId(), userCode);
    }

    public String serializeKey() {
        return OAuth2DeviceUserCodeModel.createKey(this.realm, this.userCode);
    }

    public Map<String, String> serializeValue() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(DEVICE_CODE_NOTE, this.deviceCode);
        return result;
    }
}

