/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

abstract class BackupPair
implements Serializable {
    protected InstallFile originalFile;
    protected long modTime;
    protected boolean elevated;
    protected boolean previouslyCreated = false;
    protected int rollbackId;

    public static BackupPair createRegular(InstallFile originalFile, long modTime, boolean elevated, File backupFile) {
        return new Regular(originalFile, modTime, elevated, backupFile);
    }

    public static BackupPair createSymlink(InstallFile originalFile, long modTime, boolean elevated, String linkTarget) {
        return new Symlink(originalFile, modTime, elevated, linkTarget);
    }

    protected BackupPair(InstallFile originalFile, long modTime, boolean elevated) {
        this.originalFile = originalFile;
        this.modTime = modTime;
        this.elevated = elevated;
    }

    public boolean isPreviouslyCreated() {
        return this.previouslyCreated;
    }

    public void setPreviouslyCreated(boolean previouslyCreated) {
        this.previouslyCreated = previouslyCreated;
    }

    public InstallFile getOriginalFile() {
        return this.originalFile;
    }

    public long getModTime() {
        return this.modTime;
    }

    public boolean isElevated() {
        return this.elevated;
    }

    public int getRollbackId() {
        return this.rollbackId;
    }

    public void setRollbackId(int rollbackId) {
        this.rollbackId = rollbackId;
    }

    public abstract void restore();

    public void cleanup() {
    }

    private static class Symlink
    extends BackupPair {
        private final String linkTarget;

        protected Symlink(InstallFile originalFile, long modTime, boolean elevated, String linkTarget) {
            super(originalFile, modTime, elevated);
            this.linkTarget = linkTarget;
        }

        @Override
        public void restore() {
            UnixFileSystem.createLink(this.linkTarget, this.originalFile);
        }

        public String toString() {
            return this.getOriginalFile() + ", linkTarget: " + this.linkTarget;
        }
    }

    private static class Regular
    extends BackupPair {
        private final File backupFile;

        protected Regular(InstallFile originalFile, long modTime, boolean elevated, File backupFile) {
            super(originalFile, modTime, elevated);
            this.backupFile = backupFile;
        }

        @Override
        public void restore() {
            try {
                this.getOriginalFile().delete();
                if (!this.backupFile.renameTo(this.getOriginalFile())) {
                    FileUtil.copyFile(this.backupFile, this.getOriginalFile());
                }
                this.getOriginalFile().setLastModified(this.getModTime());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void cleanup() {
            this.backupFile.delete();
        }

        public String toString() {
            return this.getOriginalFile() + ", backup: " + this.backupFile;
        }
    }
}

