/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.helpers;

import com.google.common.base.Stopwatch;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.IndexedFilmList;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.gui.tabs.tab_film.helpers.GuiModelHelper;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.LuceneDefaultAnalyzer;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.models.TModelFilm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.jetbrains.annotations.NotNull;

public class LuceneGuiFilmeModelHelper
extends GuiModelHelper {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<String, PointsConfig> PARSER_CONFIG_MAP = new HashMap<String, PointsConfig>();
    private static final HashSet<String> INTEREST_SET = new HashSet<String>(List.of("id"));
    private final Analyzer analyzer = LuceneDefaultAnalyzer.buildAnalyzer();

    public LuceneGuiFilmeModelHelper(@NotNull SeenHistoryController historyController, @NotNull SearchFieldData searchFieldData, @NotNull FilterConfiguration filterConfiguration) {
        super(historyController, searchFieldData, filterConfiguration);
    }

    private TModelFilm performTableFiltering() {
        IndexedFilmList listeFilme = (IndexedFilmList)Daten.getInstance().getListeFilmeNachBlackList();
        try {
            this.calculateFilmLengthSliderValues();
            if (this.filterConfiguration.isShowUnseenOnly()) {
                this.historyController.prepareMemoryCache();
            }
            String searchText = this.searchFieldData.searchFieldText();
            Stream<Object> stream = listeFilme.parallelStream();
            if (!this.noFiltersAreSet()) {
                List<String> selectedSenders;
                StandardQueryParser parser = new StandardQueryParser(this.analyzer);
                parser.setPointsConfigMap(PARSER_CONFIG_MAP);
                parser.setAllowLeadingWildcard(true);
                Object initialQuery = searchText.isEmpty() ? new MatchAllDocsQuery() : parser.parse(searchText, "titel");
                BooleanQuery.Builder qb = new BooleanQuery.Builder();
                qb.add((Query)initialQuery, BooleanClause.Occur.MUST);
                if (!this.filterConfiguration.getZeitraum().equalsIgnoreCase("\u221e")) {
                    try {
                        qb.add(this.createZeitraumQuery(), BooleanClause.Occur.FILTER);
                    }
                    catch (Exception ex) {
                        logger.error("Unable to add zeitraum filter", (Throwable)ex);
                    }
                }
                if (this.filterConfiguration.isShowLivestreamsOnly()) {
                    this.addLivestreamQuery(qb);
                }
                if (this.filterConfiguration.isShowHighQualityOnly()) {
                    this.addHighQualityOnlyQuery(qb);
                }
                if (this.filterConfiguration.isDontShowTrailers()) {
                    this.addNoTrailerTeaserQuery(qb);
                }
                if (this.filterConfiguration.isDontShowAudioVersions()) {
                    this.addNoAudioVersionQuery(qb);
                }
                if (this.filterConfiguration.isDontShowSignLanguage()) {
                    this.addNoSignLanguageQuery(qb);
                }
                if (this.filterConfiguration.isDontShowDuplicates()) {
                    this.addNoDuplicatesQuery(qb);
                }
                if (this.filterConfiguration.isShowSubtitlesOnly()) {
                    this.addSubtitleOnlyQuery(qb);
                }
                if (this.filterConfiguration.isShowNewOnly()) {
                    this.addNewOnlyQuery(qb);
                }
                if (!(selectedSenders = this.getSelectedSendersFromFilter()).isEmpty()) {
                    this.addSenderFilterQuery(qb, selectedSenders);
                }
                BooleanQuery finalQuery = qb.build();
                logger.info("Executing Lucene query: {}", (Object)finalQuery);
                IndexSearcher searcher = new IndexSearcher((IndexReader)listeFilme.getReader());
                TopDocs docs = searcher.search((Query)finalQuery, listeFilme.size());
                int hit_length = docs.scoreDocs.length;
                HashSet filmNrSet = HashSet.newHashSet(hit_length);
                logger.trace("Hit size: {}", (Object)hit_length);
                Stopwatch watch2 = Stopwatch.createStarted();
                StoredFields storedFields = searcher.storedFields();
                for (ScoreDoc hit : docs.scoreDocs) {
                    int docId = hit.doc;
                    Document d = storedFields.document(docId, INTEREST_SET);
                    filmNrSet.add(Integer.parseInt(d.get("id")));
                }
                watch2.stop();
                logger.trace("Populating filmlist took: {}", (Object)watch2);
                logger.trace("Number of found Lucene index entries: {}", (Object)filmNrSet.size());
                stream = listeFilme.parallelStream().filter(film -> filmNrSet.contains(film.getFilmNr()));
            }
            if (this.filterConfiguration.isShowBookMarkedOnly()) {
                stream = stream.filter(DatenFilm::isBookmarked);
            }
            if (this.filterConfiguration.isDontShowAbos()) {
                stream = stream.filter(film -> film.getAbo() == null);
            }
            List<DatenFilm> resultList = this.applyCommonFilters(stream, this.filterConfiguration.getThema()).toList();
            logger.trace("Resulting filmlist size after all filters applied: {}", (Object)resultList.size());
            TModelFilm filmModel = new TModelFilm(resultList.size());
            filmModel.addAll(resultList);
            if (this.filterConfiguration.isShowUnseenOnly()) {
                this.historyController.emptyMemoryCache();
            }
            return filmModel;
        }
        catch (Exception ex) {
            logger.error("Lucene filtering failed!", (Throwable)ex);
            SwingUtilities.invokeLater(() -> SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Die Lucene Abfrage ist inkorrekt und f\u00fchrt zu keinen Ergebnissen.", ex));
            return new TModelFilm();
        }
    }

    private void addSenderFilterQuery(@NotNull BooleanQuery.Builder qb, @NotNull Collection<String> selectedSenders) {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        for (String sender : selectedSenders) {
            TermQuery term = new TermQuery(new Term("sender", sender.toLowerCase()));
            booleanQuery.add((Query)term, BooleanClause.Occur.SHOULD);
        }
        qb.add((Query)booleanQuery.build(), BooleanClause.Occur.FILTER);
    }

    private void addSubtitleOnlyQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("untertitel", "true"));
        qb.add((Query)q, BooleanClause.Occur.FILTER);
    }

    private void addNoDuplicatesQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("duplicate", "true"));
        qb.add((Query)q, BooleanClause.Occur.MUST_NOT);
    }

    private void addNoSignLanguageQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("signlanguage", "true"));
        qb.add((Query)q, BooleanClause.Occur.MUST_NOT);
    }

    private void addNoAudioVersionQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("audioversion", "true"));
        qb.add((Query)q, BooleanClause.Occur.MUST_NOT);
    }

    private void addNoTrailerTeaserQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("trailerteaser", "true"));
        qb.add((Query)q, BooleanClause.Occur.MUST_NOT);
    }

    private void addNewOnlyQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("neu", "true"));
        qb.add((Query)q, BooleanClause.Occur.FILTER);
    }

    private void addLivestreamQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("livestream", "true"));
        qb.add((Query)q, BooleanClause.Occur.FILTER);
    }

    private void addHighQualityOnlyQuery(@NotNull BooleanQuery.Builder qb) {
        TermQuery q = new TermQuery(new Term("highquality", "true"));
        qb.add((Query)q, BooleanClause.Occur.FILTER);
    }

    private Query createZeitraumQuery() throws ParseException {
        int numDays = Integer.parseInt(this.filterConfiguration.getZeitraum());
        LocalDateTime toDate = LocalDateTime.now();
        LocalDateTime fromDate = toDate.minusDays(numDays);
        ZoneId utcZone = ZoneId.of("UTC");
        String toStr = DateTools.timeToString((long)toDate.atZone(utcZone).toInstant().toEpochMilli(), (DateTools.Resolution)DateTools.Resolution.DAY);
        String fromStr = DateTools.timeToString((long)fromDate.atZone(utcZone).toInstant().toEpochMilli(), (DateTools.Resolution)DateTools.Resolution.DAY);
        String zeitraum = String.format("[%s TO %s]", fromStr, toStr);
        return new QueryParser("sendedatum", this.analyzer).parse(zeitraum);
    }

    @Override
    public TableModel getFilteredTableModel() {
        TModelFilm filmModel;
        IndexedFilmList listeFilme = (IndexedFilmList)Daten.getInstance().getListeFilmeNachBlackList();
        if (!listeFilme.isEmpty()) {
            if (this.noFiltersAreSet()) {
                filmModel = new TModelFilm(listeFilme.size());
                filmModel.addAll(listeFilme);
            } else {
                filmModel = this.performTableFiltering();
            }
        } else {
            return new TModelFilm();
        }
        return filmModel;
    }

    static {
        PARSER_CONFIG_MAP.put("gr\u00f6\u00dfe", new PointsConfig((NumberFormat)new DecimalFormat(), Integer.class));
        PARSER_CONFIG_MAP.put("l\u00e4nge", new PointsConfig((NumberFormat)new DecimalFormat(), Integer.class));
    }
}

