/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.ttml;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mediathek.tool.ttml.StyledString;
import mediathek.tool.ttml.Subtitle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimedTextMarkupLanguageParser
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(TimedTextMarkupLanguageParser.class);
    private final SimpleDateFormat assFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final SimpleDateFormat ttmlFormat = new SimpleDateFormat("HH:mm:ss.SS");
    private final SimpleDateFormat srtFormat = new SimpleDateFormat("HH:mm:ss,SSS");
    private final SimpleDateFormat sdfFlash = new SimpleDateFormat("s.S");
    private final Map<String, Integer> alignMap = new HashMap<String, Integer>();
    private final Map<String, List<String>> colorMap = new HashMap<String, List<String>>();
    private final Map<String, Integer> regionMap = new HashMap<String, Integer>();
    private final List<Subtitle> subtitleList = new ArrayList<Subtitle>();
    private final String backgroundColor = "#000000C2";
    private String color = "#FFFFFF";
    private Document doc;

    private String colorToBGR(Color color) {
        return String.format("%02X%02X%02X", color.getBlue(), color.getGreen(), color.getRed());
    }

    private Color hexToColor(@NotNull String hex) {
        if ((hex = hex.replace("#", "")).length() == 6) {
            return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
        }
        if (hex.length() == 8) {
            return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
        }
        logger.error("Failed to convert hex color string: {}", (Object)hex);
        return Color.WHITE;
    }

    private void buildAlignmentMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:style");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node alignmentNode = attrMap.getNamedItem("tts:textAlign");
            if (idNode == null || alignmentNode == null) continue;
            int alignment = this.convertAlignment(alignmentNode.getNodeValue());
            this.alignMap.put(idNode.getNodeValue(), alignment);
        }
    }

    protected int convertAlignment(@NotNull String text) {
        return switch (text) {
            case "start", "left" -> -1;
            case "right", "end" -> 1;
            default -> 0;
        };
    }

    private void buildColorMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:style");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node colorNode = attrMap.getNamedItem("tts:color");
            Node colorBackgroundNode = attrMap.getNamedItem("tts:backgroundColor");
            if (idNode == null || colorNode == null) continue;
            ArrayList<String> colorList = new ArrayList<String>();
            colorList.add(colorNode.getNodeValue());
            if (colorBackgroundNode != null) {
                colorList.add(colorBackgroundNode.getNodeValue());
            } else {
                colorList.add("#000000C2");
            }
            this.colorMap.put(idNode.getNodeValue(), colorList);
        }
    }

    private void buildRegionMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:region");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node regionNode = attrMap.getNamedItem("tts:displayAlign");
            if (idNode == null || regionNode == null) continue;
            int region = this.convertRegion(regionNode.getNodeValue());
            this.regionMap.put(idNode.getNodeValue(), region);
        }
    }

    protected int convertRegion(@NotNull String text) {
        return switch (text) {
            case "before" -> 8;
            case "center" -> 5;
            default -> 2;
        };
    }

    private void checkHours(@NotNull Date date) {
        int hours = date.getHours();
        if (hours >= 10) {
            date.setHours(hours - 10);
        }
    }

    private void buildFilmList() throws Exception {
        NodeList subtitleData = this.doc.getElementsByTagName("tt:p");
        for (int i = 0; i < subtitleData.getLength(); ++i) {
            Node styleNode;
            Subtitle subtitle = new Subtitle();
            Node subnode = subtitleData.item(i);
            if (subnode.hasAttributes()) {
                NamedNodeMap attrMap = subnode.getAttributes();
                Node beginNode = attrMap.getNamedItem("begin");
                Node endNode = attrMap.getNamedItem("end");
                if (beginNode != null && endNode != null) {
                    subtitle.begin = this.ttmlFormat.parse(beginNode.getNodeValue());
                    this.checkHours(subtitle.begin);
                    subtitle.end = this.ttmlFormat.parse(endNode.getNodeValue());
                    this.checkHours(subtitle.end);
                }
                Node regionNode = attrMap.getNamedItem("region");
                styleNode = attrMap.getNamedItem("style");
                Integer alignment = styleNode != null && this.alignMap.containsKey(styleNode.getNodeValue()) ? this.alignMap.get(styleNode.getNodeValue()) : 0;
                Integer region = regionNode != null && this.regionMap.containsKey(regionNode.getNodeValue()) ? this.regionMap.get(regionNode.getNodeValue()) : 2;
                subtitle.region = Integer.toString(alignment + region);
            }
            NodeList childNodes = subnode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                List<String> colors;
                Node node = childNodes.item(j);
                if (!node.getNodeName().equalsIgnoreCase("tt:span")) continue;
                NamedNodeMap attrMap = node.getAttributes();
                styleNode = attrMap.getNamedItem("style");
                StyledString textContent = new StyledString();
                textContent.setText(node.getTextContent());
                List<String> list = colors = styleNode != null && this.colorMap.containsKey(styleNode.getNodeValue()) ? this.colorMap.get(styleNode.getNodeValue()) : null;
                if (colors == null) {
                    textContent.setColor(this.color);
                    textContent.setBackgroundColor("#000000C2");
                } else {
                    textContent.setColor((String)colors.get(0));
                    textContent.setBackgroundColor(colors.get(1));
                }
                subtitle.listOfStrings.add(textContent);
            }
            this.subtitleList.add(subtitle);
        }
    }

    private Date parseFlash(String tStamp) throws ParseException {
        Date da = tStamp.contains(":") ? this.ttmlFormat.parse(tStamp) : this.sdfFlash.parse(tStamp + "00");
        return da;
    }

    private void buildFilmListFlash() throws Exception {
        NodeList subtitleData = this.doc.getElementsByTagName("p");
        for (int i = 0; i < subtitleData.getLength(); ++i) {
            Subtitle subtitle = new Subtitle();
            Node subnode = subtitleData.item(i);
            if (subnode.hasAttributes()) {
                NamedNodeMap attrMap = subnode.getAttributes();
                Node beginNode = attrMap.getNamedItem("begin");
                Node endNode = attrMap.getNamedItem("end");
                if (beginNode != null && endNode != null) {
                    subtitle.begin = this.parseFlash(beginNode.getNodeValue());
                    subtitle.end = this.parseFlash(endNode.getNodeValue());
                    StyledString textContent = new StyledString(subnode.getTextContent(), this.color, "#000000C2");
                    Node col = attrMap.getNamedItem("tts:color");
                    if (col != null) {
                        textContent.setColor(col.getNodeValue());
                    } else {
                        NodeList childNodes = subnode.getChildNodes();
                        for (int j = 0; j < childNodes.getLength(); ++j) {
                            Node node = childNodes.item(j);
                            if (!node.getNodeName().equalsIgnoreCase("span")) continue;
                            NamedNodeMap attr = node.getAttributes();
                            Node co = attr.getNamedItem("tts:color");
                            textContent.setColor(co.getNodeValue());
                        }
                    }
                    subtitle.listOfStrings.add(textContent);
                }
            }
            this.subtitleList.add(subtitle);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    public boolean parse(Path ttmlFilePath) {
        boolean ret;
        try {
            this.doc = this.getDocumentBuilder().parse(ttmlFilePath.toFile());
            NodeList metaData = this.doc.getElementsByTagName("ebuttm:documentEbuttVersion");
            if (metaData != null) {
                Node versionNode = metaData.item(0);
                if (versionNode == null || !versionNode.getTextContent().equalsIgnoreCase("v1.0")) {
                    throw new Exception("Unknown TTML file version");
                }
            } else {
                throw new Exception("Unknown File Format");
            }
            this.buildAlignmentMap();
            this.buildColorMap();
            this.buildRegionMap();
            this.buildFilmList();
            ret = true;
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)ttmlFilePath, (Object)ex);
            ret = false;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parseXmlFlash(Path ttmlFilePath) {
        try {
            String s;
            this.doc = this.getDocumentBuilder().parse(ttmlFilePath.toFile());
            NodeList metaData = this.doc.getElementsByTagName("tt");
            NodeList colorNote = this.doc.getElementsByTagName("style");
            if (metaData == null) throw new Exception("Unknown File Format");
            Node node = metaData.item(0);
            if (!node.hasAttributes()) throw new Exception("Unknown File Format");
            NamedNodeMap attrMap = node.getAttributes();
            Node xmlns = attrMap.getNamedItem("xmlns");
            if (xmlns != null && !(s = xmlns.getNodeValue()).equals("http://www.w3.org/2006/04/ttaf1") && !s.equals("http://www.w3.org/ns/ttml")) {
                throw new Exception("Unknown TTML file version");
            }
            if (colorNote == null) throw new Exception("Unknown File Format");
            if (colorNote.getLength() == 0) {
                this.color = "#FFFFFF";
            } else {
                node = colorNote.item(0);
                if (!node.hasAttributes()) throw new Exception("Unknown File Format");
                attrMap = node.getAttributes();
                Node col = attrMap.getNamedItem("tts:color");
                if (col != null && !col.getNodeValue().isEmpty()) {
                    this.color = col.getNodeValue();
                }
            }
            this.buildFilmListFlash();
            return true;
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)ttmlFilePath, (Object)ex);
            return false;
        }
    }

    private String getAssTime(Date time) {
        String assTime = this.assFormat.format(time);
        return assTime.substring(0, assTime.length() - 1);
    }

    public void toAss(Path assFile) {
        try (FileOutputStream fos = new FileOutputStream(assFile.toFile());
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(osw);){
            writer.print("[Script Info]\n; Script generated by MediathekView\nScriptType: v4.00+\nScaledBorderAndShadow: yes\nYCbCr Matrix: None\n\n[V4+ Styles]\nFormat: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding\nStyle: Default,,22,,,,,0,0,0,0,100,100,0,0,3,1,0,2,10,10,25,1\n\n[Events]\nFormat: Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text\n");
            for (Subtitle title : this.subtitleList) {
                String titleRegion = title.region;
                String titleBegin = this.getAssTime(title.begin);
                String titleEnd = this.getAssTime(title.end);
                String titleText = "Dialogue: 0," + titleBegin + "," + titleEnd + ",Default,,0,0,0,,";
                if (titleRegion != null) {
                    titleText = titleText + "{\\an" + titleRegion + "}";
                }
                StringBuilder entryText = new StringBuilder();
                for (StyledString entry : title.listOfStrings) {
                    String entryBackgroundColorString;
                    if (!entryText.isEmpty()) {
                        entryText.append("\\N");
                    }
                    entryText.append("{");
                    String entryColorString = entry.getColor();
                    if (!entryColorString.isEmpty()) {
                        entryText.append("\\1c&H").append(this.colorToBGR(this.hexToColor(entryColorString))).append("&");
                    }
                    if (!(entryBackgroundColorString = entry.getBackgroundColor()).isEmpty()) {
                        Color entryBackgroundColor = this.hexToColor(entryBackgroundColorString);
                        entryText.append("\\3c&H").append(this.colorToBGR(entryBackgroundColor)).append("&");
                        entryText.append("\\3a&H").append(String.format("%02X", 255 - entryBackgroundColor.getAlpha())).append("&");
                    }
                    entryText.append("}");
                    entryText.append(entry.getText().replace("<br/>", "\\N"));
                }
                writer.println(titleText + String.valueOf(entryText));
            }
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)assFile, (Object)ex);
        }
    }

    public void toSrt(Path srtFile) {
        try (FileOutputStream fos = new FileOutputStream(srtFile.toFile());
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(osw);){
            long counter = 1L;
            for (Subtitle title : this.subtitleList) {
                writer.println(counter);
                writer.println(this.srtFormat.format(title.begin) + " --> " + this.srtFormat.format(title.end));
                for (StyledString entry : title.listOfStrings) {
                    String entryColor = entry.getColor();
                    if (!entryColor.isEmpty()) {
                        writer.print("<font color=\"" + entryColor + "\">");
                    }
                    writer.print(entry.getText());
                    if (!entryColor.isEmpty()) {
                        writer.print("</font>");
                    }
                    writer.println();
                }
                writer.println("");
                ++counter;
            }
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)srtFile, (Object)ex);
        }
    }

    @Override
    public void close() {
        this.colorMap.clear();
        this.subtitleList.clear();
    }
}

