/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.atom;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.url.Url;

public class AtomSprite
extends AbstractAtom
implements Atom {
    private final Sprite sprite;
    private final double scale;
    private final Url url;
    private final HColor fontColor;
    private final HColor forcedColor;

    public AtomSprite(HColor fontColor, HColor forcedColor, double scale, Sprite sprite, Url url) {
        this.scale = scale;
        this.sprite = sprite;
        this.url = url;
        this.fontColor = fontColor;
        this.forcedColor = forcedColor;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.sprite.asTextBlock(this.fontColor, this.forcedColor, this.scale).calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.sprite.asTextBlock(this.fontColor, this.forcedColor, this.scale).drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

