/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.PartialDatabaseObject;

public final class ProposedWeakAssociation
implements ColumnReference {
    private static final long serialVersionUID = 2986663326992262188L;
    private final Column primaryKeyColumn;
    private final Column foreignKeyColumn;

    ProposedWeakAssociation(Column foreignKeyColumn, Column primaryKeyColumn) {
        this.primaryKeyColumn = Objects.requireNonNull(primaryKeyColumn, "No primary key column provided");
        this.foreignKeyColumn = Objects.requireNonNull(foreignKeyColumn, "No foreign key column provided");
    }

    public int compareTo(ColumnReference o) {
        throw new UnsupportedOperationException();
    }

    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    public int getKeySequence() {
        throw new UnsupportedOperationException();
    }

    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public boolean isValid() {
        if (this.primaryKeyColumn.equals(this.foreignKeyColumn)) {
            return false;
        }
        boolean isPkColumnPartial = this.primaryKeyColumn instanceof PartialDatabaseObject;
        boolean isFkColumnPartial = this.foreignKeyColumn instanceof PartialDatabaseObject;
        if (isFkColumnPartial && isPkColumnPartial || !this.primaryKeyColumn.isColumnDataTypeKnown() || !this.foreignKeyColumn.isColumnDataTypeKnown()) {
            return false;
        }
        ColumnDataType fkColumnType = this.foreignKeyColumn.getColumnDataType();
        ColumnDataType pkColumnType = this.primaryKeyColumn.getColumnDataType();
        boolean isValid = fkColumnType.getStandardTypeName().equals(pkColumnType.getStandardTypeName());
        return isValid;
    }

    public String toString() {
        return this.foreignKeyColumn + " ~~> " + this.primaryKeyColumn;
    }
}

