/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.storeconfig.StoreAppender;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.SocketProperties;

public class ConnectorStoreAppender
extends StoreAppender {
    protected static final HashMap<String, String> replacements = new HashMap();
    protected static final Set<String> internalExecutorAttributes = new HashSet<String>();

    @Override
    public void printAttributes(PrintWriter printWriter, int n, boolean bl, Object object, StoreDescription storeDescription) throws Exception {
        if (bl && !storeDescription.isStandard()) {
            printWriter.print(" className=\"");
            printWriter.print(object.getClass().getName());
            printWriter.print("\"");
        }
        Connector connector = (Connector)object;
        String string = connector.getProtocol();
        List<String> list = this.getPropertyKeys(connector);
        Connector connector2 = new Connector(string);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            Object object3;
            String string2 = object2.next();
            Object object4 = IntrospectionUtils.getProperty((Object)object, (String)string2);
            if (storeDescription.isTransientAttribute(string2) || object4 == null || !this.isPersistable(object4.getClass()) || object4.equals(object3 = IntrospectionUtils.getProperty((Object)connector2, (String)string2)) || !this.isPrintValue(object, connector2, string2, storeDescription)) continue;
            this.printValue(printWriter, n, string2, object4);
        }
        if (string != null && !"HTTP/1.1".equals(string)) {
            super.printValue(printWriter, n, "protocol", string);
        }
        if (!"Internal".equals(object2 = connector.getExecutorName())) {
            super.printValue(printWriter, n, "executor", object2);
        }
    }

    protected List<String> getPropertyKeys(Connector connector) throws IntrospectionException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(connector.getClass()).getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || !this.isPersistable(propertyDescriptor.getPropertyType()) || propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null || "protocol".equals(propertyDescriptor.getName()) || "protocolHandlerClassName".equals(propertyDescriptor.getName())) continue;
            arrayList.add(propertyDescriptor.getName());
        }
        propertyDescriptorArray = Introspector.getBeanInfo(protocolHandler.getClass()).getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || !this.isPersistable(propertyDescriptor.getPropertyType()) || propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
            string = propertyDescriptor.getName();
            if (!"Internal".equals(connector.getExecutorName()) && internalExecutorAttributes.contains(string)) continue;
            if (replacements.get(string) != null) {
                string = replacements.get(string);
            }
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        propertyDescriptorArray = Introspector.getBeanInfo(SocketProperties.class).getPropertyDescriptors();
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || !this.isPersistable(propertyDescriptor.getPropertyType()) || propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
            string = propertyDescriptor.getName();
            if (replacements.get(string) != null) {
                string = replacements.get(string);
            }
            if (arrayList.contains(string)) continue;
            arrayList.add("socket." + propertyDescriptor.getName());
        }
        return arrayList;
    }

    protected void storeConnectorAttributes(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        if (storeDescription.isAttributes()) {
            this.printAttributes(printWriter, n, false, object, storeDescription);
        }
    }

    @Override
    public void printOpenTag(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        printWriter.print("<");
        printWriter.print(storeDescription.getTag());
        this.storeConnectorAttributes(printWriter, n, object, storeDescription);
        printWriter.println(">");
    }

    @Override
    public void printTag(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        printWriter.print("<");
        printWriter.print(storeDescription.getTag());
        this.storeConnectorAttributes(printWriter, n, object, storeDescription);
        printWriter.println("/>");
    }

    @Override
    public void printValue(PrintWriter printWriter, int n, String string, Object object) {
        String string2 = string;
        if (replacements.get(string) != null) {
            string2 = replacements.get(string);
        }
        super.printValue(printWriter, n, string2, object);
    }

    @Override
    public boolean isPrintValue(Object object, Object object2, String string, StoreDescription storeDescription) {
        boolean bl = super.isPrintValue(object, object2, string, storeDescription);
        if (bl && "jkHome".equals(string)) {
            File file;
            Connector connector = (Connector)object;
            File file2 = this.getCatalinaBase();
            bl = !file2.equals(file = this.getJkHomeBase((String)connector.getProperty("jkHome"), file2));
        }
        return bl;
    }

    protected File getCatalinaBase() {
        File file = new File(System.getProperty("catalina.base"));
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    protected File getJkHomeBase(String string, File file) {
        File file2;
        File file3 = new File(string);
        if (!file3.isAbsolute()) {
            file3 = new File(file, string);
        }
        try {
            file2 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = file3;
        }
        return file2;
    }

    static {
        replacements.put("timeout", "connectionUploadTimeout");
        replacements.put("randomfile", "randomFile");
        internalExecutorAttributes.add("maxThreads");
        internalExecutorAttributes.add("minSpareThreads");
        internalExecutorAttributes.add("threadPriority");
    }
}

