/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.servlet.InstanceFilterBinding;
import com.google.inject.servlet.InstanceServletBinding;
import com.google.inject.servlet.LinkedFilterBinding;
import com.google.inject.servlet.LinkedServletBinding;
import com.google.inject.servlet.ServletModuleTargetVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.eclipse.sisu.Description;
import org.eclipse.sisu.Priority;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.inject.DescriptionSource;
import org.eclipse.sisu.inject.Guice4;
import org.eclipse.sisu.inject.PrioritySource;

final class Implementations {
    private static final boolean HAS_GUICE_SERVLET;
    private static final boolean HAS_JSR250_PRIORITY;

    static {
        boolean hasJsr250Priority;
        boolean hasGuiceServlet;
        try {
            hasGuiceServlet = BindingTargetVisitor.class.isInstance(ServletFinder.THIS);
        }
        catch (LinkageError linkageError) {
            hasGuiceServlet = false;
        }
        HAS_GUICE_SERVLET = hasGuiceServlet;
        try {
            hasJsr250Priority = javax.annotation.Priority.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasJsr250Priority = false;
        }
        HAS_JSR250_PRIORITY = hasJsr250Priority;
    }

    private Implementations() {
    }

    public static Class<?> find(Binding<?> binding2) {
        return binding2.acceptTargetVisitor(ClassFinder.THIS);
    }

    public static <T extends Annotation> T getAnnotation(Binding<?> binding2, Class<T> annotationType) {
        boolean isPriority = Priority.class.equals(annotationType);
        Class<?> implementation = binding2.acceptTargetVisitor(HAS_GUICE_SERVLET && isPriority ? ServletFinder.THIS : ClassFinder.THIS);
        T annotation = null;
        if (implementation != null && (annotation = (T)implementation.getAnnotation(annotationType)) == null) {
            if (HAS_JSR250_PRIORITY && isPriority) {
                annotation = Implementations.adaptJsr250(binding2, implementation);
            } else if (Description.class.equals(annotationType)) {
                annotation = Implementations.adaptLegacy(binding2, implementation);
            }
        }
        return annotation;
    }

    private static <T extends Annotation> T adaptJsr250(Binding<?> binding2, Class<?> clazz) {
        javax.annotation.Priority jsr250 = clazz.getAnnotation(javax.annotation.Priority.class);
        return (T)(jsr250 != null ? new PrioritySource(binding2.getSource(), jsr250.value()) : null);
    }

    private static <T extends Annotation> T adaptLegacy(Binding<?> binding2, Class<?> clazz) {
        org.sonatype.inject.Description legacy = clazz.getAnnotation(org.sonatype.inject.Description.class);
        return (T)(legacy != null ? new DescriptionSource(binding2.getSource(), legacy.value()) : null);
    }

    static class ClassFinder
    extends DefaultBindingTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ClassFinder();

        ClassFinder() {
        }

        @Override
        public Class<?> visit(UntargettedBinding<?> binding2) {
            return binding2.getKey().getTypeLiteral().getRawType();
        }

        @Override
        public Class<?> visit(LinkedKeyBinding<?> binding2) {
            return binding2.getLinkedKey().getTypeLiteral().getRawType();
        }

        @Override
        public Class<?> visit(ConstructorBinding<?> binding2) {
            return binding2.getConstructor().getDeclaringType().getRawType();
        }

        @Override
        public Class<?> visit(InstanceBinding<?> binding2) {
            return binding2.getInstance().getClass();
        }

        @Override
        public Class<?> visit(ProviderInstanceBinding<?> binding2) {
            Provider<?> provider = Guice4.getProviderInstance(binding2);
            if (provider instanceof DeferredProvider) {
                try {
                    return ((DeferredProvider)provider).getImplementationClass().load();
                }
                catch (TypeNotPresentException typeNotPresentException) {}
            }
            return null;
        }

        @Override
        public Class<?> visit(ExposedBinding<?> binding2) {
            return (Class)binding2.getPrivateElements().getInjector().getBinding(binding2.getKey()).acceptTargetVisitor(this);
        }
    }

    static final class ServletFinder
    extends ClassFinder
    implements ServletModuleTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ServletFinder();

        ServletFinder() {
        }

        public Class<?> visit(InstanceFilterBinding binding2) {
            return binding2.getFilterInstance().getClass();
        }

        public Class<?> visit(InstanceServletBinding binding2) {
            return binding2.getServletInstance().getClass();
        }

        public Class<?> visit(LinkedFilterBinding binding2) {
            return binding2.getLinkedKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(LinkedServletBinding binding2) {
            return binding2.getLinkedKey().getTypeLiteral().getRawType();
        }
    }
}

