/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.AdminPermission;

class BundleURLConnection
extends URLConnection {
    static final Permission ADMIN_PERMISSION = new AdminPermission((String)null, "resource");
    private BundleResourceStream is = null;
    private FrameworkContext fwCtx;
    private BundleImpl bundle;
    private int contentLength;
    private String contentType;
    private long lastModified;

    BundleURLConnection(URL u, FrameworkContext fwCtx) {
        super(u);
        this.fwCtx = fwCtx;
    }

    private BundleArchive getBundleArchive() {
        this.bundle = null;
        long gen = 0L;
        try {
            String s = this.url.getHost();
            int i = s.indexOf(33);
            if (i >= 0) {
                s = s.substring(0, i);
            }
            if ((i = s.indexOf(46)) >= 0) {
                gen = Long.parseLong(s.substring(i + 1));
                s = s.substring(0, i);
            }
            this.bundle = (BundleImpl)this.fwCtx.bundles.getBundle(Long.parseLong(s));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.bundle != null) {
            return this.bundle.getBundleArchive(gen);
        }
        return null;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            BundleArchive a = this.getBundleArchive();
            if (a != null) {
                int port = this.url.getPort();
                this.is = this.bundle.secure.callGetBundleResourceStream(a, this.url.getFile(), port != -1 ? port : 0);
            }
            if (this.is != null) {
                this.connected = true;
                this.contentLength = FWProps.androidApiLevel >= 0 ? -1 : (int)this.is.getContentLength();
                this.contentType = URLConnection.guessContentTypeFromName(this.url.getFile());
                this.lastModified = a.getLastModified();
            } else {
                throw new IOException("URL not found");
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.is;
    }

    @Override
    public String getContentType() {
        try {
            this.connect();
            return this.contentType;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
            return this.contentLength;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public long getLastModified() {
        try {
            this.connect();
            return this.lastModified;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public Permission getPermission() throws IOException {
        return ADMIN_PERMISSION;
    }
}

