/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.importer.DeclarationHandler;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.GenericMemberTypeProcessor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureReader;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.signature.SignatureVisitor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaFieldTypeSignatureImporter {
    private static final Logger log = LoggerFactory.getLogger(JavaFieldTypeSignatureImporter.class);

    JavaFieldTypeSignatureImporter() {
    }

    static Optional<DomainBuilders.JavaTypeCreationProcess<JavaField>> parseAsmFieldTypeSignature(String signature, DeclarationHandler declarationHandler) {
        if (signature == null) {
            return Optional.empty();
        }
        log.trace("Analyzing field signature: {}", (Object)signature);
        SignatureProcessor signatureProcessor = new SignatureProcessor(declarationHandler);
        new SignatureReader(signature).accept(signatureProcessor);
        return signatureProcessor.getFieldType();
    }

    private static class SignatureProcessor
    extends SignatureVisitor {
        private final GenericMemberTypeProcessor<JavaField> genericFieldTypeProcessor;

        SignatureProcessor(DeclarationHandler declarationHandler) {
            super(589824);
            this.genericFieldTypeProcessor = new GenericMemberTypeProcessor(declarationHandler);
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return this.genericFieldTypeProcessor;
        }

        Optional<DomainBuilders.JavaTypeCreationProcess<JavaField>> getFieldType() {
            return this.genericFieldTypeProcessor.getType();
        }
    }
}

