/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.NodeStyleDeclaration;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AnimationShorthandBuilder;
import io.sf.carte.doc.style.css.om.AnimationShorthandSetter;
import io.sf.carte.doc.style.css.om.BackgroundBuilder;
import io.sf.carte.doc.style.css.om.BackgroundShorthandSetter;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BorderBuilder;
import io.sf.carte.doc.style.css.om.BorderColorShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderImageBuilder;
import io.sf.carte.doc.style.css.om.BorderImageShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderRadiusBuilder;
import io.sf.carte.doc.style.css.om.BorderRadiusShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderSideShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.BorderWidthShorthandSetter;
import io.sf.carte.doc.style.css.om.BoxShorthandSetter;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.ColumnRuleShorthandSetter;
import io.sf.carte.doc.style.css.om.ColumnsShorthandSetter;
import io.sf.carte.doc.style.css.om.CueShorthandSetter;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import io.sf.carte.doc.style.css.om.FlexShorthandBuilder;
import io.sf.carte.doc.style.css.om.FlexShorthandSetter;
import io.sf.carte.doc.style.css.om.FontBuilder;
import io.sf.carte.doc.style.css.om.FontShorthandSetter;
import io.sf.carte.doc.style.css.om.FontVariantBuilder;
import io.sf.carte.doc.style.css.om.FontVariantShorthandSetter;
import io.sf.carte.doc.style.css.om.GenericShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridAreaShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridAreaShorthandSetter;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridPlacementShorthandSetter;
import io.sf.carte.doc.style.css.om.GridShorthandBuilder;
import io.sf.carte.doc.style.css.om.GridShorthandSetter;
import io.sf.carte.doc.style.css.om.GridTemplateShorthandSetter;
import io.sf.carte.doc.style.css.om.ListStyleShorthandBuilder;
import io.sf.carte.doc.style.css.om.ListStyleShorthandSetter;
import io.sf.carte.doc.style.css.om.MarginBuilder;
import io.sf.carte.doc.style.css.om.MarginShorthandSetter;
import io.sf.carte.doc.style.css.om.MaskBuilder;
import io.sf.carte.doc.style.css.om.MaskShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoIdentifierShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoLPIShorthandSetter;
import io.sf.carte.doc.style.css.om.OrderedTwoValueShorthandBuilder;
import io.sf.carte.doc.style.css.om.PaddingBuilder;
import io.sf.carte.doc.style.css.om.PendingSubstitutionSetter;
import io.sf.carte.doc.style.css.om.PropertyCSSHandler;
import io.sf.carte.doc.style.css.om.SafeSystemDefaultValue;
import io.sf.carte.doc.style.css.om.SequenceShorthandBuilder;
import io.sf.carte.doc.style.css.om.SequenceShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.om.SubpropertySetter;
import io.sf.carte.doc.style.css.om.TransitionShorthandBuilder;
import io.sf.carte.doc.style.css.om.TransitionShorthandSetter;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.Diff;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSS2Properties;

public class BaseCSSStyleDeclaration
extends AbstractCSSStyleDeclaration
implements CSS2Properties,
Cloneable {
    private static final long serialVersionUID = 2L;
    private final BaseCSSDeclarationRule parentRule;
    private HashMap<String, StyleValue> propValue;
    private ArrayList<String> propertyList;
    private ArrayList<String> priorities;
    private ArrayList<String> shorthandSet;

    protected BaseCSSStyleDeclaration(BaseCSSDeclarationRule baseCSSDeclarationRule) {
        this.parentRule = baseCSSDeclarationRule;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new ArrayList(6);
    }

    public BaseCSSStyleDeclaration() {
        this.parentRule = null;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandSet = new ArrayList(6);
    }

    protected BaseCSSStyleDeclaration(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        this.parentRule = baseCSSStyleDeclaration.getParentRule();
        this.setProperties(baseCSSStyleDeclaration);
    }

    void setProperties(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        this.priorities = (ArrayList)baseCSSStyleDeclaration.priorities.clone();
        this.propertyList = (ArrayList)baseCSSStyleDeclaration.propertyList.clone();
        this.propValue = this.deepClone(baseCSSStyleDeclaration.propValue);
        this.shorthandSet = (ArrayList)baseCSSStyleDeclaration.shorthandSet.clone();
    }

    private HashMap<String, StyleValue> deepClone(HashMap<String, StyleValue> hashMap) {
        HashMap<String, StyleValue> hashMap2 = new HashMap<String, StyleValue>(hashMap.size());
        for (Map.Entry<String, StyleValue> entry : hashMap.entrySet()) {
            StyleValue styleValue = entry.getValue();
            if (styleValue.getCssValueType() == CSSValue.CssType.SHORTHAND) {
                styleValue = styleValue.clone();
            }
            hashMap2.put(entry.getKey(), styleValue);
        }
        return hashMap2;
    }

    @Override
    public String getMinifiedCssText() {
        LinkedList<String> linkedList = new LinkedList<String>(this.shorthandSet);
        int n = this.propertyList.size();
        StringBuilder stringBuilder = new StringBuilder(50 + n * 10);
        for (int i = 0; i < n; ++i) {
            String string = this.propertyList.get(i);
            String string2 = this.priorities.get(i);
            boolean bl = "important".equals(string2);
            StyleValue styleValue = this.propValue.get(string);
            CSSValue.CssType cssType = styleValue.getCssValueType();
            if (cssType != CSSValue.CssType.SHORTHAND && styleValue.isSubproperty()) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    ShorthandValue shorthandValue = (ShorthandValue)this.propValue.get(string3);
                    if (!shorthandValue.isSetSubproperty(string) || bl != shorthandValue.isImportant()) continue;
                    iterator.remove();
                    this.appendShorthandMinifiedCssText(stringBuilder, string3, shorthandValue);
                }
                continue;
            }
            styleValue = this.getCSSValue(string);
            this.appendLonghandMinifiedCssText(stringBuilder, string, styleValue, bl);
            if (i == n - 1) continue;
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    protected void appendShorthandMinifiedCssText(StringBuilder stringBuilder, String string, ShorthandValue shorthandValue) {
        stringBuilder.append(string).append(':').append(shorthandValue.getMinifiedCssText(string));
        if (shorthandValue.isImportant()) {
            stringBuilder.append("!important");
        }
        stringBuilder.append(';');
    }

    protected void appendLonghandMinifiedCssText(StringBuilder stringBuilder, String string, StyleValue styleValue, boolean bl) {
        stringBuilder.append(string).append(':').append(styleValue.getMinifiedCssText(string));
        if (bl) {
            stringBuilder.append("!important");
        }
    }

    @Override
    public String getCssText() {
        AbstractCSSStyleSheet abstractCSSStyleSheet;
        StyleFormattingContext styleFormattingContext = null;
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.getParentRule();
        if (baseCSSDeclarationRule != null && (abstractCSSStyleSheet = baseCSSDeclarationRule.getParentStyleSheet()) != null) {
            styleFormattingContext = abstractCSSStyleSheet.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        }
        if (styleFormattingContext == null) {
            styleFormattingContext = new DefaultStyleFormattingContext();
        }
        abstractCSSStyleSheet = new BufferSimpleWriter(50 + this.propertyList.size() * 16);
        try {
            this.writeCssText((SimpleWriter)abstractCSSStyleSheet, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return abstractCSSStyleSheet.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>(this.shorthandSet);
        int n = this.propertyList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = this.propertyList.get(i);
            String string2 = this.priorities.get(i);
            boolean bl = "important".equals(string2);
            CSSValue cSSValue = this.propValue.get(string);
            CSSValue.CssType cssType = cSSValue.getCssValueType();
            if (cssType != CSSValue.CssType.SHORTHAND && ((StyleValue)cSSValue).isSubproperty()) {
                object = linkedList.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    ShorthandValue shorthandValue = (ShorthandValue)this.propValue.get(string3);
                    if (!shorthandValue.isSetSubproperty(string) || bl != shorthandValue.isImportant()) continue;
                    object.remove();
                    this.writeShorthandCssText(simpleWriter, styleFormattingContext, string3, shorthandValue);
                }
                continue;
            }
            object = this.getCSSValue(string);
            this.writeLonghandCssText(simpleWriter, styleFormattingContext, string, (StyleValue)object, bl);
        }
    }

    protected void writeShorthandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, ShorthandValue shorthandValue) throws IOException {
        styleFormattingContext.startPropertyDeclaration(simpleWriter);
        simpleWriter.write((CharSequence)string);
        styleFormattingContext.writeColon(simpleWriter);
        styleFormattingContext.writeShorthandValue(simpleWriter, string, shorthandValue);
        if (shorthandValue.isImportant()) {
            styleFormattingContext.writeImportantPriority(simpleWriter);
        }
        styleFormattingContext.writeSemiColon(simpleWriter);
        styleFormattingContext.endPropertyDeclaration(simpleWriter);
    }

    protected void writeLonghandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, StyleValue styleValue, boolean bl) throws IOException {
        styleFormattingContext.startPropertyDeclaration(simpleWriter);
        simpleWriter.write((CharSequence)string);
        styleFormattingContext.writeColon(simpleWriter);
        styleFormattingContext.writeValue(simpleWriter, string, styleValue);
        if (bl) {
            styleFormattingContext.writeImportantPriority(simpleWriter);
        }
        styleFormattingContext.writeSemiColon(simpleWriter);
        styleFormattingContext.endPropertyDeclaration(simpleWriter);
    }

    String getComputedPlainCssText() {
        if (!this.propertyList.isEmpty()) {
            int n = this.propertyList.size();
            BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + n * 18);
            DeclarationFormattingContext declarationFormattingContext = this.getFormattingContext();
            try {
                this.writeComputedCssText((SimpleWriter)bufferSimpleWriter, declarationFormattingContext);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bufferSimpleWriter.toString();
        }
        return "";
    }

    void writeComputedCssText(SimpleWriter simpleWriter, DeclarationFormattingContext declarationFormattingContext) throws IOException {
        for (String string : this.propertyList) {
            declarationFormattingContext.startPropertyDeclaration(simpleWriter);
            simpleWriter.write((CharSequence)string);
            declarationFormattingContext.writeColon(simpleWriter);
            declarationFormattingContext.writeValue(simpleWriter, string, this.getCSSValue(string));
            declarationFormattingContext.writeSemiColon(simpleWriter);
            declarationFormattingContext.endPropertyDeclaration(simpleWriter);
        }
    }

    String getOptimizedCssText() {
        String string;
        String string2;
        int n = this.propertyList.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        HashSet<String> hashSet = new HashSet<String>(n);
        HashMap<String, ShorthandBuilder> hashMap = new HashMap<String, ShorthandBuilder>();
        ShorthandDatabase shorthandDatabase = ShorthandDatabase.getInstance();
        StringBuilder stringBuilder = new StringBuilder(50 + n * 24);
        for (int i = 0; i < n; ++i) {
            string2 = this.propertyList.get(i);
            String string3 = shorthandDatabase.getShorthand(string2);
            string = this.priorities.get(i);
            boolean bl = "important".equals(string);
            if (string3 != null) {
                String string4;
                ShorthandBuilder shorthandBuilder;
                String string5 = shorthandDatabase.getShorthand(string3);
                if (string5 != null) {
                    string3 = string5;
                }
                if ((shorthandBuilder = (ShorthandBuilder)hashMap.get(string4 = '&' + string3)) == null) {
                    shorthandBuilder = this.createBuilder(string3);
                    if (shorthandBuilder == null) {
                        arrayList.add(string2);
                        if (!bl) continue;
                        hashSet.add(string2);
                        continue;
                    }
                    hashMap.put(string4, shorthandBuilder);
                    arrayList.add(string4);
                }
                shorthandBuilder.addAssignedProperty(string2, bl);
                continue;
            }
            arrayList.add(string2);
            if (!bl) continue;
            hashSet.add(string2);
        }
        if (arrayList.contains("&border-image") && arrayList.contains("&border")) {
            arrayList.remove("&border-image");
            hashMap.remove("&border-image");
        }
        if (arrayList.contains("&font-variant") && arrayList.contains("&font")) {
            arrayList.remove("&font-variant");
            hashMap.remove("&font-variant");
        }
        if (arrayList.contains("&grid-row") && arrayList.contains("&grid-column")) {
            arrayList.remove("&grid-row");
            arrayList.remove("&grid-column");
            if (!arrayList.contains("&grid-area")) {
                arrayList.add("&grid-area");
                hashMap.put("&grid-area", this.createBuilder("grid-area"));
            }
            hashMap.remove("&grid-row");
            hashMap.remove("&grid-column");
        } else if (arrayList.contains("&grid-row") && arrayList.contains("&grid-area")) {
            arrayList.remove("&grid-row");
            hashMap.remove("&grid-row");
        } else if (arrayList.contains("&grid-column") && arrayList.contains("&grid-area")) {
            arrayList.remove("&grid-column");
            hashMap.remove("&grid-column");
        }
        DeclarationFormattingContext declarationFormattingContext = this.getFormattingContext();
        string2 = new BufferSimpleWriter(stringBuilder);
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            string = (String)arrayList.get(i);
            if (string.charAt(0) == '&') {
                ((ShorthandBuilder)hashMap.get(string)).appendMinifiedCssText(stringBuilder);
                continue;
            }
            StyleValue styleValue = this.getCSSValue(string);
            stringBuilder.append(string).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText((BufferSimpleWriter)string2, declarationFormattingContext, styleValue, string);
            if (hashSet.contains(string)) {
                stringBuilder.append("!important");
            }
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    DeclarationFormattingContext getFormattingContext() {
        AbstractCSSStyleSheetFactory abstractCSSStyleSheetFactory = this.getStyleSheetFactory();
        DeclarationFormattingContext declarationFormattingContext = abstractCSSStyleSheetFactory != null ? abstractCSSStyleSheetFactory.getStyleFormattingFactory().createComputedStyleFormattingContext() : new DefaultStyleFormattingContext();
        return declarationFormattingContext;
    }

    static void appendCssText(StringBuilder stringBuilder, StyleValue styleValue) {
        String string = !styleValue.isSystemDefault() ? styleValue.getCssText() : "initial";
        stringBuilder.append(string);
    }

    static void appendMinifiedCssText(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, StyleValue styleValue, String string) {
        if (!styleValue.isSystemDefault()) {
            try {
                declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, string, styleValue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StringBuilder stringBuilder = bufferSimpleWriter.getBuffer();
            try {
                if (stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            bufferSimpleWriter.write((CharSequence)"initial");
        }
    }

    ShorthandBuilder createBuilder(String string) {
        if ("border".equals(string)) {
            return new BorderBuilder(this);
        }
        if ("background".equals(string)) {
            return new BackgroundBuilder(this);
        }
        if ("border-image".equals(string)) {
            return new BorderImageBuilder(this);
        }
        if ("margin".equals(string)) {
            return new MarginBuilder(this);
        }
        if ("padding".equals(string)) {
            return new PaddingBuilder(this);
        }
        if ("font".equals(string)) {
            return new FontBuilder(this);
        }
        if ("font-variant".equals(string)) {
            return new FontVariantBuilder(this);
        }
        if ("border-radius".equals(string)) {
            return new BorderRadiusBuilder(this);
        }
        if ("list-style".equals(string)) {
            return new ListStyleShorthandBuilder(this);
        }
        if ("text-decoration".equals(string) || "outline".equals(string) || "text-emphasis".equals(string) || "column-rule".equals(string)) {
            return new GenericShorthandBuilder(string, this, "none");
        }
        if ("flex".equals(string)) {
            return new FlexShorthandBuilder(this);
        }
        if ("flex-flow".equals(string)) {
            return new GenericShorthandBuilder(string, this, "row");
        }
        if ("columns".equals(string)) {
            return new GenericShorthandBuilder(string, this, "auto");
        }
        if ("grid-column".equals(string) || "grid-row".equals(string)) {
            return new GridPlacementShorthandBuilder(string, this);
        }
        if ("grid-area".equals(string)) {
            return new GridAreaShorthandBuilder(this);
        }
        if ("grid".equals(string) || "grid-template".equals(string)) {
            return new GridShorthandBuilder(this);
        }
        if ("animation".equals(string)) {
            return new AnimationShorthandBuilder(this);
        }
        if ("transition".equals(string)) {
            return new TransitionShorthandBuilder(this);
        }
        if ("mask".equals(string)) {
            return new MaskBuilder(this);
        }
        if ("cue".equals(string) || "pause".equals(string) || "rest".equals(string)) {
            return new SequenceShorthandBuilder(string, this);
        }
        if ("place-content".equals(string) || "place-items".equals(string) || "place-self".equals(string) || "gap".equals(string)) {
            return new OrderedTwoValueShorthandBuilder(string, this, "normal");
        }
        return null;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.getParentRule();
        if (baseCSSDeclarationRule != null) {
            return baseCSSDeclarationRule.getStyleDeclarationErrorHandler();
        }
        return null;
    }

    @Override
    public void setCssText(String string) throws DOMException {
        Parser parser = this.createSACParser();
        StyleDeclarationHandler styleDeclarationHandler = new StyleDeclarationHandler();
        styleDeclarationHandler.setLexicalPropertyListener(this);
        parser.setErrorHandler(styleDeclarationHandler);
        parser.setDocumentHandler(styleDeclarationHandler);
        StringReader stringReader = new StringReader(string);
        this.clear();
        try {
            parser.parseStyleDeclaration(stringReader);
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
    }

    private Parser createSACParser() throws DOMException {
        AbstractCSSStyleSheetFactory abstractCSSStyleSheetFactory = this.getStyleSheetFactory();
        Parser parser = abstractCSSStyleSheetFactory != null ? abstractCSSStyleSheetFactory.createSACParser() : new CSSOMParser();
        return parser;
    }

    @Override
    protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
        AbstractCSSStyleSheet abstractCSSStyleSheet;
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.getParentRule();
        if (baseCSSDeclarationRule != null && (abstractCSSStyleSheet = baseCSSDeclarationRule.getParentStyleSheet()) != null) {
            return abstractCSSStyleSheet.getStyleSheetFactory();
        }
        return null;
    }

    protected ValueFactory getValueFactory() {
        AbstractCSSStyleSheetFactory abstractCSSStyleSheetFactory = this.getStyleSheetFactory();
        return abstractCSSStyleSheetFactory != null ? abstractCSSStyleSheetFactory.getValueFactory() : new ValueFactory();
    }

    @Override
    public String getPropertyValue(String string) {
        StyleValue styleValue = this.getCSSValue(string = this.getCanonicalPropertyName(string));
        if (styleValue != null) {
            CSSValue.CssType cssType = styleValue.getCssValueType();
            if (cssType == CSSValue.CssType.TYPED) {
                CSSValue.Type type = styleValue.getPrimitiveType();
                if (type == CSSValue.Type.STRING || type == CSSValue.Type.IDENT) {
                    return ((CSSTypedValue)((Object)styleValue)).getStringValue();
                }
            } else if (cssType == CSSValue.CssType.SHORTHAND && ((HashSet)((ShorthandValue)styleValue).getLonghands()).size() < this.getLonghandPropertyCount(string)) {
                return "";
            }
            return styleValue.getCssText();
        }
        return "";
    }

    private int getLonghandPropertyCount(String string) {
        String[] stringArray;
        int n = "font".equals(string) ? 17 : ((stringArray = ShorthandDatabase.getInstance().getLonghandProperties(string)) != null ? stringArray.length : Integer.MAX_VALUE);
        return n;
    }

    @Override
    public StyleValue getPropertyCSSValue(String string) {
        string = this.getCanonicalPropertyName(string);
        if (ShorthandDatabase.getInstance().isShorthand(string)) {
            return null;
        }
        return this.getCSSValue(string);
    }

    String getCanonicalPropertyName(String string) {
        if (string.length() > 2 && (string.charAt(0) != '-' || string.charAt(1) != '-')) {
            string = string.toLowerCase(Locale.ROOT);
        }
        return string;
    }

    protected StyleValue getCSSValue(String string) {
        return this.getDeclaredCSSValue(string);
    }

    protected StyleValue getDeclaredCSSValue(String string) {
        return this.propValue.get(string);
    }

    public StyleValue computeBoundProperty(String string, String string2, StyleValue styleValue) {
        ValueList valueList;
        StyleValue styleValue2 = this.getCSSValue(string);
        if (styleValue2 == null) {
            return null;
        }
        int n = 1;
        if (styleValue2.getCssValueType() == CSSValue.CssType.LIST && (valueList = (ValueList)styleValue2).isCommaSeparated()) {
            n = valueList.getLength();
        }
        if (n == 1) {
            if (styleValue == null) {
                styleValue = PropertyDatabase.getInstance().getInitialValue(string2);
            }
        } else {
            styleValue = this.computeSubpropertyList(styleValue, n);
        }
        return styleValue;
    }

    ValueList computeSubpropertyList(StyleValue styleValue, int n) {
        ValueList valueList;
        block6: {
            int n2;
            if (styleValue.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)styleValue).isCommaSeparated()) {
                valueList = (ValueList)styleValue.clone();
                n2 = valueList.getLength();
            } else {
                valueList = ValueList.createCSValueList();
                valueList.add(styleValue);
                n2 = 1;
            }
            if (n == n2) break block6;
            if (n < n2) {
                while (n2 > n) {
                    valueList.remove(--n2);
                }
            } else {
                int n3 = 0;
                while (n2++ < n) {
                    valueList.add(valueList.item(n3++));
                }
            }
        }
        return valueList;
    }

    @Override
    public String removeProperty(String string) {
        int n = this.propertyList.indexOf(string = this.getCanonicalPropertyName(string));
        if (n >= 0 && !this.propValue.get(string).isSubproperty()) {
            ShorthandDatabase shorthandDatabase;
            String string2 = this.propValue.remove(string).getCssText();
            this.propertyList.remove(n);
            this.priorities.remove(n);
            if (!this.shorthandSet.isEmpty() && (shorthandDatabase = ShorthandDatabase.getInstance()).isShorthandSubproperty(string)) {
                this.resetFromShorthand(string, shorthandDatabase);
            }
            return string2;
        }
        if (this.shorthandSet.contains(string)) {
            ShorthandValue shorthandValue = (ShorthandValue)this.propValue.get(string);
            this.propValue.remove(string);
            this.shorthandSet.remove(string);
            String string3 = shorthandValue.getCssText();
            ShorthandDatabase shorthandDatabase = ShorthandDatabase.getInstance();
            this.removeSubproperties(shorthandValue, shorthandDatabase);
            return string3;
        }
        return "";
    }

    private boolean resetFromShorthand(String string, ShorthandDatabase shorthandDatabase) {
        String object = string;
        int n = -1;
        for (String object2 : this.shorthandSet) {
            ShorthandValue shorthandValue;
            String string2;
            int n2;
            if (!shorthandDatabase.isShorthandSubpropertyOf(object2, string) || (n2 = this.propertyList.indexOf(string2 = (String)((HashSet)(shorthandValue = (ShorthandValue)this.propValue.get(object2)).getLonghands()).iterator().next())) <= n) continue;
            n = n2;
            object = object2;
        }
        if (n != -1) {
            ShorthandValue shorthandValue = (ShorthandValue)this.propValue.get(object);
            ((HashSet)shorthandValue.getLonghands()).add(string);
            BaseCSSStyleDeclaration baseCSSStyleDeclaration = new BaseCSSStyleDeclaration();
            baseCSSStyleDeclaration.setSubproperties(object, shorthandValue.getLexicalUnit(), shorthandValue.isImportant(), shorthandValue.isAttrTainted());
            this.propValue.put(string, baseCSSStyleDeclaration.propValue.get(string));
            this.priorities.add(n, shorthandValue.isImportant() ? "important" : null);
            this.propertyList.add(n, string);
            return true;
        }
        return false;
    }

    private void removeSubproperties(ShorthandValue shorthandValue, ShorthandDatabase shorthandDatabase) {
        Set set = shorthandValue.getLonghands();
        for (String string : set) {
            int n = this.propertyList.indexOf(string);
            this.propertyList.remove(n);
            this.priorities.remove(n);
            this.propValue.remove(string);
            if (this.shorthandSet.isEmpty()) continue;
            this.resetFromShorthand(string, shorthandDatabase);
        }
    }

    @Override
    public String getPropertyPriority(String string) {
        int n = this.propertyList.indexOf(string);
        if (n == -1) {
            return this.getUnknownPropertyPriority(string);
        }
        String string2 = this.priorities.get(n);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    String getUnknownPropertyPriority(String string) {
        if (this.shorthandSet.contains(string) && ((ShorthandValue)this.propValue.get(string)).isImportant()) {
            return "important";
        }
        return this.checkShorthandPriority(string);
    }

    String checkShorthandPriority(String string) {
        ShorthandDatabase shorthandDatabase = ShorthandDatabase.getInstance();
        if (shorthandDatabase.isShorthand(string)) {
            String[] stringArray;
            for (String string2 : stringArray = shorthandDatabase.getLonghandProperties(string)) {
                if (this.isPropertyImportant(string2)) continue;
                return "";
            }
            return "important";
        }
        return "";
    }

    @Override
    public void setLexicalProperty(String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        string = this.getCanonicalPropertyName(string);
        LexicalValue lexicalValue = new LexicalValue();
        lexicalValue.setLexicalUnit(lexicalUnit);
        this.setProperty(string, lexicalValue, bl);
    }

    @Override
    public void setProperty(String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        string = this.getCanonicalPropertyName(string);
        ShorthandDatabase shorthandDatabase = ShorthandDatabase.getInstance();
        if (shorthandDatabase.isShorthand(string)) {
            this.setShorthandProperty(shorthandDatabase, string, lexicalUnit, bl);
        } else {
            this.setLonghandProperty(string, lexicalUnit, bl);
        }
    }

    private void setShorthandProperty(ShorthandDatabase shorthandDatabase, String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        ShorthandValue shorthandValue = (ShorthandValue)this.propValue.get(string);
        if (shorthandValue == null || bl || !shorthandValue.isImportant()) {
            LinkedList<String> linkedList = null;
            if (!this.shorthandSet.isEmpty()) {
                if (this.shorthandSet.contains(string)) {
                    linkedList = new LinkedList<String>();
                    linkedList.add(string);
                }
                for (String string2 : this.shorthandSet) {
                    if (shorthandDatabase.isShorthandSubpropertyOf(string, string2)) {
                        if (!bl && ((ShorthandValue)this.propValue.get(string2)).isImportant()) continue;
                        if (linkedList == null) {
                            linkedList = new LinkedList();
                        }
                        linkedList.add(string2);
                        continue;
                    }
                    if (!shorthandDatabase.isShorthandSubpropertyOf(string2, string) || bl || !((ShorthandValue)this.propValue.get(string2)).isImportant()) continue;
                    return;
                }
            }
            this.setShorthandLonghands(string, lexicalUnit, bl, linkedList, false);
        }
    }

    boolean setShorthandLonghands(String string, LexicalUnit lexicalUnit, boolean bl, LinkedList<String> linkedList, boolean bl2) {
        try {
            SubpropertySetter subpropertySetter = this.setSubproperties(string, lexicalUnit, bl, bl2);
            String string2 = subpropertySetter.getCssText();
            if (!string2.isEmpty()) {
                ShorthandValue shorthandValue = subpropertySetter.createCSSShorthandValue(lexicalUnit);
                shorthandValue.setShorthandText(string2, subpropertySetter.getMinifiedCssText());
                if (linkedList != null) {
                    for (String string3 : linkedList) {
                        this.shorthandSet.remove(string3);
                        this.propValue.remove(string3);
                    }
                }
                this.propValue.put(string, shorthandValue);
                this.shorthandSet.add(string);
            } else {
                this.shorthandWarning(string, lexicalUnit, bl);
            }
            return true;
        }
        catch (DOMException dOMException) {
            this.shorthandError(string, lexicalUnit, bl, linkedList, dOMException);
            return false;
        }
    }

    void shorthandWarning(String string, LexicalUnit lexicalUnit, boolean bl) {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
        if (styleDeclarationErrorHandler != null) {
            styleDeclarationErrorHandler.shorthandWarning(string, BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit));
        }
    }

    void compatWarning(String string, LexicalUnit lexicalUnit, boolean bl) {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
        if (styleDeclarationErrorHandler != null) {
            String string2 = BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit);
            StringBuilder stringBuilder = new StringBuilder(string2.length());
            stringBuilder.append(string2);
            if (bl) {
                stringBuilder.append("!important");
            }
            styleDeclarationErrorHandler.compatWarning(string, stringBuilder.toString());
        }
    }

    protected void shorthandError(String string, LexicalUnit lexicalUnit, boolean bl, LinkedList<String> linkedList, DOMException dOMException) {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
        if (styleDeclarationErrorHandler != null) {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Wrong value for " + string);
            cSSPropertyValueException.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit));
            styleDeclarationErrorHandler.wrongValue(string, cSSPropertyValueException);
        }
    }

    protected void setLonghandProperty(String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        StyleValue styleValue;
        ValueFactory valueFactory = this.getValueFactory();
        try {
            styleValue = valueFactory.createCSSValue(lexicalUnit, this);
        }
        catch (DOMException dOMException) {
            if (string.charAt(0) == '-') {
                LexicalValue lexicalValue = new LexicalValue();
                lexicalValue.setLexicalUnit(lexicalUnit);
                styleValue = lexicalValue;
            }
            StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
            if (styleDeclarationErrorHandler != null) {
                CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Wrong value for " + string, dOMException);
                cSSPropertyValueException.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(lexicalUnit));
                styleDeclarationErrorHandler.wrongValue(string, cSSPropertyValueException);
            }
            throw dOMException;
        }
        if (string.equals("font-family") || string.equals("content")) {
            if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList valueList = (ValueList)styleValue;
                if (valueList.isCommaSeparated()) {
                    int n = valueList.getLength();
                    for (int i = 0; i < n; ++i) {
                        if (valueList.item(i).getCssValueType() != CSSValue.CssType.LIST) continue;
                        valueList.set(i, this.listToString((ValueList)valueList.item(i)));
                    }
                } else {
                    styleValue = this.listToString(valueList);
                }
            }
        } else if (string.equals("background-position") && styleValue.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated()) {
                int n = valueList.getLength();
                for (int i = 0; i < n; ++i) {
                    StyleValue styleValue2 = valueList.item(i);
                    if (styleValue2.getCssValueType() != CSSValue.CssType.LIST || BaseCSSStyleDeclaration.checkBackgroundPosition((ValueList)styleValue2)) continue;
                    valueList.remove(i--);
                    this.wrongBackgroundPositionError(styleValue2.getCssText());
                }
                if (valueList.getLength() == 0) {
                    return;
                }
            } else if (!BaseCSSStyleDeclaration.checkBackgroundPosition(valueList)) {
                this.wrongBackgroundPositionError(valueList.getCssText());
                return;
            }
        }
        this.setProperty(string, styleValue, bl);
    }

    private void wrongBackgroundPositionError(String string) {
        StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
        if (styleDeclarationErrorHandler != null) {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Wrong value for background-position");
            cSSPropertyValueException.setValueText(string);
            styleDeclarationErrorHandler.wrongValue("background-position", cSSPropertyValueException);
        }
    }

    private StyleValue listToString(ValueList valueList) {
        int n = valueList.getLength();
        boolean bl = true;
        for (int i = 1; i < n; ++i) {
            StyleValue styleValue = valueList.item(i);
            if (styleValue.getCssValueType() == CSSValue.CssType.TYPED && styleValue.getPrimitiveType() == CSSValue.Type.IDENT) continue;
            bl = false;
            break;
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(n * 7 + 8);
            stringBuilder.append(valueList.item(0).getCssText());
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(' ').append(valueList.item(i).getCssText());
            }
            StringValue stringValue = new StringValue();
            stringValue.setStringValue(CSSValue.Type.STRING, stringBuilder.toString());
            return stringValue;
        }
        return valueList;
    }

    private static boolean checkBackgroundPosition(ValueList valueList) {
        int n = valueList.getLength();
        if (n < 3) {
            return true;
        }
        if (n == 4) {
            return valueList.item(0).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(1).getPrimitiveType() != CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(3).getPrimitiveType() != CSSValue.Type.IDENT;
        }
        if (valueList.item(0).getPrimitiveType() != CSSValue.Type.IDENT) {
            return false;
        }
        if (valueList.item(1).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() != CSSValue.Type.IDENT) {
            return true;
        }
        return valueList.item(1).getPrimitiveType() != CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() == CSSValue.Type.IDENT;
    }

    @Override
    public void setProperty(String string, String string2, String string3) throws DOMException {
        LexicalUnit lexicalUnit;
        Parser parser;
        if (string2.length() == 0) {
            this.removeProperty(string);
            return;
        }
        try {
            parser = this.createSACParser();
        }
        catch (DOMException dOMException) {
            throw new DOMException(7, dOMException.getMessage());
        }
        StringReader stringReader = new StringReader(string2);
        try {
            lexicalUnit = parser.parsePropertyValue(stringReader);
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        boolean bl = "important".equalsIgnoreCase(string3);
        this.setProperty(string, lexicalUnit, bl);
    }

    boolean setProperty(String string, StyleValue styleValue, boolean bl) {
        String string2;
        string = string.intern();
        String string3 = string2 = bl ? "important" : null;
        if (!this.propertyList.contains(string)) {
            this.addProperty(string, styleValue, string2);
            return true;
        }
        return this.replaceProperty(string, styleValue, string2);
    }

    boolean replaceProperty(String string, StyleValue styleValue, String string2) {
        int n = this.propertyList.indexOf(string);
        boolean bl = "important".equals(this.priorities.get(n));
        if ((!bl || "important".equals(string2)) && this.addOverrideProperty(string, styleValue, string2)) {
            this.propertyList.remove(n);
            this.priorities.remove(n);
            return true;
        }
        return false;
    }

    @Override
    protected void addProperty(String string, StyleValue styleValue, String string2) {
        if (styleValue.getCssValueType() == CSSValue.CssType.SHORTHAND) {
            this.addShorthandName(string);
        } else {
            this.propertyList.add(string);
            this.priorities.add(string2);
            StyleValue styleValue2 = this.propValue.get(string);
            if (styleValue2 != null && styleValue2.isSubproperty()) {
                this.overrideShorthands(string, string2);
            }
        }
        this.propValue.put(string, styleValue);
    }

    protected boolean addOverrideProperty(String string, StyleValue styleValue, String string2) {
        this.addProperty(string, styleValue, string2);
        return true;
    }

    private void addShorthandName(String string) {
        if (this.shorthandSet.contains(string)) {
            this.shorthandSet.remove(string);
        }
        this.shorthandSet.add(string);
    }

    private void overrideShorthands(String string, String string2) {
        Iterator<String> iterator = this.shorthandSet.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            ShorthandValue shorthandValue = (ShorthandValue)this.propValue.get(string3);
            if (shorthandValue.isImportant() && !"important".equals(string2) || !shorthandValue.overrideByLonghand(string)) continue;
            iterator.remove();
            this.propValue.remove(string3);
            return;
        }
    }

    boolean addCompatProperty(String string, StyleValue styleValue, String string2) {
        if (styleValue.getCssValueType() == CSSValue.CssType.SHORTHAND) {
            this.addShorthandName(string);
        } else {
            StyleValue styleValue2 = this.propValue.get(string);
            if (BaseCSSStyleDeclaration.hasUnknown(styleValue)) {
                this.compatLonghand(string, styleValue, "important".equals(string2), styleValue2 != null);
                return false;
            }
            this.propertyList.add(string);
            this.priorities.add(string2);
            StyleValue styleValue3 = this.propValue.get(string);
            if (styleValue3 != null && styleValue3.isSubproperty()) {
                this.overrideShorthands(string, string2);
            }
        }
        this.propValue.put(string, styleValue);
        return true;
    }

    private static boolean hasUnknown(CSSValue cSSValue) {
        block7: {
            CSSValue.CssType cssType;
            block6: {
                cssType = cSSValue.getCssValueType();
                if (cssType != CSSValue.CssType.TYPED) break block6;
                CSSValue.Type type = cSSValue.getPrimitiveType();
                if (type == CSSValue.Type.UNKNOWN) {
                    return true;
                }
                if (type == CSSValue.Type.FUNCTION || type == CSSValue.Type.MATH_FUNCTION) {
                    CSSFunctionValue cSSFunctionValue = (CSSFunctionValue)cSSValue;
                    CSSValueList<? extends CSSValue> cSSValueList = cSSFunctionValue.getArguments();
                    for (CSSValue cSSValue2 : cSSValueList) {
                        if (!BaseCSSStyleDeclaration.hasUnknown(cSSValue2)) continue;
                        return true;
                    }
                } else if (type == CSSValue.Type.EXPRESSION) {
                    CSSExpressionValue cSSExpressionValue = (CSSExpressionValue)cSSValue;
                    return BaseCSSStyleDeclaration.hasUnknown(cSSExpressionValue.getExpression());
                }
                break block7;
            }
            if (cssType != CSSValue.CssType.LIST) break block7;
            ValueList valueList = (ValueList)cSSValue;
            for (CSSValue cSSValue3 : valueList) {
                if (!BaseCSSStyleDeclaration.hasUnknown(cSSValue3)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUnknown(CSSExpression cSSExpression) {
        if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
            return BaseCSSStyleDeclaration.hasUnknown(((CSSOperandExpression)cSSExpression).getOperand());
        }
        AlgebraicExpression algebraicExpression = (AlgebraicExpression)cSSExpression;
        int n = algebraicExpression.getLength();
        for (int i = 0; i < n; ++i) {
            CSSExpression cSSExpression2 = algebraicExpression.item(i);
            if (!BaseCSSStyleDeclaration.hasUnknown(cSSExpression2)) continue;
            return true;
        }
        return false;
    }

    protected void compatLonghand(String string, StyleValue styleValue, boolean bl, boolean bl2) {
    }

    boolean isPropertySet(String string) {
        return this.propertyList.contains(string);
    }

    boolean isPropertyImportant(String string) {
        int n = this.propertyList.indexOf(string);
        if (n != -1) {
            String string2 = this.priorities.get(n);
            return string2 != null && string2.length() != 0;
        }
        return false;
    }

    boolean isPropertySet(String string, boolean bl) {
        int n = this.propertyList.indexOf(string);
        if (n != -1) {
            String string2 = this.priorities.get(n);
            boolean bl2 = string2 != null && string2.length() != 0;
            return bl2 == bl;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.propertyList.isEmpty();
    }

    @Override
    public int getLength() {
        return this.propertyList.size();
    }

    @Override
    public String item(int n) {
        if (n < 0 || n > this.propertyList.size()) {
            return "";
        }
        return this.propertyList.get(n);
    }

    @Override
    void clear() {
        this.propValue.clear();
        this.propertyList.clear();
        this.priorities.clear();
        this.shorthandSet.clear();
        StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
        if (styleDeclarationErrorHandler != null) {
            styleDeclarationErrorHandler.reset();
        }
    }

    @Override
    public BaseCSSDeclarationRule getParentRule() {
        return this.parentRule;
    }

    public Node getOwnerNode() {
        AbstractCSSStyleSheet abstractCSSStyleSheet;
        if (this.parentRule != null && (abstractCSSStyleSheet = this.parentRule.getParentStyleSheet()) != null) {
            return abstractCSSStyleSheet.getOwnerNode();
        }
        return null;
    }

    public void addStyle(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        ShorthandDatabase shorthandDatabase = ShorthandDatabase.getInstance();
        HashSet<String> hashSet = new HashSet<String>(baseCSSStyleDeclaration.shorthandSet.size());
        int n = -1;
        for (String string : baseCSSStyleDeclaration.propertyList) {
            String string2;
            ++n;
            int n2 = this.propertyList.indexOf(string);
            if (n2 == -1) {
                this.propertyList.add(string);
                this.priorities.add(baseCSSStyleDeclaration.priorities.get(n));
            } else if (!"important".equals(this.priorities.get(n2))) {
                this.priorities.set(n2, baseCSSStyleDeclaration.priorities.get(n));
            } else if (!"important".equals(baseCSSStyleDeclaration.priorities.get(n))) continue;
            StyleValue styleValue = baseCSSStyleDeclaration.getCSSValue(string);
            if (styleValue.isSubproperty() && !hashSet.contains(string2 = shorthandDatabase.getShorthand(string))) {
                StyleValue styleValue2;
                String string3 = shorthandDatabase.getShorthand(string2);
                if (string3 != null && baseCSSStyleDeclaration.shorthandSet.contains(string3)) {
                    hashSet.add(string3);
                    this.addShorthandName(string3);
                    styleValue2 = baseCSSStyleDeclaration.propValue.get(string3);
                    this.setPropertyCSSValue(string3, styleValue2, null);
                }
                if ((styleValue2 = baseCSSStyleDeclaration.propValue.get(string2)) != null) {
                    hashSet.add(string2);
                    this.addShorthandName(string2);
                    this.setPropertyCSSValue(string2, styleValue2, null);
                }
            }
            string2 = null;
            if ("background-image".equals(string) || "border-image-source".equals(string)) {
                string2 = baseCSSStyleDeclaration.getParentRule() != null ? baseCSSStyleDeclaration.getParentRule().getParentStyleSheet().getHref() : ((NodeStyleDeclaration)((Object)baseCSSStyleDeclaration)).getOwnerNode().getOwnerDocument().getBaseURI();
            }
            this.setPropertyCSSValue(string, styleValue, string2);
        }
    }

    protected void setPropertyCSSValue(String string, StyleValue styleValue, String string2) {
        this.propValue.put(string, styleValue);
    }

    @Override
    protected void prioritySplit(AbstractCSSStyleDeclaration abstractCSSStyleDeclaration, AbstractCSSStyleDeclaration abstractCSSStyleDeclaration2) {
        StyleValue styleValue;
        int n = this.propertyList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.propertyList.get(i);
            styleValue = this.propValue.get(string);
            String string2 = this.priorities.get(i);
            if ("important".equals(string2)) {
                abstractCSSStyleDeclaration.addProperty(string, styleValue, string2);
                continue;
            }
            abstractCSSStyleDeclaration2.addProperty(string, styleValue, string2);
        }
        for (String string : this.shorthandSet) {
            styleValue = (ShorthandValue)this.propValue.get(string);
            if (((ShorthandValue)styleValue).isImportant()) {
                abstractCSSStyleDeclaration.addProperty(string, styleValue, "important");
                continue;
            }
            abstractCSSStyleDeclaration2.addProperty(string, styleValue, null);
        }
    }

    public StyleDatabase getStyleDatabase() {
        Node node;
        AbstractCSSStyleSheet abstractCSSStyleSheet;
        if (this.parentRule != null && (abstractCSSStyleSheet = this.parentRule.getParentStyleSheet()) != null && (node = abstractCSSStyleSheet.getOwnerNode()) != null) {
            StyleDatabase styleDatabase = node.getNodeType() != 9 ? ((CSSDocument)node.getOwnerDocument()).getStyleDatabase() : ((CSSDocument)node).getStyleDatabase();
            return styleDatabase;
        }
        return null;
    }

    StyleValue defaultPropertyValue(String string) {
        StyleValue styleValue = PropertyDatabase.getInstance().getInitialValue(string);
        if (styleValue == null) {
            if (string.equals("color")) {
                styleValue = this.getColorInitialValue();
            } else if (string.equals("font-family")) {
                styleValue = this.getFontFamilyInitialValue();
            } else if (string.equals("text-align")) {
                String string2 = this.getPropertyValue("direction");
                styleValue = string2.equals("rtl") ? new IdentifierValue("right") : new IdentifierValue("left");
            } else if (string.endsWith("-color")) {
                styleValue = this.getCurrentColor();
            } else if (string.equals("quotes")) {
                styleValue = this.getValueFactory().parseProperty("\" \"");
            }
        }
        return styleValue;
    }

    private TypedValue getColorInitialValue() {
        TypedValue typedValue;
        StyleDatabase styleDatabase = this.getStyleDatabase();
        if (styleDatabase == null) {
            typedValue = this.getSystemDefaultValue("color");
        } else {
            typedValue = (TypedValue)styleDatabase.getInitialColor();
            typedValue = new SafeSystemDefaultValue((CSSTypedValue)typedValue);
        }
        return typedValue;
    }

    private StyleValue getFontFamilyInitialValue() {
        StyleValue styleValue;
        StyleDatabase styleDatabase = this.getStyleDatabase();
        styleValue = styleDatabase == null ? this.getSystemDefaultValue("font-family") : ((styleValue = this.getValueFactory().parseProperty(styleDatabase.getDefaultGenericFontFamily())).getCssValueType() == CSSValue.CssType.TYPED ? new SafeSystemDefaultValue((CSSTypedValue)((TypedValue)styleValue)) : this.getSystemDefaultValue("font-family"));
        return styleValue;
    }

    private TypedValue getSystemDefaultValue(String string) {
        AbstractCSSStyleSheetFactory abstractCSSStyleSheetFactory = this.getStyleSheetFactory();
        TypedValue typedValue = abstractCSSStyleSheetFactory != null ? abstractCSSStyleSheetFactory.getSystemDefaultValue(string) : SystemDefaultValue.getInstance();
        return typedValue;
    }

    protected TypedValue getCurrentColor() {
        return new IdentifierValue("currentcolor");
    }

    public TypedValue getCSSColor() {
        StyleValue styleValue = this.getCSSValue("color");
        TypedValue typedValue = styleValue == null || styleValue.getCssValueType() != CSSValue.CssType.TYPED ? this.getColorInitialValue() : (TypedValue)styleValue;
        return typedValue;
    }

    ArrayList<String> getShorthandSet() {
        return this.shorthandSet;
    }

    private SubpropertySetter setSubproperties(String string, LexicalUnit lexicalUnit, boolean bl, boolean bl2) throws DOMException {
        ShorthandDatabase shorthandDatabase = ShorthandDatabase.getInstance();
        if (shorthandDatabase.isShorthand(string)) {
            ShorthandSetter shorthandSetter;
            if (BaseCSSStyleDeclaration.isOrContainsProxy(lexicalUnit)) {
                PendingSubstitutionSetter pendingSubstitutionSetter = new PendingSubstitutionSetter(this, string);
                pendingSubstitutionSetter.init(lexicalUnit, bl);
                pendingSubstitutionSetter.assignSubproperties();
                return pendingSubstitutionSetter;
            }
            if ("font".equals(string)) {
                String string2;
                if (this.getStyleDatabase() != null && lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && lexicalUnit.getNextLexicalUnit() == null && (string2 = this.getStyleDatabase().getSystemFontDeclaration(lexicalUnit.getStringValue())) != null) {
                    return this.setSystemFont(string2, bl);
                }
                shorthandSetter = new FontShorthandSetter(this);
            } else {
                shorthandSetter = "margin".equals(string) ? new MarginShorthandSetter(this) : ("padding".equals(string) ? new BoxShorthandSetter(this, "padding") : ("border".equals(string) ? new BorderShorthandSetter(this) : ("border-width".equals(string) ? new BorderWidthShorthandSetter(this) : ("border-style".equals(string) ? new BorderStyleShorthandSetter(this) : ("border-color".equals(string) ? new BorderColorShorthandSetter(this) : ("border-top".equals(string) ? new BorderSideShorthandSetter(this, string, "top") : ("border-right".equals(string) ? new BorderSideShorthandSetter(this, string, "right") : ("border-bottom".equals(string) ? new BorderSideShorthandSetter(this, string, "bottom") : ("border-left".equals(string) ? new BorderSideShorthandSetter(this, string, "left") : ("background".equals(string) ? new BackgroundShorthandSetter(this) : ("transition".equals(string) ? new TransitionShorthandSetter(this) : ("border-image".equals(string) ? new BorderImageShorthandSetter(this) : ("font-variant".equals(string) ? new FontVariantShorthandSetter(this) : ("border-radius".equals(string) ? new BorderRadiusShorthandSetter(this) : ("list-style".equals(string) ? new ListStyleShorthandSetter(this) : ("animation".equals(string) ? new AnimationShorthandSetter(this) : ("mask".equals(string) ? new MaskShorthandSetter(this) : ("flex".equals(string) ? new FlexShorthandSetter(this) : ("grid".equals(string) ? new GridShorthandSetter(this) : ("grid-template".equals(string) ? new GridTemplateShorthandSetter(this) : ("grid-area".equals(string) ? new GridAreaShorthandSetter(this) : ("grid-column".equals(string) || "grid-row".equals(string) ? new GridPlacementShorthandSetter(this, string) : ("columns".equals(string) ? new ColumnsShorthandSetter(this) : ("column-rule".equals(string) ? new ColumnRuleShorthandSetter(this) : ("place-content".equals(string) || "place-items".equals(string) || "place-self".equals(string) ? new OrderedTwoIdentifierShorthandSetter(this, string) : ("gap".equals(string) ? new OrderedTwoLPIShorthandSetter(this, string) : ("cue".equals(string) ? new CueShorthandSetter(this, string) : ("pause".equals(string) || "rest".equals(string) ? new SequenceShorthandSetter(this, string) : new ShorthandSetter(this, string)))))))))))))))))))))))))))));
            }
            shorthandSetter.init(lexicalUnit, bl);
            shorthandSetter.setAttrTainted(bl2);
            if (!shorthandSetter.assignSubproperties()) {
                throw new DOMException(12, "Invalid property declaration: " + lexicalUnit.toString());
            }
            return shorthandSetter;
        }
        return null;
    }

    private static boolean isOrContainsProxy(LexicalUnit lexicalUnit) {
        do {
            LexicalUnit.LexicalType lexicalType;
            if ((lexicalType = lexicalUnit.getLexicalUnitType()) != LexicalUnit.LexicalType.VAR && lexicalType != LexicalUnit.LexicalType.ATTR && (lexicalUnit.getParameters() == null || !BaseCSSStyleDeclaration.isOrContainsProxy(lexicalUnit.getParameters())) && (lexicalUnit.getSubValues() == null || !BaseCSSStyleDeclaration.isOrContainsProxy(lexicalUnit.getSubValues()))) continue;
            return true;
        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
        return false;
    }

    private SubpropertySetter setSystemFont(String string, boolean bl) throws DOMException {
        StringReader stringReader = new StringReader(string);
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = this.createSACParser().parsePropertyValue(stringReader);
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return this.setSubproperties("font", lexicalUnit, bl, false);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        TreeSet<String> treeSet = new TreeSet<String>(this.propertyList);
        for (String string : treeSet) {
            n2 = 31 * n2 + string.hashCode();
            n2 = 31 * n2 + this.propValue.get(string).hashCode();
            String string2 = this.priorities.get(this.propertyList.indexOf(string));
            n2 = 31 * n2 + (string2 == null ? 0 : string2.hashCode());
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BaseCSSStyleDeclaration)) {
            return false;
        }
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = (BaseCSSStyleDeclaration)object;
        if (this.propertyList.size() != baseCSSStyleDeclaration.propertyList.size()) {
            return false;
        }
        for (String string : this.propertyList) {
            if (!baseCSSStyleDeclaration.propertyList.contains(string)) {
                return false;
            }
            StyleValue styleValue = this.propValue.get(string);
            if (!styleValue.equals(baseCSSStyleDeclaration.propValue.get(string))) {
                return false;
            }
            int n = this.propertyList.indexOf(string);
            int n2 = baseCSSStyleDeclaration.propertyList.indexOf(string);
            String string2 = this.priorities.get(n);
            String string3 = baseCSSStyleDeclaration.priorities.get(n2);
            if (!(string2 == null ? string3 != null : !string2.equals(string3))) continue;
            return false;
        }
        return true;
    }

    public Diff<String> diff(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        PropertyDiff propertyDiff = new PropertyDiff();
        for (String string : this.propertyList) {
            StyleValue styleValue;
            if (!baseCSSStyleDeclaration.propertyList.contains(string)) {
                propertyDiff.leftSide.add(string);
                continue;
            }
            StyleValue styleValue2 = this.getCSSValue(string);
            if (this.valueEquals(styleValue2, styleValue = baseCSSStyleDeclaration.getCSSValue(string))) {
                int n = this.propertyList.indexOf(string);
                int n2 = baseCSSStyleDeclaration.propertyList.indexOf(string);
                String string2 = this.priorities.get(n);
                String string3 = baseCSSStyleDeclaration.priorities.get(n2);
                if (string2 == null ? string3 == null : string2.equals(string3)) continue;
            }
            propertyDiff.differentValues.add(string);
        }
        for (String string : baseCSSStyleDeclaration.propertyList) {
            if (this.propertyList.contains(string)) continue;
            propertyDiff.rightSide.add(string);
        }
        return propertyDiff;
    }

    private boolean valueEquals(StyleValue styleValue, StyleValue styleValue2) {
        return styleValue != null ? styleValue.equals(styleValue2) : styleValue2 == null;
    }

    public String toString() {
        return this.getCssText();
    }

    public BaseCSSStyleDeclaration clone() {
        return new BaseCSSStyleDeclaration(this);
    }

    static String lexicalUnitToString(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            return "";
        }
        return lexicalUnit.toString();
    }

    public static boolean testColor(LexicalUnit lexicalUnit) {
        CSSValueSyntax cSSValueSyntax = SyntaxParser.createSimpleSyntax("color");
        return lexicalUnit.shallowClone().matches(cSSValueSyntax) == CSSValueSyntax.Match.TRUE;
    }

    @Override
    public String getAzimuth() {
        return this.getPropertyValue("azimuth");
    }

    @Override
    public void setAzimuth(String string) throws DOMException {
        this.getPropertyCSSValue("azimuth").setCssText(string);
    }

    @Override
    public String getBackground() {
        return this.getPropertyValue("background");
    }

    @Override
    public void setBackground(String string) throws DOMException {
        this.getPropertyCSSValue("background").setCssText(string);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.getPropertyValue("background-attachment");
    }

    @Override
    public void setBackgroundAttachment(String string) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(string);
    }

    @Override
    public String getBackgroundColor() {
        return this.getPropertyValue("background-color");
    }

    @Override
    public void setBackgroundColor(String string) throws DOMException {
        this.getPropertyCSSValue("background-color").setCssText(string);
    }

    @Override
    public String getBackgroundImage() {
        return this.getPropertyValue("background-image");
    }

    @Override
    public void setBackgroundImage(String string) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(string);
    }

    @Override
    public String getBackgroundPosition() {
        return this.getPropertyValue("background-position");
    }

    @Override
    public void setBackgroundPosition(String string) throws DOMException {
        this.getPropertyCSSValue("background-position").setCssText(string);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.getPropertyValue("background-repeat");
    }

    @Override
    public void setBackgroundRepeat(String string) throws DOMException {
        this.getPropertyCSSValue("background-repeat").setCssText(string);
    }

    @Override
    public String getBorder() {
        return this.getPropertyValue("border");
    }

    @Override
    public void setBorder(String string) throws DOMException {
        this.getPropertyCSSValue("border").setCssText(string);
    }

    @Override
    public String getBorderCollapse() {
        return this.getPropertyValue("border-collapse");
    }

    @Override
    public void setBorderCollapse(String string) throws DOMException {
        this.getPropertyCSSValue("border-collapse").setCssText(string);
    }

    @Override
    public String getBorderColor() {
        return this.getPropertyValue("border-color");
    }

    @Override
    public void setBorderColor(String string) throws DOMException {
        this.getPropertyCSSValue("border-color").setCssText(string);
    }

    @Override
    public String getBorderSpacing() {
        return this.getPropertyValue("border-spacing");
    }

    @Override
    public void setBorderSpacing(String string) throws DOMException {
        this.getPropertyCSSValue("border-spacing").setCssText(string);
    }

    @Override
    public String getBorderStyle() {
        return this.getPropertyValue("border-style");
    }

    @Override
    public void setBorderStyle(String string) throws DOMException {
        this.getPropertyCSSValue("border-style").setCssText(string);
    }

    @Override
    public String getBorderTop() {
        return this.getPropertyValue("border-top");
    }

    @Override
    public void setBorderTop(String string) throws DOMException {
        this.getPropertyCSSValue("border-top").setCssText(string);
    }

    @Override
    public String getBorderRight() {
        return this.getPropertyValue("border-right");
    }

    @Override
    public void setBorderRight(String string) throws DOMException {
        this.getPropertyCSSValue("border-right").setCssText(string);
    }

    @Override
    public String getBorderBottom() {
        return this.getPropertyValue("border-bottom");
    }

    @Override
    public void setBorderBottom(String string) throws DOMException {
        this.getPropertyCSSValue("border-bottom").setCssText(string);
    }

    @Override
    public String getBorderLeft() {
        return this.getPropertyValue("border-left");
    }

    @Override
    public void setBorderLeft(String string) throws DOMException {
        this.getPropertyCSSValue("border-left").setCssText(string);
    }

    @Override
    public String getBorderTopColor() {
        return this.getPropertyValue("border-top-color");
    }

    @Override
    public void setBorderTopColor(String string) throws DOMException {
        this.getPropertyCSSValue("border-top-color").setCssText(string);
    }

    @Override
    public String getBorderRightColor() {
        return this.getPropertyValue("border-right-color");
    }

    @Override
    public void setBorderRightColor(String string) throws DOMException {
        this.getPropertyCSSValue("border-right-color").setCssText(string);
    }

    @Override
    public String getBorderBottomColor() {
        return this.getPropertyValue("border-bottom-color");
    }

    @Override
    public void setBorderBottomColor(String string) throws DOMException {
        this.getPropertyCSSValue("border-bottom-color").setCssText(string);
    }

    @Override
    public String getBorderLeftColor() {
        return this.getPropertyValue("border-left-color");
    }

    @Override
    public void setBorderLeftColor(String string) throws DOMException {
        this.getPropertyCSSValue("border-left-color").setCssText(string);
    }

    @Override
    public String getBorderTopStyle() {
        return this.getPropertyValue("border-top-style");
    }

    @Override
    public void setBorderTopStyle(String string) throws DOMException {
        this.getPropertyCSSValue("border-top-style").setCssText(string);
    }

    @Override
    public String getBorderRightStyle() {
        return this.getPropertyValue("border-right-style");
    }

    @Override
    public void setBorderRightStyle(String string) throws DOMException {
        this.getPropertyCSSValue("border-right-style").setCssText(string);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.getPropertyValue("border-bottom-style");
    }

    @Override
    public void setBorderBottomStyle(String string) throws DOMException {
        this.getPropertyCSSValue("border-bottom-style").setCssText(string);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.getPropertyValue("border-left-style");
    }

    @Override
    public void setBorderLeftStyle(String string) throws DOMException {
        this.getPropertyCSSValue("border-left-style").setCssText(string);
    }

    @Override
    public String getBorderTopWidth() {
        return this.getPropertyValue("border-top-width");
    }

    @Override
    public void setBorderTopWidth(String string) throws DOMException {
        this.getPropertyCSSValue("border-top-width").setCssText(string);
    }

    @Override
    public String getBorderRightWidth() {
        return this.getPropertyValue("border-right-width");
    }

    @Override
    public void setBorderRightWidth(String string) throws DOMException {
        this.getPropertyCSSValue("border-right-width").setCssText(string);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.getPropertyValue("border-bottom-width");
    }

    @Override
    public void setBorderBottomWidth(String string) throws DOMException {
        this.getPropertyCSSValue("border-bottom-width").setCssText(string);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.getPropertyValue("border-left-width");
    }

    @Override
    public void setBorderLeftWidth(String string) throws DOMException {
        this.getPropertyCSSValue("border-left-width").setCssText(string);
    }

    @Override
    public String getBorderWidth() {
        return this.getPropertyValue("border-width");
    }

    @Override
    public void setBorderWidth(String string) throws DOMException {
        this.getPropertyCSSValue("border-width").setCssText(string);
    }

    @Override
    public String getBottom() {
        return this.getPropertyValue("bottom");
    }

    @Override
    public void setBottom(String string) throws DOMException {
        this.getPropertyCSSValue("bottom").setCssText(string);
    }

    @Override
    public String getCaptionSide() {
        return this.getPropertyValue("caption-side");
    }

    @Override
    public void setCaptionSide(String string) throws DOMException {
        this.getPropertyCSSValue("caption-side").setCssText(string);
    }

    @Override
    public String getClear() {
        return this.getPropertyValue("clear");
    }

    @Override
    public void setClear(String string) throws DOMException {
        this.getPropertyCSSValue("clear").setCssText(string);
    }

    @Override
    public String getClip() {
        return this.getPropertyValue("clip");
    }

    @Override
    public void setClip(String string) throws DOMException {
        this.getPropertyCSSValue("clip").setCssText(string);
    }

    @Override
    public String getColor() {
        return this.getPropertyValue("color");
    }

    @Override
    public void setColor(String string) throws DOMException {
        this.getPropertyCSSValue("color").setCssText(string);
    }

    @Override
    public String getContent() {
        return this.getPropertyValue("content");
    }

    @Override
    public void setContent(String string) throws DOMException {
        this.getPropertyCSSValue("content").setCssText(string);
    }

    @Override
    public String getCounterIncrement() {
        return this.getPropertyValue("counter-increment");
    }

    @Override
    public void setCounterIncrement(String string) throws DOMException {
        this.getPropertyCSSValue("counter-increment").setCssText(string);
    }

    @Override
    public String getCounterReset() {
        return this.getPropertyValue("counter-reset");
    }

    @Override
    public void setCounterReset(String string) throws DOMException {
        this.getPropertyCSSValue("counter-reset").setCssText(string);
    }

    @Override
    public String getCue() {
        return this.getPropertyValue("cue");
    }

    @Override
    public void setCue(String string) throws DOMException {
        this.getPropertyCSSValue("cue").setCssText(string);
    }

    @Override
    public String getCueAfter() {
        return this.getPropertyValue("cue-after");
    }

    @Override
    public void setCueAfter(String string) throws DOMException {
        this.getPropertyCSSValue("cue-after").setCssText(string);
    }

    @Override
    public String getCueBefore() {
        return this.getPropertyValue("cue-before");
    }

    @Override
    public void setCueBefore(String string) throws DOMException {
        this.getPropertyCSSValue("cue-before").setCssText(string);
    }

    @Override
    public String getCursor() {
        return this.getPropertyValue("cursor");
    }

    @Override
    public void setCursor(String string) throws DOMException {
        this.getPropertyCSSValue("cursor").setCssText(string);
    }

    @Override
    public String getDirection() {
        return this.getPropertyValue("direction");
    }

    @Override
    public void setDirection(String string) throws DOMException {
        this.getPropertyCSSValue("direction").setCssText(string);
    }

    @Override
    public String getDisplay() {
        return this.getPropertyValue("display");
    }

    @Override
    public void setDisplay(String string) throws DOMException {
        this.getPropertyCSSValue("display").setCssText(string);
    }

    @Override
    public String getElevation() {
        return this.getPropertyValue("elevation");
    }

    @Override
    public void setElevation(String string) throws DOMException {
        this.getPropertyCSSValue("elevation").setCssText(string);
    }

    @Override
    public String getEmptyCells() {
        return this.getPropertyValue("empty-cells");
    }

    @Override
    public void setEmptyCells(String string) throws DOMException {
        this.getPropertyCSSValue("empty-cells").setCssText(string);
    }

    @Override
    public String getCssFloat() {
        return this.getPropertyValue("css-float");
    }

    @Override
    public void setCssFloat(String string) throws DOMException {
        this.getPropertyCSSValue("css-float").setCssText(string);
    }

    @Override
    public String getFont() {
        return this.getPropertyValue("font");
    }

    @Override
    public void setFont(String string) throws DOMException {
        this.getPropertyCSSValue("font").setCssText(string);
    }

    @Override
    public String getFontFamily() {
        return this.getPropertyValue("font-family");
    }

    @Override
    public void setFontFamily(String string) throws DOMException {
        this.getPropertyCSSValue("font-family").setCssText(string);
    }

    @Override
    public String getFontSize() {
        return this.getPropertyValue("font-size");
    }

    @Override
    public void setFontSize(String string) throws DOMException {
        this.getPropertyCSSValue("font-size").setCssText(string);
    }

    @Override
    public String getFontSizeAdjust() {
        return this.getPropertyValue("font-size-adjust");
    }

    @Override
    public void setFontSizeAdjust(String string) throws DOMException {
        this.getPropertyCSSValue("font-size-adjust").setCssText(string);
    }

    @Override
    public String getFontStretch() {
        return this.getPropertyValue("font-stretch");
    }

    @Override
    public void setFontStretch(String string) throws DOMException {
        this.getPropertyCSSValue("font-stretch").setCssText(string);
    }

    @Override
    public String getFontStyle() {
        return this.getPropertyValue("font-style");
    }

    @Override
    public void setFontStyle(String string) throws DOMException {
        this.getPropertyCSSValue("font-style").setCssText(string);
    }

    @Override
    public String getFontVariant() {
        return this.getPropertyValue("font-variant");
    }

    @Override
    public void setFontVariant(String string) throws DOMException {
        this.getPropertyCSSValue("font-variant").setCssText(string);
    }

    @Override
    public String getFontWeight() {
        return this.getPropertyValue("font-weight");
    }

    @Override
    public void setFontWeight(String string) throws DOMException {
        this.getPropertyCSSValue("font-weight").setCssText(string);
    }

    @Override
    public String getHeight() {
        return this.getPropertyValue("height");
    }

    @Override
    public void setHeight(String string) throws DOMException {
        this.getPropertyCSSValue("height").setCssText(string);
    }

    @Override
    public String getLeft() {
        return this.getPropertyValue("left");
    }

    @Override
    public void setLeft(String string) throws DOMException {
        this.getPropertyCSSValue("left").setCssText(string);
    }

    @Override
    public String getLetterSpacing() {
        return this.getPropertyValue("letter-spacing");
    }

    @Override
    public void setLetterSpacing(String string) throws DOMException {
        this.getPropertyCSSValue("letter-spacing").setCssText(string);
    }

    @Override
    public String getLineHeight() {
        return this.getPropertyValue("line-height");
    }

    @Override
    public void setLineHeight(String string) throws DOMException {
        this.getPropertyCSSValue("line-height").setCssText(string);
    }

    @Override
    public String getListStyle() {
        return this.getPropertyValue("list-style");
    }

    @Override
    public void setListStyle(String string) throws DOMException {
        this.getPropertyCSSValue("list-style").setCssText(string);
    }

    @Override
    public String getListStyleImage() {
        return this.getPropertyValue("list-style-image");
    }

    @Override
    public void setListStyleImage(String string) throws DOMException {
        this.getPropertyCSSValue("list-style-image").setCssText(string);
    }

    @Override
    public String getListStylePosition() {
        return this.getPropertyValue("list-style-position");
    }

    @Override
    public void setListStylePosition(String string) throws DOMException {
        this.getPropertyCSSValue("list-style-position").setCssText(string);
    }

    @Override
    public String getListStyleType() {
        return this.getPropertyValue("list-style-type");
    }

    @Override
    public void setListStyleType(String string) throws DOMException {
        this.getPropertyCSSValue("list-style-type").setCssText(string);
    }

    @Override
    public String getMargin() {
        return this.getPropertyValue("margin");
    }

    @Override
    public void setMargin(String string) throws DOMException {
        this.getPropertyCSSValue("margin").setCssText(string);
    }

    @Override
    public String getMarginTop() {
        return this.getPropertyValue("margin-top");
    }

    @Override
    public void setMarginTop(String string) throws DOMException {
        this.getPropertyCSSValue("margin-top").setCssText(string);
    }

    @Override
    public String getMarginRight() {
        return this.getPropertyValue("margin-right");
    }

    @Override
    public void setMarginRight(String string) throws DOMException {
        this.getPropertyCSSValue("margin-right").setCssText(string);
    }

    @Override
    public String getMarginBottom() {
        return this.getPropertyValue("margin-bottom");
    }

    @Override
    public void setMarginBottom(String string) throws DOMException {
        this.getPropertyCSSValue("margin-bottom").setCssText(string);
    }

    @Override
    public String getMarginLeft() {
        return this.getPropertyValue("margin-left");
    }

    @Override
    public void setMarginLeft(String string) throws DOMException {
        this.getPropertyCSSValue("margin-left").setCssText(string);
    }

    @Override
    public String getMarkerOffset() {
        return this.getPropertyValue("marker-offset");
    }

    @Override
    public void setMarkerOffset(String string) throws DOMException {
        this.getPropertyCSSValue("marker-offset").setCssText(string);
    }

    @Override
    public String getMarks() {
        return this.getPropertyValue("marks");
    }

    @Override
    public void setMarks(String string) throws DOMException {
        this.getPropertyCSSValue("marks").setCssText(string);
    }

    @Override
    public String getMaxHeight() {
        return this.getPropertyValue("max-height");
    }

    @Override
    public void setMaxHeight(String string) throws DOMException {
        this.getPropertyCSSValue("max-height").setCssText(string);
    }

    @Override
    public String getMaxWidth() {
        return this.getPropertyValue("max-width");
    }

    @Override
    public void setMaxWidth(String string) throws DOMException {
        this.getPropertyCSSValue("max-width").setCssText(string);
    }

    @Override
    public String getMinHeight() {
        return this.getPropertyValue("min-height");
    }

    @Override
    public void setMinHeight(String string) throws DOMException {
        this.getPropertyCSSValue("min-height").setCssText(string);
    }

    @Override
    public String getMinWidth() {
        return this.getPropertyValue("min-width");
    }

    @Override
    public void setMinWidth(String string) throws DOMException {
        this.getPropertyCSSValue("min-width").setCssText(string);
    }

    @Override
    public String getOrphans() {
        return this.getPropertyValue("orphans");
    }

    @Override
    public void setOrphans(String string) throws DOMException {
        this.getPropertyCSSValue("orphans").setCssText(string);
    }

    @Override
    public String getOutline() {
        return this.getPropertyValue("outline");
    }

    @Override
    public void setOutline(String string) throws DOMException {
        this.getPropertyCSSValue("outline").setCssText(string);
    }

    @Override
    public String getOutlineColor() {
        return this.getPropertyValue("outline-color");
    }

    @Override
    public void setOutlineColor(String string) throws DOMException {
        this.getPropertyCSSValue("outline-color").setCssText(string);
    }

    @Override
    public String getOutlineStyle() {
        return this.getPropertyValue("outline-style");
    }

    @Override
    public void setOutlineStyle(String string) throws DOMException {
        this.getPropertyCSSValue("outline-style").setCssText(string);
    }

    @Override
    public String getOutlineWidth() {
        return this.getPropertyValue("outline-width");
    }

    @Override
    public void setOutlineWidth(String string) throws DOMException {
        this.getPropertyCSSValue("outline-width").setCssText(string);
    }

    @Override
    public String getOverflow() {
        return this.getPropertyValue("overflow");
    }

    @Override
    public void setOverflow(String string) throws DOMException {
        this.getPropertyCSSValue("overflow").setCssText(string);
    }

    @Override
    public String getPadding() {
        return this.getPropertyValue("padding");
    }

    @Override
    public void setPadding(String string) throws DOMException {
        this.getPropertyCSSValue("padding").setCssText(string);
    }

    @Override
    public String getPaddingTop() {
        return this.getPropertyValue("padding-top");
    }

    @Override
    public void setPaddingTop(String string) throws DOMException {
        this.getPropertyCSSValue("padding-top").setCssText(string);
    }

    @Override
    public String getPaddingRight() {
        return this.getPropertyValue("padding-right");
    }

    @Override
    public void setPaddingRight(String string) throws DOMException {
        this.getPropertyCSSValue("padding-right").setCssText(string);
    }

    @Override
    public String getPaddingBottom() {
        return this.getPropertyValue("padding-bottom");
    }

    @Override
    public void setPaddingBottom(String string) throws DOMException {
        this.getPropertyCSSValue("padding-bottom").setCssText(string);
    }

    @Override
    public String getPaddingLeft() {
        return this.getPropertyValue("padding-left");
    }

    @Override
    public void setPaddingLeft(String string) throws DOMException {
        this.getPropertyCSSValue("padding-left").setCssText(string);
    }

    @Override
    public String getPage() {
        return this.getPropertyValue("page");
    }

    @Override
    public void setPage(String string) throws DOMException {
        this.getPropertyCSSValue("page").setCssText(string);
    }

    @Override
    public String getPageBreakAfter() {
        return this.getPropertyValue("page-break-after");
    }

    @Override
    public void setPageBreakAfter(String string) throws DOMException {
        this.getPropertyCSSValue("page-break-after").setCssText(string);
    }

    @Override
    public String getPageBreakBefore() {
        return this.getPropertyValue("page-break-before");
    }

    @Override
    public void setPageBreakBefore(String string) throws DOMException {
        this.getPropertyCSSValue("page-break-before").setCssText(string);
    }

    @Override
    public String getPageBreakInside() {
        return this.getPropertyValue("page-break-inside");
    }

    @Override
    public void setPageBreakInside(String string) throws DOMException {
        this.getPropertyCSSValue("page-break-inside").setCssText(string);
    }

    @Override
    public String getPause() {
        return this.getPropertyValue("pause");
    }

    @Override
    public void setPause(String string) throws DOMException {
        this.getPropertyCSSValue("pause").setCssText(string);
    }

    @Override
    public String getPauseAfter() {
        return this.getPropertyValue("pause-after");
    }

    @Override
    public void setPauseAfter(String string) throws DOMException {
        this.getPropertyCSSValue("pause-after").setCssText(string);
    }

    @Override
    public String getPauseBefore() {
        return this.getPropertyValue("pause-before");
    }

    @Override
    public void setPauseBefore(String string) throws DOMException {
        this.getPropertyCSSValue("pause-before").setCssText(string);
    }

    @Override
    public String getPitch() {
        return this.getPropertyValue("pitch");
    }

    @Override
    public void setPitch(String string) throws DOMException {
        this.getPropertyCSSValue("pitch").setCssText(string);
    }

    @Override
    public String getPitchRange() {
        return this.getPropertyValue("pitch-range");
    }

    @Override
    public void setPitchRange(String string) throws DOMException {
        this.getPropertyCSSValue("pitch-range").setCssText(string);
    }

    @Override
    public String getPlayDuring() {
        return this.getPropertyValue("play-during");
    }

    @Override
    public void setPlayDuring(String string) throws DOMException {
        this.getPropertyCSSValue("play-during").setCssText(string);
    }

    @Override
    public String getPosition() {
        return this.getPropertyValue("position");
    }

    @Override
    public void setPosition(String string) throws DOMException {
        this.getPropertyCSSValue("position").setCssText(string);
    }

    @Override
    public String getQuotes() {
        return this.getPropertyValue("quotes");
    }

    @Override
    public void setQuotes(String string) throws DOMException {
        this.getPropertyCSSValue("quotes").setCssText(string);
    }

    @Override
    public String getRichness() {
        return this.getPropertyValue("richness");
    }

    @Override
    public void setRichness(String string) throws DOMException {
        this.getPropertyCSSValue("richness").setCssText(string);
    }

    @Override
    public String getRight() {
        return this.getPropertyValue("right");
    }

    @Override
    public void setRight(String string) throws DOMException {
        this.getPropertyCSSValue("right").setCssText(string);
    }

    @Override
    public String getSize() {
        return this.getPropertyValue("size");
    }

    @Override
    public void setSize(String string) throws DOMException {
        this.getPropertyCSSValue("size").setCssText(string);
    }

    @Override
    public String getSpeak() {
        return this.getPropertyValue("speak");
    }

    @Override
    public void setSpeak(String string) throws DOMException {
        this.getPropertyCSSValue("speak").setCssText(string);
    }

    @Override
    public String getSpeakHeader() {
        return this.getPropertyValue("speak-header");
    }

    @Override
    public void setSpeakHeader(String string) throws DOMException {
        this.getPropertyCSSValue("speak-header").setCssText(string);
    }

    @Override
    public String getSpeakNumeral() {
        return this.getPropertyValue("speak-numeral");
    }

    @Override
    public void setSpeakNumeral(String string) throws DOMException {
        this.getPropertyCSSValue("speak-numeral").setCssText(string);
    }

    @Override
    public String getSpeakPunctuation() {
        return this.getPropertyValue("speak-punctuation");
    }

    @Override
    public void setSpeakPunctuation(String string) throws DOMException {
        this.getPropertyCSSValue("speak-punctuation").setCssText(string);
    }

    @Override
    public String getSpeechRate() {
        return this.getPropertyValue("speech-rate");
    }

    @Override
    public void setSpeechRate(String string) throws DOMException {
        this.getPropertyCSSValue("speech-rate").setCssText(string);
    }

    @Override
    public String getStress() {
        return this.getPropertyValue("stress");
    }

    @Override
    public void setStress(String string) throws DOMException {
        this.getPropertyCSSValue("stress").setCssText(string);
    }

    @Override
    public String getTableLayout() {
        return this.getPropertyValue("table-layout");
    }

    @Override
    public void setTableLayout(String string) throws DOMException {
        this.getPropertyCSSValue("table-layout").setCssText(string);
    }

    @Override
    public String getTextAlign() {
        return this.getPropertyValue("text-align");
    }

    @Override
    public void setTextAlign(String string) throws DOMException {
        this.getPropertyCSSValue("text-align").setCssText(string);
    }

    @Override
    public String getTextDecoration() {
        return this.getPropertyValue("text-decoration");
    }

    @Override
    public void setTextDecoration(String string) throws DOMException {
        this.getPropertyCSSValue("text-decoration").setCssText(string);
    }

    @Override
    public String getTextIndent() {
        return this.getPropertyValue("text-indent");
    }

    @Override
    public void setTextIndent(String string) throws DOMException {
        this.getPropertyCSSValue("text-indent").setCssText(string);
    }

    @Override
    public String getTextShadow() {
        return this.getPropertyValue("text-shadow");
    }

    @Override
    public void setTextShadow(String string) throws DOMException {
        this.getPropertyCSSValue("text-shadow").setCssText(string);
    }

    @Override
    public String getTextTransform() {
        return this.getPropertyValue("text-transform");
    }

    @Override
    public void setTextTransform(String string) throws DOMException {
        this.getPropertyCSSValue("text-transform").setCssText(string);
    }

    @Override
    public String getTop() {
        return this.getPropertyValue("top");
    }

    @Override
    public void setTop(String string) throws DOMException {
        this.getPropertyCSSValue("top").setCssText(string);
    }

    @Override
    public String getUnicodeBidi() {
        return this.getPropertyValue("unicode-bidi");
    }

    @Override
    public void setUnicodeBidi(String string) throws DOMException {
        this.getPropertyCSSValue("unicode-bidi").setCssText(string);
    }

    @Override
    public String getVerticalAlign() {
        return this.getPropertyValue("vertical-align");
    }

    @Override
    public void setVerticalAlign(String string) throws DOMException {
        this.getPropertyCSSValue("vertical-align").setCssText(string);
    }

    @Override
    public String getVisibility() {
        return this.getPropertyValue("visibility");
    }

    @Override
    public void setVisibility(String string) throws DOMException {
        this.getPropertyCSSValue("visibility").setCssText(string);
    }

    @Override
    public String getVoiceFamily() {
        return this.getPropertyValue("voice-family");
    }

    @Override
    public void setVoiceFamily(String string) throws DOMException {
        this.getPropertyCSSValue("voice-family").setCssText(string);
    }

    @Override
    public String getVolume() {
        return this.getPropertyValue("volume");
    }

    @Override
    public void setVolume(String string) throws DOMException {
        this.getPropertyCSSValue("volume").setCssText(string);
    }

    @Override
    public String getWhiteSpace() {
        return this.getPropertyValue("white-space");
    }

    @Override
    public void setWhiteSpace(String string) throws DOMException {
        this.getPropertyCSSValue("white-space").setCssText(string);
    }

    @Override
    public String getWidows() {
        return null;
    }

    @Override
    public void setWidows(String string) throws DOMException {
        this.getPropertyCSSValue("widows").setCssText(string);
    }

    @Override
    public String getWidth() {
        return this.getPropertyValue("width");
    }

    @Override
    public void setWidth(String string) throws DOMException {
        this.getPropertyCSSValue("width").setCssText(string);
    }

    @Override
    public String getWordSpacing() {
        return this.getPropertyValue("word-spacing");
    }

    @Override
    public void setWordSpacing(String string) throws DOMException {
        this.getPropertyCSSValue("word-spacing").setCssText(string);
    }

    @Override
    public String getZIndex() {
        return this.getPropertyValue("z-index");
    }

    @Override
    public void setZIndex(String string) throws DOMException {
        this.getPropertyCSSValue("z-index").setCssText(string);
    }

    private static class PropertyDiff
    implements Diff<String> {
        LinkedList<String> leftSide = new LinkedList();
        LinkedList<String> rightSide = new LinkedList();
        LinkedList<String> differentValues = new LinkedList();

        private PropertyDiff() {
        }

        public boolean hasDifferences() {
            return !this.leftSide.isEmpty() || !this.rightSide.isEmpty() || !this.differentValues.isEmpty();
        }

        public String[] getLeftSide() {
            if (this.leftSide.isEmpty()) {
                return null;
            }
            return this.leftSide.toArray(new String[0]);
        }

        public String[] getRightSide() {
            if (this.rightSide.isEmpty()) {
                return null;
            }
            return this.rightSide.toArray(new String[0]);
        }

        public String[] getDifferent() {
            if (this.differentValues.isEmpty()) {
                return null;
            }
            return this.differentValues.toArray(new String[0]);
        }
    }

    private class StyleDeclarationHandler
    extends PropertyCSSHandler {
        private StyleDeclarationHandler() {
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            block2: {
                try {
                    super.property(string, lexicalUnit, bl);
                }
                catch (DOMException dOMException) {
                    if (BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException(dOMException);
                    cSSPropertyValueException.setValueText(lexicalUnit.toString());
                    BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
                }
            }
        }

        @Override
        public void warning(CSSParseException cSSParseException) throws CSSParseException {
            if (BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler().sacWarning(cSSParseException, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        @Override
        public void error(CSSParseException cSSParseException) throws CSSParseException {
            if (BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getStyleDeclarationErrorHandler().sacError(cSSParseException, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }
    }
}

