/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.math.BigInteger;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

final class NativeBigInt
extends IdScriptableObject {
    private static final long serialVersionUID = 1335609231306775449L;
    private static final Object BIG_INT_TAG = "BigInt";
    private static final int ConstructorId_asIntN = -1;
    private static final int ConstructorId_asUintN = -2;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_valueOf = 5;
    private static final int SymbolId_toStringTag = 6;
    private static final int MAX_PROTOTYPE_ID = 6;
    private BigInteger bigIntValue;

    static void init(Scriptable scriptable, boolean bl) {
        NativeBigInt nativeBigInt = new NativeBigInt(BigInteger.ZERO);
        nativeBigInt.exportAsJSClass(6, scriptable, bl);
    }

    NativeBigInt(BigInteger bigInteger) {
        this.bigIntValue = bigInteger;
    }

    @Override
    public String getClassName() {
        return "BigInt";
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, BIG_INT_TAG, -1, "asIntN", 2);
        this.addIdFunctionProperty(idFunctionObject, BIG_INT_TAG, -2, "asUintN", 2);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n == 6) {
            this.initPrototypeValue(6, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
            return;
        }
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 5: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(BIG_INT_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(BIG_INT_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n == 1) {
            if (scriptable2 == null) {
                throw ScriptRuntime.typeErrorById("msg.not.ctor", BIG_INT_TAG);
            }
            BigInteger bigInteger = objectArray.length >= 1 ? ScriptRuntime.toBigInt(objectArray[0]) : BigInteger.ZERO;
            return bigInteger;
        }
        if (n < 1) {
            return NativeBigInt.execConstructorCall(n, objectArray);
        }
        BigInteger bigInteger = NativeBigInt.ensureType((Object)scriptable2, NativeBigInt.class, (IdFunctionObject)idFunctionObject).bigIntValue;
        switch (n) {
            case 2: 
            case 3: {
                int n2 = objectArray.length == 0 || objectArray[0] == Undefined.instance ? 10 : ScriptRuntime.toInt32(objectArray[0]);
                return ScriptRuntime.bigIntToString(bigInteger, n2);
            }
            case 4: {
                return "(new BigInt(" + ScriptRuntime.toString(bigInteger) + "))";
            }
            case 5: {
                return bigInteger;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static Object execConstructorCall(int n, Object[] objectArray) {
        switch (n) {
            case -2: 
            case -1: {
                int n2 = ScriptRuntime.toIndex(objectArray.length < 1 ? Undefined.instance : objectArray[0]);
                BigInteger bigInteger = ScriptRuntime.toBigInt(objectArray.length < 2 ? Undefined.instance : objectArray[1]);
                if (n2 == 0) {
                    return BigInteger.ZERO;
                }
                int n3 = n2 / 8 + 1;
                byte[] byArray = bigInteger.toByteArray();
                if (n3 > byArray.length) {
                    return bigInteger;
                }
                byte[] byArray2 = Arrays.copyOfRange(byArray, byArray.length - n3, byArray.length);
                int n4 = n2 % 8;
                switch (n) {
                    case -1: {
                        if (n4 == 0) {
                            byArray2[0] = byArray2[1] < 0 ? -1 : 0;
                            break;
                        }
                        if ((byArray2[0] & 1 << n4 - 1) != 0) {
                            byArray2[0] = (byte)(byArray2[0] | -1 << n4);
                            break;
                        }
                        byArray2[0] = (byte)(byArray2[0] & (1 << n4) - 1);
                        break;
                    }
                    case -2: {
                        byArray2[0] = (byte)(byArray2[0] & (1 << n4) - 1);
                    }
                }
                return new BigInteger(byArray2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public String toString() {
        return ScriptRuntime.bigIntToString(this.bigIntValue, 10);
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 6;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "toString": {
                n = 2;
                break;
            }
            case "toLocaleString": {
                n = 3;
                break;
            }
            case "toSource": {
                n = 4;
                break;
            }
            case "valueOf": {
                n = 5;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

