/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006H\u0000\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u000b"}, d2={"isCanonical", "", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "isAbstractOrSealed", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "getFunctionInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "iFace", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/wasm/utils/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1740#2,3:40\n669#2,11:43\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/wasm/utils/UtilsKt\n*L\n30#1:40,3\n38#1:43,11\n*E\n"})
public final class UtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCanonical(@NotNull IrTry $this$isCanonical, @NotNull WasmBackendContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isCanonical, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if ($this$isCanonical.getCatches().size() > 2) return false;
        Iterable $this$all$iv = $this$isCanonical.getCatches();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                IrCatch it = (IrCatch)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getCatchParameter().getType(), (Object)context2.getIrBuiltIns().getThrowableType())) {
                    if (!Intrinsics.areEqual((Object)it.getCatchParameter().getType(), (Object)IrTypesKt.getDefaultType(context2.getWasmSymbols().getJsRelatedSymbols().getJsException()))) return false;
                }
                boolean bl3 = true;
                if (bl3) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if ($this$isCanonical.getFinallyExpression() != null) return false;
        return true;
    }

    public static final boolean isAbstractOrSealed(@NotNull IrClass $this$isAbstractOrSealed) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbstractOrSealed, (String)"<this>");
        return $this$isAbstractOrSealed.getModality() == Modality.ABSTRACT || $this$isAbstractOrSealed.getModality() == Modality.SEALED;
    }

    @Nullable
    public static final IrSimpleFunction getFunctionInvokeMethod(@NotNull IrClass iFace) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)iFace, (String)"iFace");
            if (!IrTypeUtilsKt.isFunction(iFace.getSymbol())) {
                return null;
            }
            Iterable $this$singleOrNull$iv = iFace.getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrSimpleFunction && !((IrSimpleFunction)it).isFakeOverride())) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        Object var1_9 = v0;
        return var1_9 instanceof IrSimpleFunction ? (IrSimpleFunction)var1_9 : null;
    }
}

