/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Objects;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class BasicArrayType<T, E>
extends AbstractSingleColumnStandardBasicType<T>
implements AdjustableBasicType<T>,
BasicPluralType<T, E> {
    private final BasicType<E> baseDescriptor;
    private final String name;

    public BasicArrayType(BasicType<E> baseDescriptor, JdbcType arrayJdbcType, JavaType<T> arrayTypeDescriptor) {
        super(arrayJdbcType, arrayTypeDescriptor);
        this.baseDescriptor = baseDescriptor;
        this.name = BasicArrayType.determineArrayTypeName(baseDescriptor);
    }

    static String determineElementTypeName(BasicType<?> baseDescriptor) {
        String elementName;
        switch (elementName = baseDescriptor.getName()) {
            case "boolean": 
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": {
                return Character.toUpperCase(elementName.charAt(0)) + elementName.substring(1);
            }
        }
        return elementName;
    }

    static String determineArrayTypeName(BasicType<?> baseDescriptor) {
        return BasicArrayType.determineElementTypeName(baseDescriptor) + "[]";
    }

    @Override
    public BasicType<E> getElementType() {
        return this.baseDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<X> domainJtd) {
        return this;
    }

    public boolean equals(Object o) {
        return o == this || o.getClass() == BasicArrayType.class && Objects.equals(this.baseDescriptor, ((BasicArrayType)o).baseDescriptor);
    }

    public int hashCode() {
        return this.baseDescriptor.hashCode();
    }
}

