/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.memory;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedObject;

public final class ParallelHeapSummaryHandler
implements RecordedEventHandler {
    private static final Logger logger = Logger.getLogger(ParallelHeapSummaryHandler.class.getName());
    private static final String EVENT_NAME = "jdk.PSHeapSummary";
    private static final String BEFORE = "Before GC";
    private static final String AFTER = "After GC";
    private static final String GC_ID = "gcId";
    private static final String WHEN = "when";
    private static final String SIZE = "size";
    private static final Attributes ATTR_MEMORY_EDEN = Attributes.of(Constants.ATTR_MEMORY_TYPE, (Object)"heap", Constants.ATTR_MEMORY_POOL, (Object)"PS Eden Space");
    private static final Attributes ATTR_MEMORY_SURVIVOR = Attributes.of(Constants.ATTR_MEMORY_TYPE, (Object)"heap", Constants.ATTR_MEMORY_POOL, (Object)"PS Survivor Space");
    private static final Attributes ATTR_MEMORY_OLD = Attributes.of(Constants.ATTR_MEMORY_TYPE, (Object)"heap", Constants.ATTR_MEMORY_POOL, (Object)"PS Old Gen");
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long usageEden = 0L;
    private volatile long usageEdenAfter = 0L;
    private volatile long usageSurvivor = 0L;
    private volatile long usageSurvivorAfter = 0L;
    private volatile long usageOld = 0L;
    private volatile long usageOldAfter = 0L;
    private volatile long committedOld = 0L;
    private volatile long committedSurvivor = 0L;
    private volatile long committedEden = 0L;
    private volatile long limitOld = 0L;
    private volatile long limitYoung = 0L;

    public ParallelHeapSummaryHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.used").setDescription("Measure of memory used.").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.usageEden, ATTR_MEMORY_EDEN);
            measurement.record(this.usageSurvivor, ATTR_MEMORY_SURVIVOR);
            measurement.record(this.usageOld, ATTR_MEMORY_OLD);
        }));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.used_after_last_gc").setDescription("Measure of memory used, as measured after the most recent garbage collection event on this pool.").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.usageEdenAfter, ATTR_MEMORY_EDEN);
            measurement.record(this.usageSurvivorAfter, ATTR_MEMORY_SURVIVOR);
            measurement.record(this.usageOldAfter, ATTR_MEMORY_OLD);
        }));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.committed").setDescription("Measure of memory committed.").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.committedOld, ATTR_MEMORY_OLD);
            measurement.record(this.committedEden, ATTR_MEMORY_EDEN);
            measurement.record(this.committedSurvivor, ATTR_MEMORY_SURVIVOR);
        }));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.limit").setDescription("Measure of max obtainable memory.").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.limitOld, ATTR_MEMORY_OLD);
            measurement.record(this.limitYoung, ATTR_MEMORY_EDEN);
            measurement.record(this.limitYoung, ATTR_MEMORY_SURVIVOR);
        }));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.MEMORY_POOL_METRICS;
    }

    @Override
    public void accept(RecordedEvent ev) {
        if (!ev.hasField(WHEN)) {
            logger.fine(String.format("Parallel GC Event seen without when: %s", ev));
            return;
        }
        String when = ev.getString(WHEN);
        if (!BEFORE.equals(when) && !AFTER.equals(when)) {
            logger.fine(String.format("Parallel GC Event seen where when is neither before nor after: %s", ev));
            return;
        }
        if (!ev.hasField(GC_ID)) {
            logger.fine(String.format("Parallel GC Event seen without GC ID: %s", ev));
            return;
        }
        this.recordValues(ev, BEFORE.equals(when));
    }

    private static void doIfAvailable(RecordedEvent event, String field, Consumer<RecordedObject> closure) {
        if (!event.hasField(field)) {
            return;
        }
        Object value = event.getValue(field);
        if (value instanceof RecordedObject) {
            closure.accept((RecordedObject)value);
        }
    }

    private void recordValues(RecordedEvent event, boolean before) {
        ParallelHeapSummaryHandler.doIfAvailable(event, "edenSpace", edenSpace -> {
            if (edenSpace.hasField("used")) {
                if (before) {
                    this.usageEden = edenSpace.getLong("used");
                } else {
                    this.usageEdenAfter = edenSpace.getLong("used");
                }
            }
            if (edenSpace.hasField(SIZE)) {
                this.committedEden = edenSpace.getLong(SIZE);
            }
        });
        ParallelHeapSummaryHandler.doIfAvailable(event, "fromSpace", fromSpace -> {
            if (fromSpace.hasField("used")) {
                if (before) {
                    this.usageSurvivor = fromSpace.getLong("used");
                } else {
                    this.usageSurvivorAfter = fromSpace.getLong("used");
                }
            }
            if (fromSpace.hasField(SIZE)) {
                this.committedSurvivor = fromSpace.getLong(SIZE);
            }
        });
        ParallelHeapSummaryHandler.doIfAvailable(event, "oldObjectSpace", oldObjectSpace -> {
            if (oldObjectSpace.hasField("used")) {
                if (before) {
                    this.usageSurvivor = oldObjectSpace.getLong("used");
                } else {
                    this.usageSurvivorAfter = oldObjectSpace.getLong("used");
                }
            }
        });
        ParallelHeapSummaryHandler.doIfAvailable(event, "oldSpace", oldSpace -> {
            if (oldSpace.hasField("committedSize")) {
                this.committedOld = oldSpace.getLong("committedSize");
            }
            if (oldSpace.hasField("reservedSize")) {
                this.limitOld = oldSpace.getLong("reservedSize");
            }
        });
        ParallelHeapSummaryHandler.doIfAvailable(event, "youngSpace", oldSpace -> {
            if (oldSpace.hasField("reservedSize")) {
                this.limitYoung = oldSpace.getLong("reservedSize");
            }
        });
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

