/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import java.util.Optional;
import javafx.beans.property.Property;
import javafx.event.Event;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;

class TableViewColumnContextMenuHelper {
    private final TableView<?> tableView;
    private ContextMenu tableContextMenu;

    public TableViewColumnContextMenuHelper(TableView<?> tableView) {
        this.tableView = tableView;
        tableView.setTableMenuButtonVisible(true);
        tableView.skinProperty().addListener(observable -> {
            tableView.tableMenuButtonVisibleProperty().addListener((observableValue, bl, newValue) -> {
                if (newValue.booleanValue()) {
                    this.registerListeners();
                }
            });
            if (tableView.isTableMenuButtonVisible()) {
                this.registerListeners();
            }
        });
    }

    private void registerListeners() {
        this.getMenuButton().ifPresent(node -> node.setOnMousePressed(event -> {
            this.showContextMenu();
            event.consume();
        }));
    }

    private Optional<Node> getMenuButton() {
        return this.getTableHeaderRow().flatMap(headerRow -> headerRow.getChildren().stream().filter(child -> child.getStyleClass().contains((Object)"show-hide-columns-button")).findAny());
    }

    private Optional<TableHeaderRow> getTableHeaderRow() {
        TableViewSkin tableSkin = (TableViewSkin)this.tableView.getSkin();
        if (tableSkin == null) {
            return Optional.empty();
        }
        return tableSkin.getChildren().stream().filter(child -> child instanceof TableHeaderRow).map(node -> (TableHeaderRow)node).findAny();
    }

    protected void showContextMenu() {
        if (this.tableContextMenu != null) {
            this.tableContextMenu.hide();
        } else {
            this.getMenuButton().ifPresent(buttonNode -> {
                this.tableContextMenu = this.createContextMenu();
                this.tableContextMenu.setOnHidden(windowEvent -> {
                    this.tableContextMenu = null;
                });
                this.tableContextMenu.show(buttonNode, Side.BOTTOM, 0.0, 0.0);
                this.tableContextMenu.setX(buttonNode.localToScreen(buttonNode.getBoundsInLocal()).getMaxX() - this.tableContextMenu.getWidth());
            });
        }
    }

    private ContextMenu createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().add((Object)this.createSelectAllMenuItem(contextMenu));
        contextMenu.getItems().add((Object)this.createDeselectAllMenuItem(contextMenu));
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        this.addColumnCustomMenuItems(contextMenu);
        return contextMenu;
    }

    private CustomMenuItem createSelectAllMenuItem(ContextMenu contextMenu) {
        Label selectAllLabel = new Label("Alle ausw\u00e4hlen");
        contextMenu.focusedProperty().addListener(observable -> selectAllLabel.setPrefWidth(contextMenu.getWidth() * 0.75));
        CustomMenuItem selectAllMenuItem = new CustomMenuItem((Node)selectAllLabel);
        selectAllMenuItem.setOnAction(this::selectAll);
        selectAllMenuItem.setHideOnClick(false);
        return selectAllMenuItem;
    }

    private void selectAll(Event event) {
        this.tableView.getColumns().forEach(column -> column.setVisible(true));
        event.consume();
    }

    private CustomMenuItem createDeselectAllMenuItem(ContextMenu contextMenu) {
        Label deselectAllLabel = new Label("Alle abw\u00e4hlen");
        contextMenu.focusedProperty().addListener(observable -> deselectAllLabel.setPrefWidth(contextMenu.getWidth() * 0.75));
        CustomMenuItem deselectAllMenuItem = new CustomMenuItem((Node)deselectAllLabel);
        deselectAllMenuItem.setOnAction(this::deselectAll);
        deselectAllMenuItem.setHideOnClick(false);
        return deselectAllMenuItem;
    }

    private void deselectAll(Event event) {
        this.tableView.getColumns().forEach(column -> column.setVisible(false));
        event.consume();
    }

    private void addColumnCustomMenuItems(ContextMenu contextMenu) {
        this.tableView.getColumns().forEach(column -> contextMenu.getItems().add((Object)this.createColumnCustomMenuItem(contextMenu, (TableColumn<?, ?>)column)));
    }

    protected CustomMenuItem createColumnCustomMenuItem(ContextMenu contextMenu, TableColumn<?, ?> column) {
        CheckBox checkBox = new CheckBox(column.getText());
        contextMenu.focusedProperty().addListener(observable -> checkBox.setPrefWidth(contextMenu.getWidth() * 0.75));
        checkBox.selectedProperty().bindBidirectional((Property)column.visibleProperty());
        CustomMenuItem customMenuItem = new CustomMenuItem((Node)checkBox);
        customMenuItem.getStyleClass().set(1, (Object)"check-menu-item");
        customMenuItem.setOnAction(event -> {
            checkBox.setSelected(!checkBox.isSelected());
            event.consume();
        });
        customMenuItem.setHideOnClick(false);
        return customMenuItem;
    }
}

