/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.SimpleTreeFactory;
import edu.stanford.nlp.trees.Tree;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabeledScoredTreeFactory
extends SimpleTreeFactory {
    private LabelFactory lf;

    public LabeledScoredTreeFactory() {
        this(CoreLabel.factory());
    }

    public LabeledScoredTreeFactory(LabelFactory lf) {
        this.lf = lf;
    }

    @Override
    public Tree newLeaf(String word) {
        return new LabeledScoredTreeNode(this.lf.newLabel(word));
    }

    @Override
    public Tree newLeaf(Label label) {
        return new LabeledScoredTreeNode(this.lf.newLabel(label));
    }

    @Override
    public Tree newTreeNode(String parent, List<Tree> children) {
        return new LabeledScoredTreeNode(this.lf.newLabel(parent), children);
    }

    @Override
    public Tree newTreeNode(Label parentLabel, List<Tree> children) {
        return new LabeledScoredTreeNode(this.lf.newLabel(parentLabel), children);
    }
}

