/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.text.ParseException;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public class DualResolver
extends AbstractResolver {
    private DependencyResolver ivyResolver;
    private DependencyResolver artifactResolver;
    private boolean allownomd = true;

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        if (this.ivyResolver == null || this.artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        ResolvedModuleRevision resolvedModuleRevision = resolveData.getCurrentResolvedModuleRevision();
        ResolvedModuleRevision resolvedModuleRevision2 = this.ivyResolver.getDependency(dependencyDescriptor, resolveData = new ResolveData(resolveData, this.doValidate(resolveData)));
        if (resolvedModuleRevision2 == null) {
            this.checkInterrupted();
            if (this.isAllownomd()) {
                Message.verbose("ivy resolver didn't find " + dependencyDescriptor + ": trying with artifact resolver");
                return this.artifactResolver.getDependency(dependencyDescriptor, resolveData);
            }
            return null;
        }
        if (resolvedModuleRevision2 == resolvedModuleRevision) {
            return resolvedModuleRevision2;
        }
        return new ResolvedModuleRevision(resolvedModuleRevision2.getResolver(), this, resolvedModuleRevision2.getDescriptor(), resolvedModuleRevision2.getReport(), resolvedModuleRevision2.isForce());
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        return this.ivyResolver.findIvyFileRef(dependencyDescriptor, resolveData);
    }

    @Override
    public void reportFailure() {
        this.ivyResolver.reportFailure();
        this.artifactResolver.reportFailure();
    }

    @Override
    public void reportFailure(Artifact artifact) {
        this.ivyResolver.reportFailure(artifact);
        this.artifactResolver.reportFailure(artifact);
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        return this.artifactResolver.download(artifactArray, downloadOptions);
    }

    public DependencyResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public DependencyResolver getIvyResolver() {
        return this.ivyResolver;
    }

    @Override
    public void dumpSettings() {
        if (this.ivyResolver == null || this.artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        Message.verbose("\t" + this.getName() + " [dual " + this.ivyResolver.getName() + " " + this.artifactResolver.getName() + "]");
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        if (artifact.isMetadata()) {
            return this.ivyResolver.locate(artifact);
        }
        return this.artifactResolver.locate(artifact);
    }

    public boolean isAllownomd() {
        return this.allownomd;
    }
}

