/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

final class SchemaRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SchemaRetriever.class.getName());
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;

    SchemaRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
        this.supportsCatalogs = retrieverConnection.isSupportsCatalogs();
        this.supportsSchemas = retrieverConnection.isSupportsSchemas();
    }

    void retrieveSchemas(InclusionRule schemaInclusionRule) throws SQLException {
        InclusionRuleFilter<SchemaReference> schemaFilter = new InclusionRuleFilter<SchemaReference>(schemaInclusionRule, true);
        if (schemaFilter.isExcludeAll()) {
            return;
        }
        Set<SchemaReference> schemaRefs = this.retrieveAllSchemasFromInformationSchemaViews();
        if (schemaRefs.isEmpty()) {
            schemaRefs.addAll(this.retrieveAllSchemas());
        }
        LOGGER.log(Level.FINER, new StringFormat("Retrieved schemas <%s>", schemaRefs));
        Identifiers identifiers = this.getRetrieverConnection().getIdentifiers();
        Iterator<SchemaReference> iterator = schemaRefs.iterator();
        while (iterator.hasNext()) {
            SchemaReference schemaRef = iterator.next();
            schemaRef.withQuoting(identifiers);
            if (schemaFilter.test(schemaRef)) continue;
            LOGGER.log(Level.FINER, new StringFormat("Excluding schema <%s>", schemaRef));
            iterator.remove();
        }
        for (SchemaReference schemaRef : schemaRefs) {
            this.catalog.addSchema(schemaRef);
        }
        if (!this.supportsCatalogs && !this.supportsSchemas) {
            this.catalog.addSchema(new SchemaReference(null, null));
        }
    }

    private Set<String> retrieveAllCatalogs() {
        LOGGER.log(Level.INFO, "Retrieving all catalogs");
        HashSet<String> catalogNames = new HashSet<String>();
        if (this.supportsCatalogs) {
            RetrievalCounts retrievalCounts = new RetrievalCounts("catalogs");
            try (Connection connection = this.getRetrieverConnection().getConnection();
                 ResultSet catalogsResults = connection.getMetaData().getCatalogs();){
                List<String> metaDataCatalogNames = DatabaseUtility.readResultsVector(catalogsResults);
                for (String catalogName : metaDataCatalogNames) {
                    retrievalCounts.count();
                    catalogNames.add(catalogName);
                    retrievalCounts.countIncluded();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            retrievalCounts.log();
            LOGGER.log(Level.FINER, new StringFormat("Retrieved catalogs <%s>", catalogNames));
        }
        return catalogNames;
    }

    private Set<SchemaReference> retrieveAllSchemas() throws SQLException {
        LOGGER.log(Level.INFO, "Retrieving all schemas");
        HashSet<SchemaReference> schemaRefs = new HashSet<SchemaReference>();
        Set<String> allCatalogNames = this.retrieveAllCatalogs();
        if (this.supportsSchemas) {
            RetrievalCounts retrievalCounts = new RetrievalCounts("schemas");
            try (Connection connection = this.getRetrieverConnection().getConnection();
                 MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getSchemas(), "DatabaseMetaData::getSchemas");){
                while (results.next()) {
                    retrievalCounts.count();
                    String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                    String schemaName = results.getString("TABLE_SCHEM");
                    LOGGER.log(Level.FINER, new StringFormat("Retrieving schema: %s --> %s", catalogName, schemaName));
                    if (catalogName == null) {
                        if (allCatalogNames.isEmpty()) {
                            schemaRefs.add(new SchemaReference(null, schemaName));
                        } else {
                            for (String expectedCatalogName : allCatalogNames) {
                                schemaRefs.add(new SchemaReference(expectedCatalogName, schemaName));
                            }
                        }
                    } else {
                        schemaRefs.add(new SchemaReference(catalogName, schemaName));
                    }
                    retrievalCounts.countIncluded();
                }
            }
            retrievalCounts.log();
        } else {
            for (String catalogName : allCatalogNames) {
                LOGGER.log(Level.FINER, new StringFormat("Retrieving schema: %s --> %s", catalogName, null));
                schemaRefs.add(new SchemaReference(catalogName, null));
            }
        }
        return schemaRefs;
    }

    private Set<SchemaReference> retrieveAllSchemasFromInformationSchemaViews() throws SQLException {
        HashSet<SchemaReference> schemaRefs = new HashSet<SchemaReference>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SCHEMATA)) {
            LOGGER.log(Level.FINE, "Schemata SQL statement was not provided");
            return schemaRefs;
        }
        RetrievalCounts retrievalCounts = new RetrievalCounts("schemas");
        Query schemataSql = informationSchemaViews.getQuery(InformationSchemaKey.SCHEMATA);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(schemataSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = results.getString("CATALOG_NAME");
                String schemaName = results.getString("SCHEMA_NAME");
                LOGGER.log(Level.FINER, new StringFormat("Retrieving schema: %s --> %s", catalogName, schemaName));
                schemaRefs.add(new SchemaReference(catalogName, schemaName));
                retrievalCounts.countIncluded();
            }
            retrievalCounts.log();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve schemas", e);
        }
        return schemaRefs;
    }
}

