/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.string.StringFormat;

final class PrimaryKeyRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(PrimaryKeyRetriever.class.getName());

    PrimaryKeyRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrievePrimaryKeys(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.primaryKeysRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving primary keys, using fast data dictionary retrieval");
                this.retrievePrimaryKeysFromDataDictionary();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving primary keys");
                this.retrievePrimaryKeysFromMetadata(allTables);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving primary keys");
            }
        }
    }

    private void createPrimaryKeyForTable(MutableTable table, MetadataResultSet results) {
        Optional<MutableColumn> columnOptional;
        String columnName = results.getString("COLUMN_NAME");
        String primaryKeyName = results.getString("PK_NAME");
        short keySequence = results.getShort("KEY_SEQ", (short)1);
        LOGGER.log(Level.FINE, new StringFormat("Retrieving primary column <%s.%s.%s>", table, primaryKeyName, columnName));
        MutablePrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            primaryKey = MutablePrimaryKey.newPrimaryKey(table, primaryKeyName);
            table.setPrimaryKey(primaryKey);
        }
        if ((columnOptional = table.lookupColumn(columnName)).isPresent()) {
            MutableColumn column = columnOptional.get();
            column.markAsPartOfPrimaryKey();
            MutableTableConstraintColumn pkColumn = new MutableTableConstraintColumn(primaryKey, column);
            pkColumn.setKeyOrdinalPosition(keySequence);
            primaryKey.addColumn(pkColumn);
        }
        primaryKey.addAttributes(results.getAttributes());
    }

    private void retrievePrimaryKeysFromDataDictionary() throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.PRIMARY_KEYS)) {
            LOGGER.log(Level.FINE, "Extended primary keys SQL statement was not provided");
            return;
        }
        String name = "primary keys from data dictionary";
        RetrievalCounts retrievalCounts = new RetrievalCounts("primary keys from data dictionary");
        Query pkSql = informationSchemaViews.getQuery(InformationSchemaKey.PRIMARY_KEYS);
        try (Connection connection = this.getRetrieverConnection().getConnection("primary keys from data dictionary");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(pkSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> optionalTable = this.lookupTable(catalogName, schemaName, tableName);
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                this.createPrimaryKeyForTable(table, results);
                retrievalCounts.countIncluded();
            }
            retrievalCounts.log();
        }
        catch (SQLException e) {
            throw new WrappedSQLException(String.format("Could not retrieve primary keys from SQL:%n%s", pkSql), e);
        }
    }

    private void retrievePrimaryKeysFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        String name = "primary keys from metadata";
        RetrievalCounts retrievalCounts = new RetrievalCounts("primary keys from metadata");
        for (MutableTable table : allTables) {
            if (MetaDataUtility.isView(table)) continue;
            Schema tableSchema = table.getSchema();
            try {
                Connection connection = this.getRetrieverConnection().getConnection("primary keys from metadata");
                try (MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getPrimaryKeys(tableSchema.getCatalogName(), tableSchema.getName(), table.getName()), "DatabaseMetaData::getPrimaryKeys");){
                    while (results.next()) {
                        retrievalCounts.count();
                        this.createPrimaryKeyForTable(table, results);
                        retrievalCounts.countIncluded();
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve primary keys for table <%s>", table), e);
            }
        }
        retrievalCounts.log();
    }
}

