/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableType;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import us.fatehi.utility.string.StringFormat;

final class TableRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableRetriever.class.getName());

    TableRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveTables(String tableNamePattern, TableTypes tableTypes, InclusionRule tableInclusionRule) throws SQLException {
        Objects.requireNonNull(tableTypes, "No table types provided");
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        InclusionRuleFilter<Table> tableFilter = new InclusionRuleFilter<Table>(tableInclusionRule, false);
        if (tableFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving tables, since this was not requested");
            return;
        }
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tablesRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving tables, using fast data dictionary retrieval");
                this.retrieveTablesFromDataDictionary(schemas, tableTypes, tableFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving tables");
                this.retrieveTablesFromMetadata(schemas, tableNamePattern, tableTypes, tableFilter);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving tables");
            }
        }
    }

    private boolean createTable(MetadataResultSet results, NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Table> tableFilter, TableTypes filteredTableTypes) {
        String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
        String tableName = results.getString("TABLE_NAME");
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
        String tableTypeString = results.getString("TABLE_TYPE");
        String remarks = results.getString("REMARKS");
        Optional<SchemaReference> optionalSchema = schemas.lookup(new NamedObjectKey(catalogName, schemaName));
        if (!optionalSchema.isPresent()) {
            return false;
        }
        Schema schema = optionalSchema.get();
        TableType tableType = filteredTableTypes.lookupTableType(tableTypeString).orElse(TableType.UNKNOWN);
        if (tableType.equals(TableType.UNKNOWN)) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Not including table <%s.%s>, since table type <%s> was not requested", new Object[]{schema, tableName, tableTypeString}));
            return false;
        }
        MutableTable table = tableType.isView() ? new MutableView(schema, tableName) : new MutableTable(schema, tableName);
        table.withQuoting(this.getRetrieverConnection().getIdentifiers());
        if (tableFilter.test(table)) {
            table.setTableType(tableType);
            table.setRemarks(remarks);
            table.addAttributes(results.getAttributes());
            this.catalog.addTable(table);
            return true;
        }
        return false;
    }

    private void retrieveTablesFromDataDictionary(NamedObjectList<SchemaReference> schemas, TableTypes tableTypes, InclusionRuleFilter<Table> tableFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLES)) {
            throw new ExecutionRuntimeException("No tables SQL provided");
        }
        String name = "tables from data dictionary";
        RetrievalCounts retrievalCounts = new RetrievalCounts("tables from data dictionary");
        Query tablesSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLES);
        TableTypes supportedTableTypes = this.getRetrieverConnection().getTableTypes();
        TableTypes filteredTableTypes = tableTypes.isIncludeAll() ? supportedTableTypes : tableTypes;
        try (Connection connection = this.getRetrieverConnection().getConnection("tables from data dictionary");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tablesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.createTable(results, schemas, tableFilter, filteredTableTypes);
                retrievalCounts.countIfIncluded(added);
            }
        }
        retrievalCounts.log();
    }

    private void retrieveTablesFromMetadata(NamedObjectList<SchemaReference> schemas, String tableNamePattern, TableTypes tableTypes, InclusionRuleFilter<Table> tableFilter) {
        String name = "tables from metadata";
        RetrievalCounts retrievalCounts = new RetrievalCounts("tables from metadata");
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieving tables for schema <%s>", new Object[]{schema}));
            TableTypes supportedTableTypes = this.getRetrieverConnection().getTableTypes();
            TableTypes filteredTableTypes = supportedTableTypes.subsetFrom(tableTypes);
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving table types <%s>", new Object[]{filteredTableTypes}));
            String catalogName = schema.getCatalogName();
            String schemaName = schema.getName();
            try (Connection connection = this.getRetrieverConnection().getConnection("tables from metadata");
                 MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getTables(catalogName, schemaName, tableNamePattern, filteredTableTypes.toArray()), "DatabaseMetaData::getTables");){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    this.createTable(results, schemas, tableFilter, supportedTableTypes);
                    retrievalCounts.countIncluded(schema.key());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not obtain tables in schema <%s>", new Object[]{schema}));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

