/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.operation;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseTabularFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.text.options.BaseTextOptions;
import schemacrawler.tools.traversal.DataTraversalHandler;
import us.fatehi.utility.Color;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.string.StringFormat;

public final class DataTextFormatter
extends BaseTabularFormatter<OperationOptions>
implements DataTraversalHandler {
    private static final Logger LOGGER = Logger.getLogger(DataTextFormatter.class.getName());
    private final Operation operation;
    private int dataBlockCount;

    private static String getMessage(double aggregate) {
        Number number = Math.abs(aggregate - (double)((int)aggregate)) < 1.0E-10 ? (Number)((int)aggregate) : (Number)aggregate;
        String message = TableRowCountsUtility.getRowCountMessage((Number)number);
        return message;
    }

    public DataTextFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions, Identifiers identifiers) {
        super(SchemaTextDetailType.schema, (BaseTextOptions)options, outputOptions, identifiers);
        this.operation = Objects.requireNonNull(operation, "No operation provided");
    }

    public void end() {
        if (this.operation == OperationType.count) {
            this.formattingHelper.writeObjectEnd();
        }
        super.end();
    }

    @Override
    public void handleData(Query query, ResultSet rows) {
        String title = query != null ? query.getName() : "";
        this.handleData(title, rows);
    }

    @Override
    public void handleData(Table table, ResultSet rows) {
        String tableName = table != null ? this.quoteName((DatabaseObject)table) : "";
        this.handleData(tableName, rows);
    }

    private void handleData(String title, ResultSet rows) {
        if (rows == null) {
            return;
        }
        if (this.dataBlockCount == 0) {
            this.printHeader();
        }
        if (this.operation == OperationType.count) {
            this.handleTableAggregateData(title, rows);
        } else {
            this.handleTableData(title, rows);
        }
        ++this.dataBlockCount;
    }

    private void handleTableAggregateData(String title, ResultSet results) {
        long aggregate;
        try {
            aggregate = DatabaseUtility.readResultsForLong((String)title, (ResultSet)results);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not obtain aggregate data for <%s>", new Object[]{title}));
            aggregate = 0L;
        }
        String message = DataTextFormatter.getMessage(aggregate);
        this.formattingHelper.writeNameValueRow(title, message, Alignment.right);
    }

    private void handleTableData(String title, ResultSet rows) {
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow("", title, "", Color.white);
        String name = String.format("Data for %s for <%s>", this.operation, title);
        RetrievalCounts retrievalCounts = new RetrievalCounts(name.toLowerCase());
        try (MetadataResultSet dataRows = new MetadataResultSet(rows, name);){
            dataRows.setShowLobs(((OperationOptions)this.options).isShowLobs());
            dataRows.setMaxRows(((OperationOptions)this.options).getMaxRows());
            this.formattingHelper.writeRowHeader(this.quoteColumnNames(dataRows.getColumnNames()));
            while (dataRows.next()) {
                retrievalCounts.count();
                List currentRow = dataRows.row();
                Object[] columnData = currentRow.toArray();
                this.formattingHelper.writeRow(columnData);
                retrievalCounts.countIncluded();
            }
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(String.format("Could not handle rows for <%s>", title), e);
        }
        this.formattingHelper.writeObjectEnd();
        retrievalCounts.log();
    }

    private void printHeader() {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, this.operation.getTitle());
        if (this.operation == OperationType.count) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeObjectNameRow("", this.operation.getTitle(), "", Color.white);
        }
    }

    private String[] quoteColumnNames(String[] columnNames) {
        String[] quotedColumnNames = Arrays.copyOf(columnNames, columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            String quotedColumnName;
            String columnName = columnNames[i];
            quotedColumnNames[i] = quotedColumnName = this.identifiers.quoteName(columnName);
        }
        return quotedColumnNames;
    }
}

