/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeNode<T> {
    private final String name;
    private final T value;
    private final List<TreeNode<?>> children = new ArrayList();

    public TreeNode(String name, T value) {
        this.name = name;
        this.value = value;
    }

    public TreeNode<?> addChild(TreeNode<?> child) {
        if (child != null) {
            this.children.add(child);
        }
        return child;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayDeque<NodeLevel> stack = new ArrayDeque<NodeLevel>();
        stack.push(new NodeLevel(this, 0));
        while (!stack.isEmpty()) {
            NodeLevel current = (NodeLevel)stack.pop();
            TreeNode node = current.node;
            int indentLevel = current.level;
            String indent = String.join((CharSequence)"", Collections.nCopies(indentLevel, "  "));
            sb.append(indent).append("- ").append(node.name).append(": ").append((Object)(node.value == null ? "" : node.value)).append("\n");
            if (node.children.isEmpty()) continue;
            sb.append(indent).append("  _:\n");
            for (int i = node.children.size() - 1; i >= 0; --i) {
                stack.push(new NodeLevel(node.children.get(i), indentLevel + 2));
            }
        }
        return sb.toString();
    }

    private static class NodeLevel {
        private final TreeNode<?> node;
        private final int level;

        NodeLevel(TreeNode<?> node, int level) {
            this.node = node;
            this.level = level;
        }
    }
}

