/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.metadata;

import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanIntrospection;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class BeanInformationCache {
    private static Map<Class<?>, BeanInformation> beanMap_ = Collections.synchronizedMap(new WeakHashMap(80));

    public static BeanInformation getBeanInformation(Class<?> clazz) {
        BeanInformation beanInformation = beanMap_.get(clazz);
        if (null != beanInformation) {
            return beanInformation;
        }
        BeanIntrospection beanIntrospection = new BeanIntrospection();
        try {
            beanInformation = beanIntrospection.getBeanInstrospectionInformation(clazz);
            BeanInformationCache.addBeanToBeanMap(clazz, beanInformation);
            return beanInformation;
        }
        catch (DataSQLException dataSQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_BEANINFORMATION_INST", new Object[0]), dataSQLException, 10017);
        }
    }

    public static void addBeanToBeanMap(Class<?> clazz, BeanInformation beanInformation) {
        beanMap_.put(clazz, beanInformation);
    }
}

