/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;

public class ObjectToString {
    public static List<?> arrayToList(Object array) {
        if (array == null || !array.getClass().isArray()) {
            return null;
        }
        int length = Array.getLength(array);
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            objectList.add(Array.get(array, i));
        }
        return objectList;
    }

    public static List<Class<?>> classHierarchy(Object object) {
        ArrayList classHierarchy = new ArrayList();
        if (object != null) {
            Class<?> clazz = object.getClass();
            classHierarchy.add(clazz);
            while (clazz.getSuperclass() != null) {
                if ((clazz = clazz.getSuperclass()).getSuperclass() == null) continue;
                classHierarchy.add(clazz);
            }
        }
        return classHierarchy;
    }

    public static List<?> collectionOrArrayToList(Object object) {
        if (!ObjectToString.isCollectionOrArray(object)) {
            return new ArrayList();
        }
        if (object instanceof List) {
            List list = (List)object;
            return list;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return new ArrayList(collection);
        }
        return ObjectToString.arrayToList(object);
    }

    public static List<Field> fields(Object object) {
        Class<?> clazz;
        List<Class<?>> classes = ObjectToString.classHierarchy(object);
        ArrayList<Field> allFields = new ArrayList<Field>();
        Iterator<Class<?>> iterator = classes.iterator();
        while (!(!iterator.hasNext() || (clazz = iterator.next()).isArray() || clazz.isPrimitive() || clazz.isEnum() || String.class.isAssignableFrom(clazz))) {
            AccessibleObject[] fields = new Field[]{};
            try {
                fields = clazz.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            allFields.addAll(Arrays.asList(fields));
        }
        Iterator iterator2 = allFields.iterator();
        while (iterator2.hasNext()) {
            Field field = (Field)iterator2.next();
            int modifiers = field.getModifiers();
            if (!Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers)) continue;
            iterator2.remove();
        }
        Collections.sort(allFields, Comparator.comparing(Field::getName));
        return allFields;
    }

    public static boolean isCollectionOrArray(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        return Collection.class.isAssignableFrom(objectClass) || objectClass.isArray();
    }

    public static boolean isPrimitive(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        return Arrays.asList(Integer.class, Long.class, Double.class, Float.class, Boolean.class, Byte.class, Void.class, Short.class).contains(objectClass);
    }

    public static boolean isSimpleObject(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        return ObjectToString.isPrimitive(object) || object instanceof String || object instanceof Character || objectClass.isEnum();
    }

    public static String listOrObjectToString(Object object) {
        if (ObjectToString.isCollectionOrArray(object)) {
            List<?> list = ObjectToString.collectionOrArrayToList(object);
            StringJoiner listJoiner = new StringJoiner(", ");
            for (Object element : list) {
                listJoiner.add(String.valueOf(element));
            }
            return listJoiner.toString();
        }
        return String.valueOf(object);
    }

    public static Map<String, Object> objectMap(Object object) {
        TreeMap<String, Object> objectMap = new TreeMap<String, Object>();
        if (object == null || ObjectToString.isCollectionOrArray(object) || ObjectToString.isSimpleObject(object)) {
            return objectMap;
        }
        Class<?> objectClass = object.getClass();
        if (Map.class.isAssignableFrom(objectClass)) {
            Set mapEntries = ((Map)object).entrySet();
            for (Map.Entry mapEntry : mapEntries) {
                objectMap.put(String.valueOf(mapEntry.getKey()), mapEntry.getValue());
            }
        } else {
            objectMap.put("@object", object.getClass().getName());
            for (Field field : ObjectToString.fields(object)) {
                try {
                    List<?> value = field.get(object);
                    if (ObjectToString.isCollectionOrArray(value)) {
                        value = ObjectToString.collectionOrArrayToList(value);
                    }
                    objectMap.put(field.getName(), value);
                }
                catch (Exception exception) {}
            }
        }
        return objectMap;
    }

    public static String toString(Object object) {
        if (object == null || ObjectToString.isSimpleObject(object)) {
            return String.valueOf(object);
        }
        if (ObjectToString.isCollectionOrArray(object)) {
            return ObjectToString.printList(ObjectToString.collectionOrArrayToList(object));
        }
        return ObjectToString.printMap(0, ObjectToString.objectMap(object));
    }

    private static char[] indent(int indent) {
        char[] indentChars = new char[indent * 2];
        Arrays.fill(indentChars, ' ');
        return indentChars;
    }

    private static String printList(List<?> list) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (ObjectToString.isPrimitive(object)) {
                buffer.append(String.valueOf(object));
            } else {
                buffer.append('\"').append(String.valueOf(object)).append('\"');
            }
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    private static String printMap(int indent, Map<String, Object> objectMap) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(objectMap);
        StringBuilder buffer = new StringBuilder();
        buffer.append(ObjectToString.indent(indent)).append('{').append(System.lineSeparator());
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            Object value = entry.getValue();
            if (value != null) {
                Class<?> valueClass = value.getClass();
                if (List.class.isAssignableFrom(valueClass)) {
                    value = ObjectToString.printList((List)value);
                } else if (Map.class.isAssignableFrom(valueClass)) {
                    value = ObjectToString.printMap(indent + 1, ObjectToString.objectMap(value));
                } else if (!ObjectToString.isPrimitive(value) || value instanceof String || valueClass.isEnum()) {
                    value = "\"%s\"".formatted(value);
                }
            }
            buffer.append(ObjectToString.indent(indent + 1)).append("\"").append(entry.getKey()).append("\": ").append(String.valueOf(value));
            if (iterator.hasNext()) {
                buffer.append(",");
            }
            buffer.append(System.lineSeparator());
        }
        buffer.append(ObjectToString.indent(indent)).append('}');
        return buffer.toString();
    }

    private ObjectToString() {
    }
}

