/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.IdentifiersBuilder;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationsOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.text.formatter.operation.DataJsonFormatter;
import schemacrawler.tools.text.formatter.operation.DataTextFormatter;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public final class OperationCommand
extends BaseSchemaCrawlerCommand<OperationOptions> {
    private static final Logger LOGGER = Logger.getLogger(OperationCommand.class.getName());

    public OperationCommand(PropertyName command) {
        super(command);
    }

    public void checkAvailability() {
    }

    public void execute() {
        DataTraversalHandler handler;
        block32: {
            this.checkCatalog();
            if (!this.isOutputFormatSupported()) {
                LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Output format <%s> not supported for command <%s>", new Object[]{this.outputOptions.getOutputFormatValue(), this.getCommandName().getName()}));
                return;
            }
            handler = this.getDataTraversalHandler();
            Query query = ((OperationOptions)((Object)this.commandOptions)).getQuery(this.informationSchemaViews);
            handler.begin();
            handler.handleHeaderStart();
            handler.handleHeader(this.catalog.getCrawlInfo());
            handler.handleHeaderEnd();
            if (query.isQueryOver()) {
                String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
                Identifiers identifiers = IdentifiersBuilder.builder().withIdentifierQuoteString(identifierQuoteString).withIdentifierQuotingStrategy(IdentifierQuotingStrategy.quote_all).toOptions();
                try (Statement statement = DatabaseUtility.createStatement((Connection)this.connection);){
                    for (Table table : this.getSortedTables(this.catalog)) {
                        boolean isAlphabeticalSortForTableColumns = ((OperationOptions)((Object)this.commandOptions)).isAlphabeticalSortForTableColumns();
                        try {
                            ResultSet results = QueryUtility.executeAgainstTable((Query)query, (Statement)statement, (Table)table, (boolean)isAlphabeticalSortForTableColumns, (Identifiers)identifiers);
                            try {
                                handler.handleData(table, results);
                            }
                            finally {
                                if (results == null) continue;
                                results.close();
                            }
                        }
                        catch (SQLException e) {
                            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Bad operation for table <%s>", new Object[]{table}));
                        }
                    }
                    break block32;
                }
                catch (SQLException e) {
                    throw new DatabaseAccessException("Could not run query %n%s%n".formatted(query), e);
                }
            }
            String sql = query.getQuery();
            try (Statement statement = DatabaseUtility.createStatement((Connection)this.connection);
                 ResultSet results = DatabaseUtility.executeSql((Statement)statement, (String)sql);){
                handler.handleData(query, results);
            }
            catch (SQLException e) {
                throw new DatabaseAccessException("Could not run query %n%s%n".formatted(query), e);
            }
        }
        handler.end();
    }

    public boolean usesConnection() {
        return true;
    }

    private DataTraversalHandler getDataTraversalHandler() {
        Operation operation = ((OperationOptions)((Object)this.commandOptions)).getOperation();
        OperationsOutputFormat outputFormat = OperationsOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        return switch (outputFormat) {
            case OperationsOutputFormat.text, OperationsOutputFormat.html -> new DataTextFormatter(operation, (OperationOptions)((Object)this.commandOptions), this.outputOptions, this.identifiers);
            default -> new DataJsonFormatter(operation, (OperationOptions)((Object)this.commandOptions), this.outputOptions);
        };
    }

    private List<? extends Table> getSortedTables(Catalog catalog) {
        ArrayList tables = new ArrayList(catalog.getTables());
        tables.sort(NamedObjectSort.getNamedObjectSort((boolean)((OperationOptions)((Object)this.commandOptions)).isAlphabeticalSortForTables()));
        return tables;
    }

    private boolean isOutputFormatSupported() {
        String outputFormatValue = this.outputOptions.getOutputFormatValue();
        boolean isOutputFormatSupported = OperationsOutputFormat.isSupportedFormat(outputFormatValue);
        return isOutputFormatSupported;
    }
}

