/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dcn;

import java.lang.reflect.Executable;
import java.util.EnumSet;
import java.util.logging.Logger;
import oracle.jdbc.dcn.RowChangeDescription;

public interface TableChangeDescription {
    public EnumSet<TableOperation> getTableOperations();

    public String getTableName();

    public int getObjectNumber();

    public RowChangeDescription[] getRowChangeDescription();

    public static final class TableOperation
    extends Enum<TableOperation> {
        public static final /* enum */ TableOperation ALL_ROWS;
        public static final /* enum */ TableOperation INSERT;
        public static final /* enum */ TableOperation UPDATE;
        public static final /* enum */ TableOperation DELETE;
        public static final /* enum */ TableOperation ALTER;
        public static final /* enum */ TableOperation DROP;
        private final int code;
        private static final /* synthetic */ TableOperation[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static TableOperation[] values() {
            return (TableOperation[])$VALUES.clone();
        }

        public static TableOperation valueOf(String name) {
            return Enum.valueOf(TableOperation.class, name);
        }

        private TableOperation(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final EnumSet<TableOperation> getTableOperations(int opcode) {
            EnumSet<TableOperation> ret = EnumSet.noneOf(TableOperation.class);
            if ((opcode & ALL_ROWS.getCode()) != 0) {
                ret.add(ALL_ROWS);
            }
            if ((opcode & INSERT.getCode()) != 0) {
                ret.add(INSERT);
            }
            if ((opcode & UPDATE.getCode()) != 0) {
                ret.add(UPDATE);
            }
            if ((opcode & DELETE.getCode()) != 0) {
                ret.add(DELETE);
            }
            if ((opcode & ALTER.getCode()) != 0) {
                ret.add(ALTER);
            }
            if ((opcode & DROP.getCode()) != 0) {
                ret.add(DROP);
            }
            return ret;
        }

        static {
            try {
                $$$methodRef$$$4 = TableOperation.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = TableOperation.class.getDeclaredMethod("getTableOperations", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = TableOperation.class.getDeclaredMethod("getCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = TableOperation.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = TableOperation.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ALL_ROWS = new TableOperation(1);
            INSERT = new TableOperation(2);
            UPDATE = new TableOperation(4);
            DELETE = new TableOperation(8);
            ALTER = new TableOperation(16);
            DROP = new TableOperation(32);
            $VALUES = new TableOperation[]{ALL_ROWS, INSERT, UPDATE, DELETE, ALTER, DROP};
        }
    }
}

