/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public enum RichCmpOp {
    Py_LT(SpecialMethodNames.T___LT__, "<"),
    Py_LE(SpecialMethodNames.T___LE__, "<="),
    Py_EQ(SpecialMethodNames.T___EQ__, "=="),
    Py_NE(SpecialMethodNames.T___NE__, "!="),
    Py_GT(SpecialMethodNames.T___GT__, ">"),
    Py_GE(SpecialMethodNames.T___GE__, ">=");

    public static final RichCmpOp[] VALUES;
    private final TruffleString pythonName;
    private final String opName;

    private RichCmpOp(TruffleString pythonName, String opName) {
        this.pythonName = pythonName;
        this.opName = opName;
    }

    public static RichCmpOp fromNative(int value) {
        try {
            return VALUES[value];
        }
        catch (IndexOutOfBoundsException ex) {
            throw CompilerDirectives.shouldNotReachHere((String)"Wrong 'op' argument to tp_richcompare");
        }
    }

    public static RichCmpOp fromName(TruffleString name) {
        for (RichCmpOp value : VALUES) {
            if (!value.pythonName.equalsUncached((AbstractTruffleString)name, PythonUtils.TS_ENCODING)) continue;
            return value;
        }
        return null;
    }

    public final TruffleString getPythonName() {
        return this.pythonName;
    }

    public final String getOpName() {
        return this.opName;
    }

    public final int asNative() {
        return this.ordinal();
    }

    public final boolean isEqOrNe() {
        return this == Py_EQ || this == Py_NE;
    }

    public final boolean isEq() {
        return this == Py_EQ;
    }

    public final boolean isNe() {
        return this == Py_NE;
    }

    public final boolean isLe() {
        return this == Py_LE;
    }

    public final boolean isLt() {
        return this == Py_LT;
    }

    public final boolean isGt() {
        return this == Py_GT;
    }

    public final boolean isGe() {
        return this == Py_GE;
    }

    public final boolean compareResultToBool(int result) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (result < 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (result <= 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (result == 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (result != 0) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (result > 0) {
                    yield true;
                }
                yield false;
            }
            case 5 -> result >= 0;
        };
    }

    public final boolean compare(double a, double b) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (a < b) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (a <= b) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (a == b) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (a != b) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (a > b) {
                    yield true;
                }
                yield false;
            }
            case 5 -> a >= b;
        };
    }

    public final boolean compare(long a, long b) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (a < b) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (a <= b) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (a == b) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (a != b) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (a > b) {
                    yield true;
                }
                yield false;
            }
            case 5 -> a >= b;
        };
    }

    public final boolean compare(int a, int b) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (a < b) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (a <= b) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (a == b) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (a != b) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (a > b) {
                    yield true;
                }
                yield false;
            }
            case 5 -> a >= b;
        };
    }

    public final boolean compare(byte a, byte b) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (a < b) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (a <= b) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (a == b) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (a != b) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (a > b) {
                    yield true;
                }
                yield false;
            }
            case 5 -> a >= b;
        };
    }

    public final boolean compare(boolean a, boolean b) {
        return this.compareResultToBool(PInt.intValue(a) - PInt.intValue(b));
    }

    public final RichCmpOp getSwapped() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Py_GT;
            case 1 -> Py_GE;
            case 2 -> Py_EQ;
            case 3 -> Py_NE;
            case 4 -> Py_LT;
            case 5 -> Py_LE;
        };
    }

    static {
        VALUES = RichCmpOp.values();
    }
}

