"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEmbeddedInfo = getEmbeddedInfo;
const language_core_1 = require("@vue/language-core");
const vscode_uri_1 = require("vscode-uri");
function getEmbeddedInfo(context, document, embeddedCodeId, languageId) {
    const uri = vscode_uri_1.URI.parse(document.uri);
    const decoded = context.decodeEmbeddedDocumentUri(uri);
    if (!decoded) {
        return;
    }
    if (embeddedCodeId) {
        if (typeof embeddedCodeId === 'string') {
            if (decoded[1] !== embeddedCodeId) {
                return;
            }
        }
        else if (!embeddedCodeId(decoded[1])) {
            return;
        }
    }
    if (languageId && document.languageId !== languageId) {
        return;
    }
    const sourceScript = context.language.scripts.get(decoded[0]);
    if (!sourceScript?.generated) {
        return;
    }
    const virtualCode = sourceScript.generated.embeddedCodes.get(decoded[1]);
    if (!virtualCode) {
        return;
    }
    const root = sourceScript.generated.root;
    if (!(root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    return {
        sourceScript: sourceScript,
        virtualCode,
        root,
    };
}
//# sourceMappingURL=utils.js.map