"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("../utils");
function create({ getDocumentHighlights }) {
    return {
        name: 'vue-document-highlights',
        capabilities: {
            documentHighlightProvider: true,
        },
        create(context) {
            return {
                async provideDocumentHighlights(document, position) {
                    const info = (0, utils_1.resolveEmbeddedCode)(context, document.uri);
                    if (info?.code.id !== 'main') {
                        return;
                    }
                    const { template } = info.root.sfc;
                    const offset = document.offsetAt(position);
                    if (template?.ast && offset >= template.startTagEnd && offset <= template.endTagStart) {
                        const pos = offset - template.startTagEnd;
                        for (const node of (0, language_core_1.forEachElementNode)(template.ast)) {
                            if (pos < node.loc.start.offset || pos > node.loc.end.offset) {
                                continue;
                            }
                            for (const tagOffset of (0, language_core_1.getElementTagOffsets)(node, template)) {
                                if (pos >= tagOffset && pos <= tagOffset + node.tag.length) {
                                    return;
                                }
                            }
                        }
                    }
                    const result = await getDocumentHighlights(info.root.fileName, offset);
                    return result
                        ?.filter(({ fileName }) => fileName === info.root.fileName)
                        .flatMap(({ highlightSpans }) => highlightSpans)
                        .map(({ textSpan, kind }) => ({
                        range: {
                            start: document.positionAt(textSpan.start),
                            end: document.positionAt(textSpan.start + textSpan.length),
                        },
                        kind: kind === 'reference'
                            ? 2
                            : kind === 'writtenReference'
                                ? 3
                                : 1,
                    }));
                },
            };
        },
    };
}
//# sourceMappingURL=vue-document-highlights.js.map