"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = register;
const language_service_1 = require("@volar/language-service");
const featureWorkers_1 = require("@volar/language-service/lib/utils/featureWorkers");
function register(htmlLs) {
    return (pugDoc, docContext) => {
        const htmlResult = htmlLs.findDocumentLinks(pugDoc.docs[1], docContext);
        return (0, language_service_1.transformLocations)(htmlResult, htmlRange => (0, featureWorkers_1.getSourceRange)(pugDoc.docs, htmlRange));
    };
}
//# sourceMappingURL=documentLinks.js.map