pike Module
     __________________________________________________________

   Table of Contents

   1. Admin Guide

        1.1. Overview
        1.2. How to use
        1.3. Dependencies

              1.3.1. OpenSIPS Modules
              1.3.2. External Libraries or Applications

        1.4. Exported Parameters

              1.4.1. sampling_time_unit (integer)
              1.4.2. reqs_density_per_unit (integer)
              1.4.3. remove_latency (integer)
              1.4.4. check_route (integer)
              1.4.5. pike_log_level (integer)

        1.5. Exported Functions

              1.5.1. pike_check_req()

        1.6. Exported MI Functions

              1.6.1. pike_list
              1.6.2. pike_rm

        1.7. Exported Events

              1.7.1. E_PIKE_BLOCKED

        1.8. Provided Status/Report Identifiers

   2. Developer Guide
   3. Contributors

        3.1. By Commit Statistics
        3.2. By Commit Activity

   4. Documentation

        4.1. Contributors

   List of Tables

   3.1. Top contributors by DevScore^(1), authored commits^(2) and
          lines added/removed^(3)

   3.2. Most recently active contributors^(1) to this module

   List of Examples

   1.1. Set sampling_time_unit parameter
   1.2. Set reqs_density_per_unit parameter
   1.3. Set remove_latency parameter
   1.4. Set check_route parameter
   1.5. Set pike_log_level parameter
   1.6. pike_check_req usage
   2.1. Tree of IP addresses

Chapter 1. Admin Guide

1.1. Overview

   The module provides a simple mechanism for DOS protection - DOS
   based on floods at network level. The module keeps trace of all
   (or selected ones) IPs of incoming SIP traffic (as source IP)
   and blocks the ones that exceeded some limit. Works
   simultaneous for IPv4 and IPv6 addresses.

   The module does not implement any actions on blocking - it just
   simply reports that there is a high traffic from an IP; what to
   do, is the administator decision (via scripting).

1.2. How to use

   There are 2 ways of using this module (as detecting flood
   attacks and as taking the right action to limit the impact on
   the system):
     * manual - from routing script you can force the check of the
       source IP of an incoming requests, using "pike_check_req"
       function. Note that this checking works only for SIP
       requests and you can decide (based on scripting logic) what
       source IPs to be monitored and what action to be taken when
       a flood is detected.
     * automatic - the module will install internal hooks to catch
       all incoming requests and replies (even if not well formed
       from SIP point of view) - more or less the module will
       monitor all incoming packages (from the network) on the SIP
       sockets. Each time the source IP of a package needs to be
       analyse (to see if trusted or not), the module will run a
       script route - see "check_route" module parameter -, where,
       based on custom logic, you can decide if that IP needs to
       be monitored for flooding or not. As action, when flood is
       detected, the module will automatically drop the packages.

1.3. Dependencies

1.3.1. OpenSIPS Modules

   The following modules must be loaded before this module:
     * No dependencies on other OpenSIPS modules.

1.3.2. External Libraries or Applications

   The following libraries or applications must be installed
   before running OpenSIPS with this module loaded:
     * None.

1.4. Exported Parameters

1.4.1. sampling_time_unit (integer)

   Time period used for sampling (or the sampling accuracy ;-) ).
   The smaller the better, but slower. If you want to detect
   peaks, use a small one. To limit the access (like total number
   of requests on a long period of time) to a proxy resource (a
   gateway for ex), use a bigger value of this parameter.

   IMPORTANT: a too small value may lead to performance penalties
   due timer process overloading.

   Default value is 2.

   Example 1.1. Set sampling_time_unit parameter
...
modparam("pike", "sampling_time_unit", 10)
...

1.4.2. reqs_density_per_unit (integer)

   How many requests should be allowed per sampling_time_unit
   before blocking all the incoming request from that IP.
   Practically, the blocking limit is between ( let's have
   x=reqs_density_per_unit) x and 3*x for IPv4 addresses and
   between x and 8*x for ipv6 addresses.

   Default value is 30.

   Example 1.2. Set reqs_density_per_unit parameter
...
modparam("pike", "reqs_density_per_unit", 30)
...

1.4.3. remove_latency (integer)

   For how long the IP address will be kept in memory after the
   last request from that IP address. It's a sort of timeout
   value.

   Note: If the remove_latency value is lower than
   sampling_time_unit value, nodes might expire before being
   unblocked, therefore losing some UNBLOCK events. In order to
   prevent this, if the remove_latency is lower, OpenSIPS
   internally forces its value to sampling_time_unit + 1.

   Default value is 120.

   Example 1.3. Set remove_latency parameter
...
modparam("pike", "remove_latency", 130)
...

1.4.4. check_route (integer)

   The name of the script route to be triggers (in automatic way)
   when a package is received from the network. If you do a "drop"
   in this route, it will indicate to the module that the source
   IP of the package does not need to be monitored. Otherwise, the
   source IP will be automatically monitered.

   By defining this parameter, the automatic checking mode is
   enabled.

   Default value is NONE (no auto mode).

   Example 1.4. Set check_route parameter
...
modparam("pike", "check_route", "pike")
...
route[pike]{
    if ($si==111.222.111.222)  /*trusted, do not check it*/
        drop;
    /* all other IPs are checked*/
}
....

1.4.5. pike_log_level (integer)

   Log level to be used by module to auto report the blocking
   (only first time) and unblocking of IPs detected as source of
   floods.

   Default value is 1 (L_WARN).

   Example 1.5. Set pike_log_level parameter
...
modparam("pike", "pike_log_level", -1)
...

1.5. Exported Functions

1.5.1.  pike_check_req()

   Process the source IP of the current request and returns false
   if the IP was exceeding the blocking limit.

   Return codes:
     * 1 (true) - IP is not to be blocked or internal error
       occurred.

Warning
       IMPORTANT: in case of internal error, the function returns
       true to avoid reporting the current processed IP as
       blocked.
     * -1 (false) - IP is source of flooding, being previously
       detected
     * -2 (false) - IP is detected as a new source of flooding -
       first time detection

   This function can be used from REQUEST_ROUTE.

   Example 1.6. pike_check_req usage
...
if (!pike_check_req()) { exit; };
...

1.6. Exported MI Functions

1.6.1.  pike_list

   Lists the nodes in the pike tree.

   Name: pike_list

   Parameters: none

   MI FIFO Command Format:
                opensips-cli -x mi pike_list

1.6.2.  pike_rm

   Remove a node from the pike tree by IP address.

   Name: pike_rm

   Parameters:
     * IP - IP address currently blocked.

   MI FIFO Command Format:
                opensips-cli -x mi pike_rm 10.0.0.106

1.7. Exported Events

1.7.1.  E_PIKE_BLOCKED

   This event is raised when the pike module decides that an IP
   should be blocked.

   Parameters:
     * ip - the IP address that has been blocked.

1.8. Provided Status/Report Identifiers

   The module provides the "pike" Status/Report group, only with
   the "main"/default SR identifier.

   There is no usefull status published by the module.

   In terms of reports/logs, the following events will be
   reported:
     * IP X.Y.Z.W detected as flooding

   For how to access and use the Status/Report information, please
   see
   https://www.opensips.org/Documentation/Interface-StatusReport-3
   -3.

Chapter 2. Developer Guide

   One single tree (for both IPv4 and IPv6) is used. Each node
   contains a byte, the IP addresses stretching from root to the
   leafs.

   Example 2.1. Tree of IP addresses
           / 193 - 175 - 132 - 164
tree root /                  \ 142
          \ 195 - 37 - 78 - 163
           \ 79 - 134

   To detect the whole address, step by step, from the root to the
   leafs, the nodes corresponding to each byte of the ip address
   are expanded. In order to be expended a node has to be hit for
   a given number of times (possible by different addresses; in
   the previous example, the node “37” was expended by the
   195.37.78.163 and 195.37.79.134 hits).

   For 193.175.132.164 with x= reqs_density_per_unit:
     * After first req hits -> the “193” node is built.
     * After x more hits, the “175” node is build; the hits of
       “193” node are split between itself and its child--both of
       them gone have x/2.
     * And so on for node “132” and “164”.
     * Once “164” build the entire address can be found in the
       tree. “164” becomes a leaf. After it will be hit as a leaf
       for x times, it will become “RED” (further request from
       this address will be blocked).

   So, to build and block this address were needed 3*x hits. Now,
   if reqs start coming from 193.175.132.142, the first 3 bytes
   are already in the tree (they are shared with the previous
   address), so I will need only x hits (to build node “142” and
   to make it “RED”) to make this address also to be blocked. This
   is the reason for the variable number of hits necessary to
   block an IP.

   The maximum number of hits to turn an address red are (n is the
   address's number of bytes):

   1 (first byte) + x (second byte) + (x / 2) * (n - 2) (for the
   rest of the bytes) + (n - 1) (to turn the node to red).

   So, for IPv4 (n = 4) will be 3x and for IPv6 (n = 16) will be
   9x. The minimum number of hits to turn an address red is x.

Chapter 3. Contributors

3.1. By Commit Statistics

   Table 3.1. Top contributors by DevScore^(1), authored
   commits^(2) and lines added/removed^(3)
     Name DevScore Commits Lines ++ Lines --
   1. Bogdan-Andrei Iancu (@bogdan-iancu) 140 59 4217 2675
   2. Andrei Pelinescu-Onciul 16 8 120 336
   3. Razvan Crainea (@razvancrainea) 13 11 94 18
   4. Liviu Chircu (@liviuchircu) 13 10 29 69
   5. Daniel-Constantin Mierla (@miconda) 11 9 24 20
   6. Jan Janak (@janakj) 9 4 386 34
   7. Vlad Patrascu (@rvlad-patrascu) 8 6 73 52
   8. Jiri Kuthan (@jiriatipteldotorg) 6 3 257 0
   9. Jarrod Baumann (@jarrodb) 5 3 111 22
   10. Maksym Sobolyev (@sobomax) 4 2 3 4

   All remaining contributors: Henning Westerholt (@henningw),
   Elena-Ramona Modroiu, Ancuta Onofrei, Konstantin Bokarius,
   Julián Moreno Patiño, Jesus Rodrigues, Norman Brandinger
   (@NormB), Peter Lemenkov (@lemenkov), Edson Gellert Schubert.

   (1) DevScore = author_commits + author_lines_added /
   (project_lines_added / project_commits) + author_lines_deleted
   / (project_lines_deleted / project_commits)

   (2) including any documentation-related commits, excluding
   merge commits. Regarding imported patches/code, we do our best
   to count the work on behalf of the proper owner, as per the
   "fix_authors" and "mod_renames" arrays in
   opensips/doc/build-contrib.sh. If you identify any
   patches/commits which do not get properly attributed to you,
   please submit a pull request which extends "fix_authors" and/or
   "mod_renames".

   (3) ignoring whitespace edits, renamed files and auto-generated
   files

3.2. By Commit Activity

   Table 3.2. Most recently active contributors^(1) to this module
                      Name                   Commit Activity
   1.  Liviu Chircu (@liviuchircu)         Mar 2014 - May 2024
   2.  Bogdan-Andrei Iancu (@bogdan-iancu) Jun 2002 - May 2023
   3.  Maksym Sobolyev (@sobomax)          Feb 2023 - Feb 2023
   4.  Razvan Crainea (@razvancrainea)     May 2011 - Sep 2019
   5.  Vlad Patrascu (@rvlad-patrascu)     May 2017 - Apr 2019
   6.  Peter Lemenkov (@lemenkov)          Jun 2018 - Jun 2018
   7.  Julián Moreno Patiño                Feb 2016 - Feb 2016
   8.  Jarrod Baumann (@jarrodb)           Apr 2015 - Apr 2015
   9.  Norman Brandinger (@NormB)          Aug 2013 - Aug 2013
   10. Daniel-Constantin Mierla (@miconda) Nov 2006 - Mar 2008

   All remaining contributors: Konstantin Bokarius, Edson Gellert
   Schubert, Henning Westerholt (@henningw), Jesus Rodrigues,
   Ancuta Onofrei, Elena-Ramona Modroiu, Andrei Pelinescu-Onciul,
   Jan Janak (@janakj), Jiri Kuthan (@jiriatipteldotorg).

   (1) including any documentation-related commits, excluding
   merge commits

Chapter 4. Documentation

4.1. Contributors

   Last edited by: Bogdan-Andrei Iancu (@bogdan-iancu), Razvan
   Crainea (@razvancrainea), Peter Lemenkov (@lemenkov), Liviu
   Chircu (@liviuchircu), Vlad Patrascu (@rvlad-patrascu), Julián
   Moreno Patiño, Jarrod Baumann (@jarrodb), Norman Brandinger
   (@NormB), Daniel-Constantin Mierla (@miconda), Konstantin
   Bokarius, Edson Gellert Schubert, Jesus Rodrigues, Elena-Ramona
   Modroiu, Jan Janak (@janakj).

   Documentation Copyrights:

   Copyright © 2005-2009 Voice Sistem SRL

   Copyright © 2003 FhG FOKUS
