/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.ProductionLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.BuildingsLayoutManager;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColBorder;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.client.gui.panel.UnitPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.WrapLayout;
import net.sf.freecol.client.gui.tooltip.RebelToolTip;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;

public final class ColonyPanel
extends PortPanel
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ColonyPanel.class.getName());
    public static final int SCROLL_AREA_HEIGHT = 40;
    public static final int SCROLL_SPEED = 40;
    final Map<BuildingType, BufferedImage> cachedDefensiveBuildingImage = new HashMap<BuildingType, BufferedImage>();
    private JButton unloadButton = Utility.localizedButton("unload");
    private JButton fillButton = Utility.localizedButton("load");
    private JButton warehouseButton = new FreeColButton(Messages.message("colonyPanel.warehouse")).withButtonStyle(FreeColButton.ButtonStyle.SIMPLE);
    private JButton buildQueueButton = new FreeColButton(Messages.message("colonyPanel.buildQueue")).withButtonStyle(FreeColButton.ButtonStyle.SIMPLE);
    private JButton colonyUnitsButton = new FreeColButton(Messages.message("colonyPanel.colonyUnits")).withButtonStyle(FreeColButton.ButtonStyle.SIMPLE);
    private JButton setGoodsButton = null;
    private JButton traceWorkButton = null;
    private Colony colony;
    private transient MouseListener releaseListener = null;
    private final JComboBox<Colony> nameBox = new JComboBox();
    private JPanel netProductionPanel = null;
    private JScrollPane buildingsScroll = null;
    private BuildingsPanel buildingsPanel = null;
    private JScrollPane cargoScroll = null;
    private ConstructionPanel constructionPanel = null;
    private JScrollPane inPortScroll = null;
    private JScrollPane outsideColonyScroll = null;
    private OutsideColonyPanel outsideColonyPanel = null;
    private PopulationPanel populationPanel = null;
    private TilesPanel tilesPanel = null;
    private JScrollPane warehouseScroll = null;
    private WarehousePanel warehousePanel = null;
    private JPanel upperRightPanel = null;
    private BufferedImage colonyTitleImage = null;
    private boolean fullscreen = false;
    private final ActionListener unloadCmd = ae -> {
        Unit unit = this.getSelectedUnit();
        if (unit == null || !unit.isCarrier()) {
            return;
        }
        for (Goods goods : unit.getGoodsList()) {
            this.igc().unloadCargo(goods, false);
        }
        for (Unit u : unit.getUnitList()) {
            this.igc().leaveShip(u);
        }
        this.cargoPanel.update();
        this.updateOutsideColonyPanel();
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
    };
    private final ActionListener warehouseCmd = ae -> this.getGUI().showWarehouseDialog(this.getColony(), updated -> {
        if (updated.booleanValue()) {
            this.updateWarehousePanel();
        }
    });
    private final ActionListener buildQueueCmd = ae -> {
        this.getGUI().showBuildQueuePanel(this.getColony());
        this.updateConstructionPanel();
    };
    private final ActionListener fillCmd = ae -> {
        Unit unit = this.getSelectedUnit();
        if (unit == null || !unit.isCarrier()) {
            return;
        }
        Colony colony = this.getColony();
        for (Goods goods : unit.getCompactGoodsList()) {
            GoodsType type = goods.getType();
            int space = unit.getLoadableAmount(type);
            int count = colony.getGoodsCount(type);
            if (space <= 0 || count <= 0) continue;
            int n = Math.min(space, count);
            this.igc().loadCargo(new Goods(goods.getGame(), colony, type, n), unit);
        }
    };
    private final ActionListener colonyUnitsCmd = ae -> this.generateColonyUnitsMenu();
    private final ActionListener setGoodsCmd = ae -> {
        DebugUtils.setColonyGoods(this.getFreeColClient(), this.colony);
        this.updateWarehousePanel();
        this.updateProduction();
    };
    private final ActionListener occupationCmd = ae -> this.colony.setOccupationTrace(!this.colony.getOccupationTrace());
    private final MouseAdapter frameMoveDispatchListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.dispatchTo(e, ColonyPanel.this);
        }

        private void dispatchTo(MouseEvent e, Component target) {
            Component source = (Component)e.getSource();
            MouseEvent targetEvent = SwingUtilities.convertMouseEvent(source, e, target);
            target.dispatchEvent(targetEvent);
        }
    };

    public ColonyPanel(FreeColClient freeColClient, Colony colony) {
        super(freeColClient, (LayoutManager)new MigLayout());
        this.getMigLayout().setLayoutConstraints("fill, wrap 2, insets 0, gap 0 0");
        this.getMigLayout().setColumnConstraints("[fill][474!]");
        this.getMigLayout().setRowConstraints("[]0[]0[][growprio 150,shrinkprio 50][][]");
        Player player = this.getMyPlayer();
        this.editable = colony.getOwner().getId().equals(player.getId());
        if (this.editable && FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            this.setGoodsButton = Utility.localizedButton("colonyPanel.setGoods");
            this.traceWorkButton = Utility.localizedButton("colonyPanel.traceWork");
        }
        ComponentInputMap closeIM = new ComponentInputMap(this.okButton);
        ((InputMap)closeIM).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)closeIM).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, closeIM);
        this.okButton.setText(Messages.message("close"));
        ComponentInputMap unloadIM = new ComponentInputMap(this.unloadButton);
        ((InputMap)unloadIM).put(KeyStroke.getKeyStroke(85, 0, false), "pressed");
        ((InputMap)unloadIM).put(KeyStroke.getKeyStroke(85, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.unloadButton, 2, unloadIM);
        ComponentInputMap fillIM = new ComponentInputMap(this.fillButton);
        ((InputMap)fillIM).put(KeyStroke.getKeyStroke(76, 0, false), "pressed");
        ((InputMap)fillIM).put(KeyStroke.getKeyStroke(76, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.fillButton, 2, fillIM);
        ComponentInputMap warehouseIM = new ComponentInputMap(this.warehouseButton);
        ((InputMap)warehouseIM).put(KeyStroke.getKeyStroke(87, 0, false), "pressed");
        ((InputMap)warehouseIM).put(KeyStroke.getKeyStroke(87, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.warehouseButton, 2, warehouseIM);
        ComponentInputMap buildQueueIM = new ComponentInputMap(this.buildQueueButton);
        ((InputMap)buildQueueIM).put(KeyStroke.getKeyStroke(66, 0, false), "pressed");
        ((InputMap)buildQueueIM).put(KeyStroke.getKeyStroke(66, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.buildQueueButton, 2, buildQueueIM);
        ComponentInputMap colonyUnitsIM = new ComponentInputMap(this.colonyUnitsButton);
        ((InputMap)colonyUnitsIM).put(KeyStroke.getKeyStroke(67, 0, false), "pressed");
        ((InputMap)colonyUnitsIM).put(KeyStroke.getKeyStroke(67, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.colonyUnitsButton, 2, colonyUnitsIM);
        this.defaultTransferHandler = new DefaultTransferHandler(freeColClient, this);
        this.pressListener = new DragListener(freeColClient, this);
        this.releaseListener = new DropListener();
        this.selectedUnitLabel = null;
        StringBuilder sb = new StringBuilder(32);
        String compat = colony.getName();
        if (this.editable) {
            for (Colony c : player.getColonyList()) {
                this.nameBox.addItem(c);
                sb.append(c.getName());
            }
        } else {
            this.nameBox.addItem(colony);
            sb.append(colony.getName());
        }
        Font nameBoxFont = FontLibrary.getScaledFont("header-plain-big", compat);
        this.nameBox.setFont(nameBoxFont);
        this.nameBox.setBorder(BorderFactory.createEmptyBorder());
        this.nameBox.setSelectedItem(colony);
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        this.netProductionPanel = new JPanel(new WrapLayout().withLayoutStyle(WrapLayout.LayoutStyle.PREFER_BOTTOM).withHorizontalGap(WrapLayout.HorizontalGap.AUTO_BOTTOM, 0, this.getImageLibrary().scaleInt(5)));
        this.netProductionPanel.setOpaque(false);
        this.buildingsPanel = new BuildingsPanel();
        this.buildingsPanel.setOpaque(false);
        this.buildingsScroll = new JScrollPane(this.buildingsPanel, 21, 31){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(1, 1);
            }
        };
        this.buildingsScroll.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension preferredSize = ColonyPanel.this.buildingsPanel.getLayout().preferredLayoutSize(ColonyPanel.this.buildingsPanel);
                Dimension viewportSize = ColonyPanel.this.buildingsScroll.getViewport().getSize();
                if (!preferredSize.equals(ColonyPanel.this.buildingsPanel.getSize())) {
                    ColonyPanel.this.buildingsPanel.setSize(preferredSize);
                    ColonyPanel.this.buildingsScroll.validate();
                }
                if (preferredSize.width <= viewportSize.width && preferredSize.height <= viewportSize.height) {
                    ColonyPanel.this.buildingsScroll.setVerticalScrollBarPolicy(21);
                } else {
                    ColonyPanel.this.buildingsScroll.setVerticalScrollBarPolicy(20);
                }
            }
        });
        this.buildingsScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.buildingsScroll.getViewport().setOpaque(false);
        this.buildingsScroll.setBorder(null);
        this.buildingsScroll.getViewport().addMouseListener(this.frameMoveDispatchListener);
        this.buildingsScroll.getViewport().addMouseMotionListener(this.frameMoveDispatchListener);
        this.cargoPanel = new ColonyCargoPanel(freeColClient);
        this.cargoScroll = new JScrollPane(this.cargoPanel, 20, 31);
        this.cargoScroll.setBorder(null);
        this.cargoPanel.addMouseListener(this.frameMoveDispatchListener);
        this.cargoPanel.addMouseMotionListener(this.frameMoveDispatchListener);
        this.constructionPanel = new ConstructionPanel(freeColClient, colony, true);
        this.constructionPanel.setForeground(Color.WHITE);
        this.inPortPanel = new ColonyInPortPanel();
        this.inPortScroll = new JScrollPane(this.inPortPanel, 21, 30);
        this.inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.inPortScroll.setBorder(null);
        this.inPortScroll.setOpaque(false);
        this.inPortScroll.getViewport().setOpaque(false);
        this.inPortPanel.addMouseListener(this.frameMoveDispatchListener);
        this.inPortPanel.addMouseMotionListener(this.frameMoveDispatchListener);
        this.outsideColonyPanel = new OutsideColonyPanel();
        this.outsideColonyScroll = new JScrollPane(this.outsideColonyPanel, 21, 30);
        this.outsideColonyScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.outsideColonyScroll.setBorder(null);
        this.outsideColonyScroll.setOpaque(false);
        this.outsideColonyScroll.getViewport().setOpaque(false);
        this.outsideColonyPanel.addMouseListener(this.frameMoveDispatchListener);
        this.outsideColonyPanel.addMouseMotionListener(this.frameMoveDispatchListener);
        this.populationPanel = new PopulationPanel();
        this.tilesPanel = new TilesPanel();
        this.warehousePanel = new WarehousePanel();
        this.warehouseScroll = new JScrollPane(this.warehousePanel, 21, 30);
        this.warehouseScroll.setBorder(FreeColImageBorder.colonyWarehouseBorder);
        this.warehousePanel.addMouseListener(this.frameMoveDispatchListener);
        this.warehousePanel.addMouseMotionListener(this.frameMoveDispatchListener);
        ComponentInputMap nameIM = new ComponentInputMap(this.nameBox);
        ((InputMap)nameIM).put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        ((InputMap)nameIM).put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        SwingUtilities.replaceUIInputMap(this.nameBox, 2, nameIM);
        if (this.getGUI().getMapViewDimension().height < this.getImageLibrary().scaleInt(850)) {
            this.fullscreen = true;
            this.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.setBorder(FreeColImageBorder.innerColonyPanelBorder);
        }
        this.setColony(colony);
        this.initialize();
        if (!this.fullscreen) {
            Dimension startingSize = this.getFreeColClient().getGUI().getFixedImageLibrary().scale(new Dimension(1280, 700));
            this.getGUI().restoreSavedSize(this, startingSize);
        }
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColonyPanel.this.okButton.doClick();
            }
        });
    }

    @Override
    public void refreshLayout() {
        Colony theColony = this.colony;
        this.closeColonyPanel();
        this.getGUI().showColonyPanel(theColony, null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage sBorder;
        BufferedImage upperRightBackground;
        List defensiveBuildings;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Dimension size = this.getSize();
        BufferedImage colonyDocksBackground = this.getImageLibrary().getColonyDocksBackground();
        if (colonyDocksBackground != null) {
            int docksBottomLeftX = this.inPortScroll.getX();
            int docksBottomLeftY = this.inPortScroll.getY() + this.inPortScroll.getHeight();
            int y = docksBottomLeftY - colonyDocksBackground.getHeight();
            g.drawImage(colonyDocksBackground, docksBottomLeftX, y, null);
            BufferedImage colonyDocksSkyBackground = this.getImageLibrary().getColonyDocksSkyBackground();
            if (colonyDocksSkyBackground != null) {
                while (y > 0) {
                    g.drawImage(colonyDocksSkyBackground, docksBottomLeftX, y -= colonyDocksSkyBackground.getHeight(), null);
                }
            }
        }
        Building docksBuilding = this.colony.getBuildings().stream().filter(b -> b.hasAbility("model.ability.produceInWater")).sorted(Comparator.comparing(FreeColObject::getId)).findFirst().orElse(null);
        BufferedImage docks = this.getImageLibrary().getScaledBuildingImage(docksBuilding);
        if (docks != null) {
            int docksBottomLeftX = this.inPortScroll.getX();
            int docksBottomLeftY = this.inPortScroll.getY() + this.inPortScroll.getHeight();
            int y = docksBottomLeftY - docks.getHeight();
            g.drawImage(docks, docksBottomLeftX, y, null);
        }
        if ((defensiveBuildings = this.colony.getBuildings().stream().filter(b -> b.getType().isDefenceType()).sorted(Comparator.comparing(FreeColObject::getId)).collect(Collectors.toList())).isEmpty()) {
            this.paintOutsideColonyBackground(g2d, null);
        }
        for (Building defensiveBuilding : defensiveBuildings) {
            this.paintOutsideColonyBackground(g2d, defensiveBuilding.getType());
        }
        BufferedImage unavailable = this.getImageLibrary().getScaledCargoHold(false);
        if (unavailable != null) {
            int cargoHoldTopRightX = this.cargoScroll.getX() + this.cargoScroll.getWidth();
            int cargoHoldTopRightY = this.cargoScroll.getY();
            g.drawImage(unavailable, cargoHoldTopRightX, cargoHoldTopRightY, null);
        }
        if ((upperRightBackground = this.getImageLibrary().getColonyUpperRightBackground()) != null) {
            Insets insets = this.getInsets();
            int x = size.width - upperRightBackground.getWidth() - insets.right;
            int y = insets.top;
            g.drawImage(upperRightBackground, x, y, null);
            Font numberFont = FontLibrary.getUnscaledFont(Utility.FONTSPEC_TITLE, "1").deriveFont((float)this.getImageLibrary().scaleInt(32));
            Font origFont = g.getFont();
            g.setFont(numberFont);
            FontMetrics fm = g2d.getFontMetrics();
            String colonySize = "" + this.colony.getUnitCount();
            double centerY = (fm.getAscent() - fm.getDescent() - fm.getLeading()) / 2;
            int colonySizeX = this.getImageLibrary().scaleInt(100);
            int colonySizeY = this.getImageLibrary().scaleInt(40);
            double colonySizeCenterX = -fm.getStringBounds(colonySize, g2d).getWidth() / 2.0;
            g.drawString(colonySize, (int)((double)x + colonySizeCenterX + (double)colonySizeX), (int)((double)y + centerY + (double)colonySizeY));
            int grow = this.colony.getPreferredSizeChange();
            Object bonus = grow > 9 ? ">9" : (grow >= 0 ? "+" + grow : "" + grow);
            int colonyBonusX = this.getImageLibrary().scaleInt(404);
            double colonyBonusCenterX = -fm.getStringBounds((String)bonus, g2d).getWidth() / 2.0;
            g.drawString((String)bonus, (int)((double)x + colonyBonusCenterX + (double)colonyBonusX), (int)((double)y + centerY + (double)colonySizeY));
            numberFont = numberFont.deriveFont((float)this.getImageLibrary().scaleInt(18));
            g.setFont(numberFont);
            fm = g2d.getFontMetrics();
            centerY = (fm.getAscent() - fm.getDescent() - fm.getLeading()) / 2;
            String rebelPercentage = this.colony.getSonsOfLiberty() + "%";
            int rebelPercentageX = this.getImageLibrary().scaleInt(101);
            int rebelPercentageY = this.getImageLibrary().scaleInt(193);
            double rebelPercentageCenterX = -fm.getStringBounds(rebelPercentage, g2d).getWidth() / 2.0;
            g.drawString(rebelPercentage, (int)((double)x + rebelPercentageCenterX + (double)rebelPercentageX), (int)((double)y + centerY + (double)rebelPercentageY));
            String royalistPercentage = 100 - this.colony.getSonsOfLiberty() + "%";
            int royalistPercentageX = this.getImageLibrary().scaleInt(407);
            double royalistPercentageCenterX = -fm.getStringBounds(royalistPercentage, g2d).getWidth() / 2.0;
            g.drawString(royalistPercentage, (int)((double)x + royalistPercentageCenterX + (double)royalistPercentageX), (int)((double)y + centerY + (double)rebelPercentageY));
            g.setFont(origFont);
        }
        BufferedImage nwBorder = this.getImageLibrary().getScaledImage("image.border.wooden.nw");
        BufferedImage wBorder = this.getImageLibrary().getScaledImage("image.border.wooden.w");
        if (nwBorder != null && wBorder != null) {
            int x = this.okButton.getX() + this.okButton.getWidth();
            int y = this.okButton.getY();
            g.drawImage(nwBorder, x, y, null);
            y += nwBorder.getHeight();
            while (y < size.height) {
                g.drawImage(wBorder, x, y, null);
                y += wBorder.getHeight();
            }
        }
        if ((sBorder = this.getImageLibrary().getScaledImage("image.border.wooden.s")) != null) {
            int y = this.warehouseScroll.getY() + this.warehouseScroll.getHeight();
            for (int x = 0; x < size.width; x += sBorder.getWidth()) {
                g.drawImage(sBorder, x, y, null);
            }
        }
        if (nwBorder != null && wBorder != null) {
            int x = this.warehouseScroll.getX() - nwBorder.getWidth();
            int y = this.warehouseScroll.getY();
            g.drawImage(nwBorder, x, y, null);
            y += nwBorder.getHeight();
            while (y < size.height) {
                g.drawImage(wBorder, x, y, null);
                y += wBorder.getHeight();
            }
        }
        if (this.fullscreen) {
            if (this.colonyTitleImage == null) {
                this.colonyTitleImage = this.getImageLibrary().createColonyTitleImage((Graphics2D)g, this.colony.getName(), this.getColony().getOwner(), false);
            }
            int x = this.upperRightPanel.getX() + (this.upperRightPanel.getWidth() - this.colonyTitleImage.getWidth()) / 2;
            int y = this.inPortScroll.getY() - this.colonyTitleImage.getHeight();
            g.drawImage(this.colonyTitleImage, x, y, null);
        }
    }

    private void paintOutsideColonyBackground(Graphics2D g2d, BuildingType buildingType) {
        Dimension outsideColonySize = this.outsideColonyScroll.getSize();
        BufferedImage outsideColonyImage = this.cachedDefensiveBuildingImage.get(buildingType);
        if (outsideColonyImage == null || outsideColonyImage.getWidth() != outsideColonySize.width || outsideColonyImage.getHeight() != outsideColonySize.height) {
            outsideColonyImage = ImageLibrary.getUncachedOutsideColonyBackground(buildingType, this.getColony().getOwner().getNationResourceKey(), outsideColonySize);
            this.cachedDefensiveBuildingImage.put(buildingType, outsideColonyImage);
        }
        if (outsideColonyImage == null) {
            return;
        }
        int x = this.outsideColonyScroll.getX();
        int y = this.outsideColonyScroll.getY();
        g2d.drawImage((Image)outsideColonyImage, x, y, null);
    }

    @Override
    public Border getFrameBorder() {
        if (this.fullscreen) {
            return BorderFactory.createEmptyBorder();
        }
        final FreeColImageBorder normalBorder = FreeColImageBorder.outerColonyPanelBorder;
        FreeColBorder titleBorder = new FreeColBorder(){

            @Override
            public List<Rectangle> getOpenSpace(Component c) {
                return normalBorder.getOpenSpace(c);
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (ColonyPanel.this.colonyTitleImage == null) {
                    ColonyPanel.this.colonyTitleImage = ColonyPanel.this.getImageLibrary().createColonyTitleImage((Graphics2D)g, ColonyPanel.this.colony.getName(), ColonyPanel.this.getColony().getOwner(), true);
                }
                int borderOverlapY = ColonyPanel.this.getImageLibrary().scaleInt(6);
                int imageY = normalBorder.getTopLeftCornerInsetY() - ColonyPanel.this.colonyTitleImage.getHeight() + borderOverlapY;
                int paddingX = ColonyPanel.this.getImageLibrary().scaleInt(23);
                g.drawImage(ColonyPanel.this.colonyTitleImage, paddingX, imageY, null);
                normalBorder.paintBorder(c, g, x, y, width, height);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return normalBorder.getBorderInsets(c);
            }

            @Override
            public boolean isBorderOpaque() {
                return normalBorder.isBorderOpaque();
            }
        };
        return titleBorder;
    }

    @Override
    public boolean isFullscreen() {
        return this.fullscreen;
    }

    private synchronized void setColony(Colony colony) {
        this.colony = colony;
    }

    private Dimension getTilesPanelGuiScaledDimension() {
        int tilesPanelWidth = 3 * this.getImageLibrary().getTileSize().width;
        int tilesPanelHeight = 3 * this.getImageLibrary().getTileSize().height;
        Dimension size = this.getImageLibrary().getTileSize();
        int extraHeight = this.tilesPanelTopOffset(size);
        return new Dimension(tilesPanelWidth, tilesPanelHeight + extraHeight);
    }

    private void initialize() {
        this.cleanup();
        this.addPropertyChangeListeners();
        this.addMouseListeners();
        this.setTransferHandlers(this.isEditable());
        this.unloadButton.addActionListener(this.unloadCmd);
        this.fillButton.addActionListener(this.fillCmd);
        this.warehouseButton.addActionListener(this.warehouseCmd);
        this.buildQueueButton.addActionListener(this.buildQueueCmd);
        this.colonyUnitsButton.addActionListener(this.colonyUnitsCmd);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.addActionListener(this.setGoodsCmd);
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.addActionListener(this.occupationCmd);
        }
        this.unloadButton.setEnabled(this.isEditable());
        this.fillButton.setEnabled(this.isEditable());
        this.warehouseButton.setEnabled(this.isEditable());
        this.buildQueueButton.setEnabled(this.isEditable());
        this.colonyUnitsButton.setEnabled(this.isEditable());
        if (this.setGoodsButton != null) {
            this.setGoodsButton.setEnabled(this.isEditable());
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.setEnabled(this.isEditable());
        }
        GUI gui = this.getGUI();
        this.nameBox.setEnabled(this.isEditable());
        this.nameBox.addActionListener(ae -> {
            Colony newColony = (Colony)this.nameBox.getSelectedItem();
            this.closeColonyPanel();
            gui.showColonyPanel(newColony, null);
        });
        this.updateNetProductionPanel();
        this.buildingsPanel.initialize();
        this.cargoPanel.initialize();
        this.constructionPanel.initialize();
        this.inPortPanel.initialize();
        this.outsideColonyPanel.initialize();
        this.populationPanel.initialize();
        this.tilesPanel.initialize();
        this.warehousePanel.initialize();
        Dimension tilesScrollDimension = this.getTilesPanelGuiScaledDimension();
        this.add((Component)this.buildingsScroll, "span 1 4, grow");
        this.upperRightPanel = new JPanel(new MigLayout("wrap 1, ins 7 7 7 7, gap 0 0", "[center]")){
            {
                this.setToolTipText(" ");
            }

            @Override
            public JToolTip createToolTip() {
                RebelToolTip toolTip = new RebelToolTip(ColonyPanel.this.getFreeColClient(), ColonyPanel.this.getColony());
                return toolTip;
            }
        };
        this.upperRightPanel.setOpaque(false);
        this.upperRightPanel.add((Component)this.tilesPanel, "width " + tilesScrollDimension.width + "px!, height " + tilesScrollDimension.height + "px!, top, center");
        FreeColImageBorder border = FreeColImageBorder.innerColonyPanelBorder;
        Insets borderInsets = border.getBorderInsets(this);
        this.upperRightPanel.add((Component)this.netProductionPanel, "grow, wmax 384, height 68!");
        this.upperRightPanel.add((Component)this.constructionPanel, "grow, top, wmax 367, height 90");
        this.add((Component)this.upperRightPanel, "span 1 3, growy, gapbefore 53, width 400!, wmax 400");
        this.add((Component)this.inPortScroll, "span, grow, height 96!, gaptop push");
        this.add((Component)this.outsideColonyScroll, "grow, height 96!");
        this.add((Component)this.cargoScroll, "grow, height 100!");
        this.add((Component)this.warehouseScroll, "span, split, height 48!, growx");
        this.add((Component)this.wrapWithBorder(this.warehouseButton), "height 48!, gap 0 0 0 0");
        if (this.setGoodsButton != null) {
            this.add((Component)this.wrapWithBorder(this.setGoodsButton), "height 48!, gap 0 0 0 0");
        }
        if (this.traceWorkButton != null) {
            this.add((Component)this.wrapWithBorder(this.traceWorkButton), "height 48!, gap 0 0 0 0");
        }
        this.add((Component)this.unloadButton, "wmax 0, height 0, gap 0 0 0 0");
        this.add((Component)this.fillButton, "wmax 0, height 0, gap 0 0 0 0");
        this.add((Component)this.okButton, "gapbefore push, height 48!");
        this.update();
    }

    private JPanel wrapWithBorder(JComponent c) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(FreeColImageBorder.woodenPanelBorder);
        panel.add(c);
        return panel;
    }

    private void cleanup() {
        this.unloadButton.removeActionListener(this.unloadCmd);
        this.fillButton.removeActionListener(this.fillCmd);
        this.warehouseButton.removeActionListener(this.warehouseCmd);
        this.buildQueueButton.removeActionListener(this.buildQueueCmd);
        this.colonyUnitsButton.removeActionListener(this.colonyUnitsCmd);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.removeActionListener(this.setGoodsCmd);
        }
        if (this.traceWorkButton != null) {
            this.traceWorkButton.removeActionListener(this.occupationCmd);
        }
        this.removePropertyChangeListeners();
        if (this.getSelectedUnit() != null) {
            this.getSelectedUnit().removePropertyChangeListener(this);
        }
        this.removeMouseListeners();
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
        this.setTransferHandlers(false);
        this.buildingsPanel.cleanup();
        this.cargoPanel.cleanup();
        this.constructionPanel.cleanup();
        this.inPortPanel.cleanup();
        this.outsideColonyPanel.cleanup();
        this.populationPanel.cleanup();
        this.tilesPanel.cleanup();
        this.warehousePanel.cleanup();
        this.removeAll();
    }

    private void addMouseListeners() {
        if (this.isEditable()) {
            this.cargoPanel.addMouseListener(this.releaseListener);
            this.inPortPanel.addMouseListener(this.releaseListener);
            this.outsideColonyPanel.addMouseListener(this.releaseListener);
            this.warehousePanel.addMouseListener(this.releaseListener);
        }
    }

    private void removeMouseListeners() {
        this.cargoPanel.removeMouseListener(this.releaseListener);
        this.inPortPanel.removeMouseListener(this.releaseListener);
        this.outsideColonyPanel.removeMouseListener(this.releaseListener);
        this.warehousePanel.removeMouseListener(this.releaseListener);
    }

    private void setTransferHandlers(boolean enable) {
        DefaultTransferHandler dth = enable ? this.defaultTransferHandler : null;
        this.cargoPanel.setTransferHandler(dth);
        this.inPortPanel.setTransferHandler(dth);
        this.outsideColonyPanel.setTransferHandler(dth);
        this.warehousePanel.setTransferHandler(dth);
    }

    private void addPropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.addPropertyChangeListener(this);
            colony.getGoodsContainer().addPropertyChangeListener(this);
            colony.getTile().addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.removePropertyChangeListener(this);
            colony.getGoodsContainer().removePropertyChangeListener(this);
            colony.getTile().removePropertyChangeListener(this);
        }
    }

    private void updateProduction() {
        Colony colony = this.getColony();
        if (colony == null) {
            return;
        }
        for (WorkLocation wl : colony.getCurrentWorkLocationsList()) {
            boolean change = false;
            boolean check = wl.getProductionType() == null;
            for (Unit unit : CollectionUtils.transform(wl.getUnits(), u -> check || !wl.produces(u.getWorkType()))) {
                GoodsType workType = wl.getWorkFor(unit);
                if (workType == null || workType == unit.getWorkType()) continue;
                change |= this.igc().changeWorkType(unit, workType);
            }
            if (!change) continue;
            wl.updateProductionType();
        }
        this.updateTilesPanel();
        this.updateBuildingsPanel();
        this.updateNetProductionPanel();
        this.updateConstructionPanel();
    }

    public void update() {
        this.buildingsPanel.update();
        this.constructionPanel.update();
        this.inPortPanel.update();
        this.updateNetProductionPanel();
        this.outsideColonyPanel.update();
        this.populationPanel.update();
        this.tilesPanel.update();
        this.warehousePanel.update();
    }

    private void updateCarrierButtons() {
        Unit unit;
        Colony colony = this.getColony();
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
        if (this.selectedUnitLabel != null && this.isEditable() && (unit = this.selectedUnitLabel.getUnit()) != null && unit.isCarrier() && unit.hasCargo()) {
            this.unloadButton.setEnabled(true);
            for (Goods goods : unit.getCompactGoodsList()) {
                if (colony.getGoodsCount(goods.getType()) <= 0) continue;
                this.fillButton.setEnabled(true);
                break;
            }
        }
    }

    private void generateColonyUnitsMenu() {
        int lastIndex;
        FreeColClient freeColClient = this.getFreeColClient();
        ImageLibrary lib = this.getImageLibrary();
        Colony colony = this.getColony();
        JPopupMenu colonyUnitsMenu = new JPopupMenu(Messages.message("colonyPanel.colonyUnits"));
        ImageIcon unitIcon = null;
        QuickActionMenu unitMenu = new QuickActionMenu(freeColClient, this);
        Tile colonyTile = colony.getTile();
        int unitNumber = 0;
        JMenuItem subMenu = null;
        for (Unit unit : colony.getUnitList()) {
            WorkLocation wl = unit.getWorkLocation();
            GoodsType goodsType = unit.getWorkType();
            Unit student = unit.getStudent();
            unitIcon = new ImageIcon(lib.getSmallerUnitImage(unit));
            StringBuilder sb = new StringBuilder(64);
            String prodLabel = Messages.message("colonyPanel.producing");
            if (student != null) {
                sb.append(unit.getDescription()).append(' ').append(prodLabel).append(' ').append(Messages.getName(unit.getType().getSkillTaught())).append(' ').append(unit.getTurnsOfTraining()).append('/').append(unit.getNeededTurnsOfTraining());
            } else if (wl != null && goodsType != null) {
                int producing = wl.getProductionOf(unit, goodsType);
                sb.append(unit.getDescription()).append(' ').append(prodLabel).append(' ').append(producing).append(' ').append(Messages.message(StringTemplate.template(goodsType).addAmount("%amount%", producing)));
            } else {
                sb.append(unit.getDescription()).append(' ').append(prodLabel).append(' ').append(Messages.message("nothing"));
            }
            String menuTitle = sb.toString();
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(ae -> {
                unitMenu.addMenuItems(new UnitLabel(freeColClient, unit));
                this.getGUI().showPopupMenu(unitMenu, 0, 0);
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        for (Unit unit : colonyTile.getUnitList()) {
            String menuTitle;
            if (unit.isCarrier()) {
                unitIcon = new ImageIcon(lib.getSmallerUnitImage(unit));
                menuTitle = unit.getDescription() + " " + Messages.message("colonyPanel.inPort");
                subMenu = new JMenuItem(menuTitle, unitIcon);
                subMenu.addActionListener(ae -> {
                    unitMenu.addMenuItems(new UnitLabel(freeColClient, unit));
                    this.getGUI().showPopupMenu(unitMenu, 0, 0);
                });
                ++unitNumber;
                colonyUnitsMenu.add(subMenu);
                for (Unit innerUnit : unit.getUnitList()) {
                    unitIcon = new ImageIcon(lib.getSmallerUnitImage(innerUnit));
                    menuTitle = innerUnit.getDescription() + " " + Messages.message("cargoOnCarrier") + " " + unit.getDescription();
                    subMenu = new JMenuItem(menuTitle, unitIcon);
                    subMenu.addActionListener(ae -> {
                        unitMenu.addMenuItems(new UnitLabel(freeColClient, innerUnit));
                        this.getGUI().showPopupMenu(unitMenu, 0, 0);
                    });
                    ++unitNumber;
                    colonyUnitsMenu.add(subMenu);
                }
                continue;
            }
            if (unit.isOnCarrier()) continue;
            unitIcon = new ImageIcon(lib.getSmallerUnitImage(unit));
            menuTitle = unit.getDescription() + " " + Messages.message("colonyPanel.outsideColony");
            subMenu = new JMenuItem(menuTitle, unitIcon);
            subMenu.addActionListener(ae -> {
                unitMenu.addMenuItems(new UnitLabel(freeColClient, unit));
                this.getGUI().showPopupMenu(unitMenu, 0, 0);
            });
            ++unitNumber;
            colonyUnitsMenu.add(subMenu);
        }
        colonyUnitsMenu.addSeparator();
        int elements = colonyUnitsMenu.getSubElements().length;
        if (elements > 0 && colonyUnitsMenu.getComponent(lastIndex = colonyUnitsMenu.getComponentCount() - 1) instanceof JPopupMenu.Separator) {
            colonyUnitsMenu.remove(lastIndex);
        }
        this.getGUI().showPopupMenu(colonyUnitsMenu, 0, 0);
    }

    private boolean tryWork(Unit unit, WorkLocation wl) {
        GoodsType workType = wl.getWorkFor(unit);
        this.igc().work(unit, wl);
        if (unit.getLocation() != wl) {
            return false;
        }
        if (workType != null && workType != unit.getWorkType()) {
            this.igc().changeWorkType(unit, workType);
        }
        return true;
    }

    public final synchronized Colony getColony() {
        return this.colony;
    }

    public final TilesPanel getTilesPanel() {
        return this.tilesPanel;
    }

    public final WarehousePanel getWarehousePanel() {
        return this.warehousePanel;
    }

    @Override
    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            this.inPortPanel.removePropertyChangeListeners();
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
                this.selectedUnitLabel.getUnit().removePropertyChangeListener(this);
            }
            super.setSelectedUnitLabel(unitLabel);
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
                unitLabel.getUnit().addPropertyChangeListener(this);
            }
            this.inPortPanel.addPropertyChangeListeners();
        }
        this.updateCarrierButtons();
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    @Override
    public boolean setSelectedUnit(Unit unit) {
        return unit.isCarrier() ? this.inPortPanel.setSelectedUnit(unit) : super.setSelectedUnit(unit);
    }

    private void updateBuildingsPanel() {
        this.colony.invalidateCache();
        this.buildingsPanel.update();
    }

    private void updateConstructionPanel() {
        this.constructionPanel.update();
    }

    private void updateInPortPanel() {
        this.inPortPanel.update();
    }

    private void updateNetProductionPanel() {
        FreeColClient freeColClient = this.getFreeColClient();
        Colony colony = this.getColony();
        Specification spec = colony.getSpecification();
        colony.invalidateCache();
        this.netProductionPanel.removeAll();
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            int amount = colony.getAdjustedNetProductionOf(goodsType);
            if (amount == 0) continue;
            AbstractGoods ag = new AbstractGoods(goodsType, amount);
            this.netProductionPanel.add(new ProductionLabel(freeColClient, ag));
        }
        this.netProductionPanel.revalidate();
        this.netProductionPanel.repaint();
    }

    private void updateOutsideColonyPanel() {
        this.outsideColonyPanel.update();
    }

    private void updatePopulationPanel() {
        this.populationPanel.update();
    }

    private void updateTilesPanel() {
        this.tilesPanel.update();
    }

    private void updateWarehousePanel() {
        this.warehousePanel.update();
    }

    public void closeColonyPanel() {
        Colony colony = this.getColony();
        Player player = this.getMyPlayer();
        boolean abandon = false;
        if (player.owns(colony)) {
            if (colony.getUnitCount() == 0) {
                String key;
                String string = key = player.isRebel() && player.getNumberOfPorts() == 1 && colony.isConnectedPort() ? "abandonColony.lastPort.text" : "abandonColony.text";
                if (!this.getGUI().confirm(null, StringTemplate.key(key), colony, "abandonColony.yes", "abandonColony.no")) {
                    return;
                }
                abandon = true;
            } else {
                int required;
                BuildableType buildable = colony.getCurrentlyBuilding();
                if (buildable != null && (required = buildable.getRequiredPopulation()) > colony.getUnitCount() && !this.getGUI().confirm(null, (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("colonyPanel.reducePopulation").addName("%colony%", colony.getName())).addAmount("%number%", required)).addNamed("%buildable%", buildable), colony, "ok", "cancel")) {
                    return;
                }
            }
        }
        this.cleanup();
        this.getGUI().removeComponent(this);
        this.igc().closeColony(colony, abandon);
    }

    @Override
    public List<Unit> getUnitList() {
        return CollectionUtils.sort(this.colony.getTile().getUnits());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("OK".equals(ae.getActionCommand())) {
            this.closeColonyPanel();
        } else {
            super.actionPerformed(ae);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Colony colony = this.getColony();
        if (!this.isShowing() || colony == null) {
            return;
        }
        String property = event.getPropertyName();
        logger.finest(colony.getName() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
        if (property == null) {
            logger.warning("Null property change");
        } else if ("CARGO_CHANGE".equals(property)) {
            this.cargoPanel.update();
            this.updateInPortPanel();
        } else if (Colony.ColonyChangeEvent.POPULATION_CHANGE.toString().equals(property)) {
            this.updatePopulationPanel();
            this.updateNetProductionPanel();
        } else if (Colony.ColonyChangeEvent.BONUS_CHANGE.toString().equals(property)) {
            ModelMessage msg;
            if (colony.getUnitCount() > 0 && (msg = colony.checkForGovMgtChangeMessage()) != null) {
                this.getGUI().showInformationPanel((FreeColObject)colony, msg);
            }
            this.updatePopulationPanel();
        } else if (Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString().equals(property)) {
            this.updateProduction();
        } else if (Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString().equals(property)) {
            FreeColGameObject object = (FreeColGameObject)event.getSource();
            UnitType oldType = (UnitType)event.getOldValue();
            UnitType newType = (UnitType)event.getNewValue();
            this.getGUI().showInformationPanel((FreeColObject)object, (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("colonyPanel.unitChange").addName("%colony%", colony.getName())).addNamed("%oldType%", oldType)).addNamed("%newType%", newType));
            this.updateTilesPanel();
            this.updateBuildingsPanel();
            this.updateProduction();
        } else if (property.startsWith("model.goods.")) {
            this.updateWarehousePanel();
            this.updateProduction();
        } else if ("TILE_UNIT_CHANGE".equals(property)) {
            this.updateOutsideColonyPanel();
            this.updateInPortPanel();
            this.updatePopulationPanel();
            this.updateWarehousePanel();
        } else if ("MOVE_CHANGE".equals(property)) {
            this.updateOutsideColonyPanel();
        } else {
            logger.warning("Unknown property change event: " + event.getPropertyName());
        }
    }

    @Override
    public void removeNotify() {
        if (this.colony == null) {
            return;
        }
        this.colony.setOccupationTrace(false);
        this.colony = null;
        super.removeNotify();
        this.unloadButton = null;
        this.fillButton = null;
        this.warehouseButton = null;
        this.buildQueueButton = null;
        this.colonyUnitsButton = null;
        this.setGoodsButton = null;
        this.traceWorkButton = null;
        this.netProductionPanel = null;
        this.buildingsPanel = null;
        this.buildingsScroll = null;
        this.cargoScroll = null;
        this.constructionPanel = null;
        this.inPortScroll = null;
        this.outsideColonyPanel = null;
        this.outsideColonyScroll = null;
        this.populationPanel = null;
        this.tilesPanel = null;
        this.warehousePanel = null;
        this.warehouseScroll = null;
        this.releaseListener = null;
    }

    private int tilesPanelTopOffset(Dimension tileSize) {
        int topOffset = tileSize.height / 4;
        return topOffset;
    }

    public final class TilesPanel
    extends JPanel {
        private final Tile[][] tiles = new Tile[3][3];
        private FreeColPanel cachedPanel = null;
        private WorkLocation bestLocation = null;

        public TilesPanel() {
            this.setBackground(Color.BLACK);
            this.setBorder(null);
            this.setLayout(null);
            this.setOpaque(false);
        }

        public void initialize() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.cleanup();
            Tile tile = colony.getTile();
            this.tiles[0][0] = tile.getNeighbourOrNull(Direction.N);
            this.tiles[0][1] = tile.getNeighbourOrNull(Direction.NE);
            this.tiles[0][2] = tile.getNeighbourOrNull(Direction.E);
            this.tiles[1][0] = tile.getNeighbourOrNull(Direction.NW);
            this.tiles[1][1] = tile;
            this.tiles[1][2] = tile.getNeighbourOrNull(Direction.SE);
            this.tiles[2][0] = tile.getNeighbourOrNull(Direction.W);
            this.tiles[2][1] = tile.getNeighbourOrNull(Direction.SW);
            this.tiles[2][2] = tile.getNeighbourOrNull(Direction.S);
            int layer = 2;
            for (int x = 0; x < this.tiles.length; ++x) {
                for (int y = 0; y < this.tiles[x].length; ++y) {
                    if (this.tiles[x][y] == null) {
                        logger.warning("Null tile for " + ColonyPanel.this.getColony() + " at " + x + "," + y);
                        continue;
                    }
                    ColonyTile colonyTile = colony.getColonyTile(this.tiles[x][y]);
                    if (colonyTile == null) {
                        logger.warning("Null colony tile for " + ColonyPanel.this.getColony() + " on " + this.tiles[x][y] + " at " + x + "," + y);
                        CollectionUtils.dump("TILES", colony.getColonyTiles());
                        continue;
                    }
                    ASingleTilePanel aSTP = new ASingleTilePanel(colonyTile, x, y);
                    aSTP.initialize();
                    this.add((Component)aSTP, (Object)layer++);
                }
            }
            this.update();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).cleanup();
            }
            this.removeAll();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).update();
            }
            this.repaint();
        }

        public void showPoorProduction(WorkLocation best, StringTemplate template) {
            if (this.bestLocation == best) {
                return;
            }
            if (this.cachedPanel != null) {
                ColonyPanel.this.getGUI().removeComponent(this.cachedPanel);
            }
            this.cachedPanel = ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)best, template);
            this.bestLocation = best;
        }

        @Override
        public void paintComponent(Graphics g) {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                Dimension size = ColonyPanel.this.getImageLibrary().getTileSize();
                int topOffset = ColonyPanel.this.tilesPanelTopOffset(size);
                g.translate(0, topOffset);
                ColonyPanel.this.getGUI().displayColonyTiles((Graphics2D)g, this.tiles, colony);
                g.translate(0, -topOffset);
            }
        }

        public final class ASingleTilePanel
        extends JPanel
        implements DropTarget,
        PropertyChangeListener {
            private final ColonyTile colonyTile;

            public ASingleTilePanel(ColonyTile colonyTile, int x, int y) {
                this.colonyTile = colonyTile;
                this.setLayout(new FlowLayout(1, 0, 0));
                this.setOpaque(false);
                Dimension size = ColonyPanel.this.getImageLibrary().getTileSize();
                int topOffset = ColonyPanel.this.tilesPanelTopOffset(size);
                this.setSize(size);
                this.setLocation((2 - x + y) * size.width / 2, (x + y) * size.height / 2 + topOffset);
            }

            public void initialize() {
                if (ColonyPanel.this.isEditable()) {
                    this.cleanup();
                    this.addMouseListener(ColonyPanel.this.pressListener);
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    this.addPropertyChangeListeners();
                }
            }

            public void cleanup() {
                this.removeMouseListener(ColonyPanel.this.pressListener);
                this.removeMouseListener(ColonyPanel.this.releaseListener);
                this.setTransferHandler(null);
                this.removePropertyChangeListeners();
                this.removeAll();
            }

            private void addPropertyChangeListeners() {
                if (this.colonyTile != null) {
                    this.colonyTile.addPropertyChangeListener(this);
                }
            }

            private void removePropertyChangeListeners() {
                if (this.colonyTile != null) {
                    this.colonyTile.removePropertyChangeListener(this);
                }
            }

            public void update() {
                this.removeAll();
                if (this.colonyTile == null) {
                    logger.warning("Update of " + ColonyPanel.this.getColony() + " null colony tile.");
                    return;
                }
                FreeColClient fcc = ColonyPanel.this.getFreeColClient();
                UnitLabel label = null;
                for (Unit unit : this.colonyTile.getUnitList()) {
                    label = new UnitLabel(fcc, unit, false, false);
                    if (ColonyPanel.this.isEditable()) {
                        label.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        label.addMouseListener(ColonyPanel.this.pressListener);
                    }
                    super.add(label);
                }
                this.updateDescriptionLabel(label);
                if (this.colonyTile.isColonyCenterTile()) {
                    this.setLayout(new GridLayout(2, 1));
                    ProductionInfo info = ColonyPanel.this.colony.getProductionInfo(this.colonyTile);
                    if (info != null) {
                        for (AbstractGoods ag : info.getProduction()) {
                            ProductionLabel productionLabel = new ProductionLabel(fcc, ag);
                            productionLabel.addMouseListener(ColonyPanel.this.pressListener);
                            this.add(productionLabel);
                        }
                    }
                }
            }

            public ColonyTile getColonyTile() {
                return this.colonyTile;
            }

            private void updateDescriptionLabel(UnitLabel unitLabel) {
                String tileMsg = Messages.message(this.colonyTile.getLabel());
                if (unitLabel == null) {
                    this.setToolTipText(tileMsg);
                } else {
                    Unit unit = unitLabel.getUnit();
                    unitLabel.setDescriptionLabel(tileMsg + " [" + unit.getDescription(Unit.UnitLabelType.NATIONAL) + "]");
                }
            }

            private boolean tryWork(Unit unit) {
                WorkLocation best;
                UnitLocation.NoAddReason reason;
                Colony colony = ColonyPanel.this.getColony();
                Tile tile = this.colonyTile.getWorkTile();
                Player player = unit.getOwner();
                if (tile.getOwningSettlement() != colony) {
                    Player.NoClaimReason claim = player.canClaimForSettlementReason(tile);
                    switch (claim) {
                        case NONE: 
                        case NATIVES: {
                            if (ColonyPanel.this.igc().claimTile(tile, colony) && tile.getOwningSettlement() == colony) {
                                logger.info("Colony " + colony.getName() + " claims tile " + tile + " with unit " + unit.getId());
                                break;
                            }
                            logger.warning("Colony " + colony.getName() + " did not claim " + tile + " with unit " + unit.getId());
                            return false;
                        }
                        default: {
                            ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)tile, claim.getDescriptionKey());
                            return false;
                        }
                    }
                    if (tile.getOwningSettlement() != colony) {
                        throw new RuntimeException("Claim failed: " + claim);
                    }
                }
                if ((reason = this.colonyTile.getNoAddReason(unit)) != UnitLocation.NoAddReason.NONE) {
                    ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)this.colonyTile, StringTemplate.template(reason.getDescriptionKey()));
                    return false;
                }
                if (!ColonyPanel.this.tryWork(unit, this.colonyTile)) {
                    return false;
                }
                GoodsType workType = unit.getWorkType();
                if (workType != null && ColonyPanel.this.getClientOptions().getBoolean("model.option.guiShowNotBestTile") && (best = colony.getWorkLocationFor(unit, workType)) != null && this.colonyTile != best && this.colonyTile.getPotentialProduction(workType, unit.getType()) < best.getPotentialProduction(workType, unit.getType())) {
                    Object template = ((StringTemplate)((StringTemplate)StringTemplate.template("colonyPanel.notBestTile").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addNamed("%goods%", workType)).addStringTemplate("%tile%", best.getLabel());
                    TilesPanel.this.showPoorProduction(best, (StringTemplate)template);
                }
                return true;
            }

            @Override
            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            @Override
            public Component add(Component comp, boolean editState) {
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        UnitLabel label = (UnitLabel)comp;
                        if (!this.tryWork(label.getUnit())) {
                            return null;
                        }
                        label.setSmall(false);
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleTilePanel.");
                        return null;
                    }
                }
                this.update();
                return comp;
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getPropertyName();
                logger.finest(this.colonyTile.getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
                ColonyPanel.this.updateProduction();
            }

            @Override
            public boolean contains(int px, int py) {
                int dy;
                int w = this.getWidth();
                int h = this.getHeight();
                int dx = Math.abs(w / 2 - px);
                return dx + w * (dy = Math.abs(h / 2 - py)) / h <= w / 2;
            }
        }
    }

    public final class BuildingsPanel
    extends MigPanel {
        private final MouseAdapter buildQueueListener;

        public BuildingsPanel() {
            super("BuildingsPanelUI", new BuildingsLayoutManager());
            this.buildQueueListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColonyPanel.this.getGUI().showBuildQueuePanel(ColonyPanel.this.getColony());
                }
            };
        }

        public void initialize() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.cleanup();
            List allBuildableTypes = ColonyPanel.this.getSpecification().getBuildingTypeList().stream().filter(bt -> bt.getUpgradesFrom() == null).collect(Collectors.toList());
            Random random = new Random(13 * ColonyPanel.this.getColony().getTile().getX() + 23 * ColonyPanel.this.getColony().getTile().getY());
            Collections.shuffle(allBuildableTypes, random);
            Map<BuildingType, List<Building>> constructedBuildings = colony.getBuildings().stream().collect(Collectors.groupingBy(g -> g.getType().getFirstLevel()));
            for (BuildingType bt2 : allBuildableTypes) {
                if (bt2.isDefenceType() || bt2.hasAbility("model.ability.produceInWater")) continue;
                List<Building> btBuildings = constructedBuildings.get(bt2);
                if (btBuildings == null) {
                    EmptyBuildingSite emptyPlot = new EmptyBuildingSite();
                    Dimension size = ColonyPanel.this.getImageLibrary().determineMaxSizeUsingSizeFromAllLevels(bt2, colony.getOwner());
                    emptyPlot.setMinimumSize(size);
                    emptyPlot.setPreferredSize(size);
                    emptyPlot.setSize(size);
                    this.add(emptyPlot);
                    continue;
                }
                if (btBuildings.size() != 1) {
                    throw new IllegalStateException("Expected at most one building of each type.");
                }
                ASingleBuildingPanel aSBP = new ASingleBuildingPanel(btBuildings.get(0));
                aSBP.initialize();
                this.add(aSBP);
            }
            this.update();
        }

        public void cleanup() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).cleanup();
            }
            this.removeAll();
        }

        public void update() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).update();
            }
            this.repaint();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }

        public final class EmptyBuildingSite
        extends JPanel {
            EmptyBuildingSite() {
                this.setOpaque(false);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                ImageLibrary lib = ColonyPanel.this.getImageLibrary();
                BufferedImage image = lib.getScaledBuildingEmptyLandImage();
                Dimension size = this.getSize();
                g.drawImage(image, (size.width - image.getWidth()) / 2, size.height - image.getHeight(), this);
            }
        }

        public final class ASingleBuildingPanel
        extends BuildingPanel
        implements DropTarget {
            public ASingleBuildingPanel(Building building) {
                super(ColonyPanel.this.getFreeColClient(), building);
                this.setOpaque(false);
            }

            @Override
            public void initialize() {
                if (ColonyPanel.this.isEditable()) {
                    super.initialize();
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                    if (this.getBuilding().hasAbility("model.ability.build")) {
                        this.addMouseListener(BuildingsPanel.this.buildQueueListener);
                    } else {
                        this.addMouseListener(ColonyPanel.this.frameMoveDispatchListener);
                        this.addMouseMotionListener(ColonyPanel.this.frameMoveDispatchListener);
                    }
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                }
            }

            @Override
            protected void cleanup() {
                super.cleanup();
                this.removeMouseListener(ColonyPanel.this.releaseListener);
                this.removeMouseListener(BuildingsPanel.this.buildQueueListener);
                this.removeMouseListener(ColonyPanel.this.frameMoveDispatchListener);
                this.removeMouseMotionListener(ColonyPanel.this.frameMoveDispatchListener);
                this.setTransferHandler(null);
                this.removeAll();
            }

            @Override
            public void update() {
                super.update();
                if (ColonyPanel.this.isEditable()) {
                    for (UnitLabel unitLabel : this.getUnitLabels()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                }
            }

            private boolean tryWork(Unit unit) {
                Building building = this.getBuilding();
                UnitLocation.NoAddReason reason = building.getNoAddReason(unit);
                if (reason != UnitLocation.NoAddReason.NONE) {
                    ColonyPanel.this.getGUI().showInformationPanel((FreeColObject)building, reason.getDescriptionKey());
                    return false;
                }
                return ColonyPanel.this.tryWork(unit, building);
            }

            @Override
            public boolean accepts(Goods goods) {
                return false;
            }

            @Override
            public boolean accepts(GoodsType goodsType) {
                return false;
            }

            @Override
            public boolean accepts(Unit unit) {
                return unit.isPerson();
            }

            @Override
            public Component add(Component comp, boolean editState) {
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        if (!this.tryWork(((UnitLabel)comp).getUnit())) {
                            return null;
                        }
                    } else {
                        logger.warning("An invalid component was dropped on this ASingleBuildingPanel.");
                        return null;
                    }
                    this.update();
                }
                return null;
            }

            @Override
            public int suggested(GoodsType type) {
                return -1;
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                super.propertyChange(event);
                ColonyPanel.this.updateProduction();
            }
        }
    }

    public final class WarehousePanel
    extends MigPanel
    implements DropTarget,
    PropertyChangeListener {
        public WarehousePanel() {
            super("WarehousePanelUI", new MigLayout("fill, gap push, insets 0"));
        }

        public void initialize() {
            this.cleanup();
            this.addPropertyChangeListeners();
            this.update();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
            this.removeAll();
        }

        private void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().addPropertyChangeListener(this);
            }
        }

        private void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().removePropertyChangeListener(this);
            }
        }

        public void update() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            this.removeAll();
            ClientOptions options = ColonyPanel.this.getClientOptions();
            int threshold = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? 1 : options.getInteger("model.option.guiMinNumberToDisplayGoods");
            Game game = colony.getGame();
            Specification spec = colony.getSpecification();
            for (GoodsType goodsType : spec.getStorableGoodsTypeList()) {
                int count = colony.getGoodsCount(goodsType);
                if (count < threshold) continue;
                Goods goods = new Goods(game, colony, goodsType, count);
                GoodsLabel goodsLabel = new GoodsLabel(ColonyPanel.this.getFreeColClient(), goods, true);
                if (ColonyPanel.this.isEditable()) {
                    goodsLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    goodsLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add((Component)goodsLabel, "alignx center");
            }
            ColonyPanel.this.updateProduction();
            this.revalidate();
            this.repaint();
        }

        @Override
        public boolean accepts(Goods goods) {
            return true;
        }

        @Override
        public boolean accepts(GoodsType goodsType) {
            return false;
        }

        @Override
        public boolean accepts(Unit unit) {
            return false;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component: " + comp);
                    return null;
                }
                comp.getParent().remove(comp);
                return comp;
            }
            return this.add(comp);
        }

        @Override
        public int suggested(GoodsType type) {
            Colony colony = ColonyPanel.this.getColony();
            return colony.getWarehouseCapacity() - colony.getGoodsCount(type);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null && event != null) {
                logger.finest(colony.getName() + "-warehouse change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
            }
            this.update();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            BufferedImage colonyWarehouseBackground = ColonyPanel.this.getImageLibrary().getColonyWarehouseBackground();
            ImageUtils.drawTiledImage(colonyWarehouseBackground, g, this, this.getInsets());
        }
    }

    public final class ColonyInPortPanel
    extends InPortPanel {
        public ColonyInPortPanel() {
            super(new MigLayout("ins 0, gapy 0, align center bottom", "", "[bottom]"), ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setOpaque(false);
        }

        @Override
        public void initialize() {
            super.initialize();
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                this.setName(colony.getName() + " - " + Messages.message("port"));
            }
        }

        @Override
        protected void addPropertyChangeListeners() {
            Unit selected = ColonyPanel.this.getSelectedUnit();
            if (selected != null) {
                selected.addPropertyChangeListener("CARGO_CHANGE", this);
            }
        }

        @Override
        protected void removePropertyChangeListeners() {
            Unit selected = ColonyPanel.this.getSelectedUnit();
            if (selected != null) {
                selected.removePropertyChangeListener("CARGO_CHANGE", this);
            }
        }

        @Override
        public boolean accepts(Unit unit) {
            return unit.isCarrier();
        }

        @Override
        public void selectLabel() {
            this.removePropertyChangeListeners();
            super.selectLabel();
            this.addPropertyChangeListeners();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            if (ColonyPanel.this.selectedUnitLabel != null) {
                Color oldColor = g.getColor();
                Stroke oldStroke = g2d.getStroke();
                g2d.setColor(ImageLibrary.getColor("color.carrier.selected"));
                Rectangle bounds = ColonyPanel.this.selectedUnitLabel.getBounds();
                int scaledLine = ColonyPanel.this.getImageLibrary().scaleInt(2);
                g2d.setStroke(new BasicStroke(scaledLine));
                g2d.drawRect(bounds.x - scaledLine, bounds.y - scaledLine, bounds.width + scaledLine * 2, bounds.height + scaledLine * 2);
                g2d.setColor(oldColor);
                g2d.setStroke(oldStroke);
            }
        }
    }

    public final class OutsideColonyPanel
    extends UnitPanel
    implements DropTarget {
        public OutsideColonyPanel() {
            super("OutsideColonyPanelUI", new MigLayout("ins 0, gapy 0, align center bottom", "", "[bottom]"), ColonyPanel.this, null, ColonyPanel.this.isEditable());
            this.setOpaque(false);
        }

        @Override
        public void initialize() {
            super.initialize();
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                this.setName(colony.getName() + " - " + Messages.message("port"));
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.removeAll();
        }

        @Override
        protected void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getTile().addPropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        @Override
        protected void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getTile().removePropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        @Override
        public boolean accepts(Goods goods) {
            return false;
        }

        @Override
        public boolean accepts(GoodsType goodsType) {
            return false;
        }

        @Override
        public boolean accepts(Unit unit) {
            return !unit.isCarrier();
        }

        @Override
        public void selectLabel() {
        }

        @Override
        public Component add(Component comp, boolean editState) {
            Container oldParent = comp.getParent();
            if (editState) {
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (!unit.isOnCarrier()) {
                        ColonyPanel.this.igc().putOutsideColony(unit);
                    }
                    if (unit.getColony() == null) {
                        ColonyPanel.this.closeColonyPanel();
                        return null;
                    }
                    if (!unit.isOnTile() && !unit.isOnCarrier()) {
                        return null;
                    }
                    oldParent.remove(comp);
                    this.initialize();
                    return comp;
                }
                logger.warning("Invalid component: " + comp);
                return null;
            }
            ((UnitLabel)comp).setSmall(false);
            return this.add(comp);
        }

        @Override
        public int suggested(GoodsType type) {
            return -1;
        }
    }

    public final class PopulationPanel
    extends MigPanel {
        private final JLabel rebelShield;
        private final JLabel rebelLabel;
        private final JLabel bonusLabel;
        private final JLabel royalistLabel;
        private final JLabel royalistShield;
        private final JLabel rebelMemberLabel;
        private final JLabel popLabel;
        private final JLabel royalistMemberLabel;

        public PopulationPanel() {
            super("PopulationPanelUI", new MigLayout("wrap 5, fill, insets 0", "[][]:push[center]:push[right][]"));
            this.rebelShield = new JLabel();
            this.rebelLabel = new JLabel();
            this.bonusLabel = new JLabel();
            this.royalistLabel = new JLabel();
            this.royalistShield = new JLabel();
            this.rebelMemberLabel = new JLabel();
            this.popLabel = new JLabel();
            this.royalistMemberLabel = new JLabel();
            this.setOpaque(false);
            this.setToolTipText(" ");
        }

        public void initialize() {
            this.cleanup();
            this.update();
        }

        public void cleanup() {
        }

        public void update() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony == null) {
                return;
            }
            ImageLibrary lib = ColonyPanel.this.getImageLibrary();
            Font font = FontLibrary.getScaledFont("normal-plain-smaller", null);
            int uc = colony.getUnitCount();
            int solPercent = colony.getSonsOfLiberty();
            int rebelCount = Colony.calculateRebelCount(uc, solPercent);
            Nation nation = colony.getOwner().getNation();
            int grow = colony.getPreferredSizeChange();
            int bonus = colony.getProductionBonus();
            this.removeAll();
            this.rebelShield.setIcon(new ImageIcon(lib.getSmallerNationImage(nation)));
            this.add((Component)this.rebelShield, "bottom");
            Object t = StringTemplate.template("colonyPanel.rebelLabel").addAmount("%number%", rebelCount);
            this.rebelLabel.setText(Messages.message(t));
            this.rebelLabel.setFont(font);
            this.add((Component)this.rebelLabel, "split 2, flowy");
            this.rebelMemberLabel.setText(solPercent + "%");
            this.rebelMemberLabel.setFont(font);
            this.add(this.rebelMemberLabel);
            t = StringTemplate.template("colonyPanel.populationLabel").addAmount("%number%", uc);
            this.popLabel.setText(Messages.message(t));
            this.popLabel.setFont(font);
            this.add((Component)this.popLabel, "split 2, flowy");
            String growth = grow == 0 ? "" : "(" + (grow >= 10 ? Messages.message("many") : String.valueOf(grow)) + ")";
            t = ((StringTemplate)StringTemplate.template("colonyPanel.bonusLabel").addAmount("%number%", bonus)).addName("%extra%", growth);
            this.bonusLabel.setText(Messages.message(t));
            this.bonusLabel.setFont(font);
            this.add(this.bonusLabel);
            t = StringTemplate.template("colonyPanel.royalistLabel").addAmount("%number%", uc - rebelCount);
            this.royalistLabel.setText(Messages.message(t));
            this.royalistLabel.setFont(font);
            this.add((Component)this.royalistLabel, "split 2, flowy");
            this.royalistMemberLabel.setText(100 - solPercent + "%");
            this.royalistMemberLabel.setFont(font);
            this.add(this.royalistMemberLabel);
            Nation other = colony.getOwner().isREF() ? nation.getRebelNation() : nation.getREFNation();
            try {
                this.royalistShield.setIcon(new ImageIcon(lib.getSmallerNationImage(other)));
                this.add((Component)this.royalistShield, "bottom");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Shield: " + nation + "/" + other, e);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public JToolTip createToolTip() {
            RebelToolTip toolTip = new RebelToolTip(ColonyPanel.this.getFreeColClient(), ColonyPanel.this.getColony());
            return toolTip;
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeAll();
            this.setLayout(null);
        }
    }

    public final class ColonyCargoPanel
    extends CargoPanel {
        public ColonyCargoPanel(FreeColClient freeColClient) {
            super(freeColClient, false, true);
        }

        @Override
        public void update() {
            super.update();
            ColonyPanel.this.updateCarrierButtons();
            ColonyPanel.this.updatePopulationPanel();
        }
    }
}

