/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Specification;

public class Event
extends FreeColSpecObjectType {
    public static final String TAG = "event";
    private String value;
    private int scoreValue = 0;
    private Map<String, Limit> limits = null;
    private static final String SCORE_VALUE_TAG = "score-value";
    private static final String OLD_SCORE_VALUE_TAG = "scoreValue";

    public Event(String id, Specification specification) {
        super(id, specification);
    }

    public Event(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        super(specification);
        this.readFromXML(xr);
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String newValue) {
        this.value = newValue;
    }

    public final int getScoreValue() {
        return this.scoreValue;
    }

    public final void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    protected Map<String, Limit> getLimits() {
        return this.limits;
    }

    protected void setLimits(Map<String, Limit> limits) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Limit>();
        } else {
            this.limits.clear();
        }
        this.limits.putAll(limits);
    }

    public final Collection<Limit> getLimitValues() {
        return this.limits == null ? Collections.emptyList() : this.limits.values();
    }

    public final Limit getLimit(String id) {
        return this.limits == null ? null : this.limits.get(id);
    }

    private void addLimit(Limit limit) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Limit>();
        }
        this.limits.put(limit.getId(), limit);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Event o = this.copyInCast(other, Event.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.value = o.getValue();
        this.scoreValue = o.getScoreValue();
        this.setLimits(o.getLimits());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value);
        }
        if (this.scoreValue != 0) {
            xw.writeAttribute(SCORE_VALUE_TAG, this.scoreValue);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Limit limit : this.getLimitValues()) {
            limit.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.value = xr.getAttribute("value", null);
        this.scoreValue = xr.hasAttribute(OLD_SCORE_VALUE_TAG) ? xr.getAttribute(OLD_SCORE_VALUE_TAG, 0) : xr.getAttribute(SCORE_VALUE_TAG, 0);
    }

    @Override
    protected void clearContainers(FreeColXMLReader xr) throws XMLStreamException {
        super.clearContainers(xr);
        this.limits = null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if ("limit".equals(tag)) {
            this.addLimit(new Limit(xr, spec));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

