/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.model.ServerPlayer;

public abstract class Message {
    protected static final Logger logger = Logger.getLogger(Message.class.getName());
    private static final Map<String, Constructor<? extends Message>> builders = Collections.synchronizedMap(new HashMap());
    private static final Class[] readClasses = new Class[]{Game.class, FreeColXMLReader.class};
    public static final Comparator<Message> messagePriorityComparator = Comparator.comparingInt(Message::getPriorityLevel);

    protected Message() {
    }

    public abstract String getType();

    protected abstract void setType(String var1);

    protected abstract boolean hasAttribute(String var1);

    protected abstract String getStringAttribute(String var1);

    protected abstract void setStringAttribute(String var1, String var2);

    protected abstract Map<String, String> getStringAttributeMap();

    protected abstract int getChildCount();

    protected abstract List<FreeColObject> getChildren();

    protected abstract void setChildren(List<? extends FreeColObject> var1);

    protected abstract <T extends FreeColObject> void appendChild(T var1);

    protected abstract <T extends FreeColObject> void appendChildren(Collection<T> var1);

    public abstract boolean currentPlayerMessage();

    public abstract MessagePriority getPriority();

    public boolean canMerge() {
        return false;
    }

    public abstract void aiHandler(FreeColServer var1, AIPlayer var2) throws FreeColException;

    public abstract void clientHandler(FreeColClient var1) throws FreeColException;

    public abstract ChangeSet serverHandler(FreeColServer var1, ServerPlayer var2);

    public boolean isType(String type) {
        return this.getType().equals(type);
    }

    protected Boolean getBooleanAttribute(String key, Boolean defaultValue) {
        if (this.hasAttribute(key)) {
            try {
                return Boolean.valueOf(this.getStringAttribute(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected Integer getIntegerAttribute(String key, int defaultValue) {
        if (this.hasAttribute(key)) {
            try {
                return Integer.valueOf(this.getStringAttribute(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected <T extends Enum<T>> T getEnumAttribute(String key, Class<T> returnClass, T defaultValue) {
        T result = defaultValue;
        if (this.hasAttribute(key)) {
            String kv = StringUtils.upCase(this.getStringAttribute(key));
            try {
                result = Enum.valueOf(returnClass, kv);
            }
            catch (Exception e) {
                logger.warning("Not a " + defaultValue.getClass().getName() + ": " + kv);
            }
        }
        return result;
    }

    protected void setBooleanAttribute(String key, Boolean value) {
        if (value != null) {
            this.setStringAttribute(key, Boolean.toString(value));
        }
    }

    protected void setEnumAttribute(String key, Enum<?> value) {
        if (value != null) {
            this.setStringAttribute(key, StringUtils.downCase(value.toString()));
        }
    }

    protected void setIntegerAttribute(String key, int value) {
        this.setStringAttribute(key, Integer.toString(value));
    }

    protected void setStringAttributeMap(Map<String, String> attributeMap) {
        CollectionUtils.forEachMapEntry(attributeMap, e -> this.setStringAttribute((String)e.getKey(), (String)e.getValue()));
    }

    protected void setStringAttributes(List<String> attributes) {
        for (int i = 0; i < attributes.size() - 1; i += 2) {
            String k = attributes.get(i);
            String v = attributes.get(i + 1);
            if (k == null || v == null) continue;
            this.setStringAttribute(k, v);
        }
    }

    protected void setStringAttributes(String[] attributes) {
        for (int i = 0; i < attributes.length; i += 2) {
            if (attributes[i + 1] == null) continue;
            this.setStringAttribute(attributes[i], attributes[i + 1]);
        }
    }

    protected List<String> getArrayAttributes() {
        String key;
        ArrayList<String> ret = new ArrayList<String>();
        int n = this.getIntegerAttribute("xLength", -1);
        for (int i = 0; i < n && this.hasAttribute(key = FreeColObject.arrayKey(i)); ++i) {
            ret.add(this.getStringAttribute(key));
        }
        return ret;
    }

    protected void setArrayAttributes(List<String> attributes) {
        if (attributes != null) {
            int i = 0;
            for (String a : attributes) {
                String key = FreeColObject.arrayKey(i);
                ++i;
                this.setStringAttribute(key, a);
            }
            this.setIntegerAttribute("xLength", i);
        }
    }

    protected void setArrayAttributes(String[] attributes) {
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                this.setStringAttribute(FreeColObject.arrayKey(i), attributes[i]);
            }
        }
    }

    protected <T extends FreeColObject> T getChild(int index, Class<T> returnClass) {
        if (index >= this.getChildCount()) {
            return (T)((FreeColObject)null);
        }
        FreeColObject fco = this.getChildren().get(index);
        try {
            return (T)((FreeColObject)returnClass.cast(fco));
        }
        catch (ClassCastException cce) {
            logger.log(Level.WARNING, "Cast fail", cce);
            return null;
        }
    }

    protected <T extends FreeColObject> List<T> getChildren(Class<T> returnClass) {
        ArrayList<FreeColObject> ret = new ArrayList<FreeColObject>();
        for (FreeColObject fco : this.getChildren()) {
            try {
                ret.add((FreeColObject)returnClass.cast(fco));
            }
            catch (ClassCastException classCastException) {}
        }
        return ret;
    }

    protected boolean isEmpty() {
        return this.getStringAttributeMap().isEmpty() && this.getChildren().isEmpty();
    }

    public final int getPriorityLevel() {
        return this.getPriority().getValue();
    }

    public boolean merge(Message message) {
        if (!message.canMerge()) {
            return false;
        }
        Map<String, String> map = this.getStringAttributeMap();
        map.putAll(message.getStringAttributeMap());
        this.setStringAttributeMap(map);
        HashSet<FreeColObject> objs = new HashSet<FreeColObject>(this.getChildren());
        objs.addAll(message.getChildren());
        this.setChildren(CollectionUtils.toList(objs));
        return true;
    }

    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        for (Map.Entry<String, String> e : this.getStringAttributeMap().entrySet()) {
            xw.writeAttribute(e.getKey(), e.getValue());
        }
    }

    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        for (FreeColObject fco : this.getChildren()) {
            fco.toXML(xw);
        }
    }

    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeStartElement(this.getType());
        this.writeAttributes(xw);
        this.writeChildren(xw);
        xw.writeEndElement();
    }

    protected InGameController igc(FreeColClient freeColClient) {
        return freeColClient.getInGameController();
    }

    protected net.sf.freecol.server.control.InGameController igc(FreeColServer freeColServer) {
        return freeColServer.getInGameController();
    }

    protected void invokeAndWait(FreeColClient freeColClient, Runnable runnable) {
        freeColClient.getGUI().invokeNowOrWait(runnable);
    }

    protected void invokeLater(FreeColClient freeColClient, Runnable runnable) {
        freeColClient.getGUI().invokeNowOrLater(runnable);
    }

    protected net.sf.freecol.client.control.PreGameController pgc(FreeColClient freeColClient) {
        return freeColClient.getPreGameController();
    }

    protected PreGameController pgc(FreeColServer freeColServer) {
        return freeColServer.getPreGameController();
    }

    protected void clientGeneric(FreeColClient freeColClient) {
        FreeColClient fcc = freeColClient;
        if (fcc.currentPlayerIsMyPlayer()) {
            String soundId = this.getStringAttribute("sound");
            boolean flush = this.getBooleanAttribute("flush", Boolean.FALSE);
            if (soundId != null || flush) {
                this.invokeLater(freeColClient, () -> {
                    if (soundId != null) {
                        this.igc(fcc).sound(soundId);
                    }
                    if (flush) {
                        this.igc(fcc).nextModelMessage();
                    }
                });
            }
        }
    }

    protected void expected(String wanted, String got) throws XMLStreamException {
        throw new XMLStreamException("In " + this.getClass().getName() + ", expected " + wanted + " but read: " + got);
    }

    public static Message read(Game game, FreeColXMLReader xr) throws FreeColException {
        String tag = xr.getLocalName();
        Message ret = null;
        Constructor<Message> mb = builders.get(tag);
        if (mb == null) {
            String className = "net.sf.freecol.common.networking." + StringUtils.capitalize(tag) + "Message";
            Class<?> cl = Introspector.getClassByName(className);
            if (cl == null) {
                throw new FreeColException("No class for: " + tag).preserveDebug();
            }
            mb = Introspector.getConstructor(cl, readClasses);
            if (mb == null) {
                throw new FreeColException("No constructor for: " + tag).preserveDebug();
            }
            builders.put(tag, mb);
        }
        try {
            ret = Introspector.construct(mb, new Object[]{game, xr});
        }
        catch (Introspector.IntrospectorException ie) {
            throw new FreeColException(ie);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        Message.pretty(sb, this.getType(), this.getStringAttributeMap(), this.getChildren());
        sb.append(']');
        return sb.toString();
    }

    protected static void pretty(StringBuilder sb, String type, Map<String, String> attributeMap, List<FreeColObject> children) {
        sb.append(type);
        if (attributeMap != null) {
            for (Map.Entry entry : attributeMap.entrySet()) {
                sb.append(' ').append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
        }
        if (children != null) {
            for (FreeColObject freeColObject : children) {
                sb.append(' ').append(freeColObject.getId());
            }
        }
    }

    public static enum MessagePriority {
        ATTRIBUTE(-1),
        ANIMATION(0),
        REMOVE(100),
        ADDPLAYER(4),
        STANCE(5),
        OWNED(20),
        PARTIAL(9),
        UPDATE(10),
        EARLY(1),
        NORMAL(15),
        LATE(90),
        LAST(99);

        private final int level;

        private MessagePriority(int level) {
            this.level = level;
        }

        public int getValue() {
            return this.level;
        }
    }
}

