/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class RearrangeColonyMessage
extends AttributeMessage {
    public static final String TAG = "rearrangeColony";
    private static final String COLONY_TAG = "colony";

    public RearrangeColonyMessage(Colony colony, List<Unit> workers, Colony scratch) {
        super(TAG, COLONY_TAG, colony.getId());
        this.setArrangementAttributes(Arrangement.getArrangements(colony, workers, scratch));
    }

    public RearrangeColonyMessage(Game game, FreeColXMLReader xr) {
        super(TAG, RearrangeColonyMessage.getAttributeMap(xr));
    }

    private static Map<String, String> getAttributeMap(FreeColXMLReader xr) {
        int n = xr.getAttribute("xLength", 0);
        HashMap<String, String> ret = new HashMap<String, String>(5 * n + 1);
        ret.put(COLONY_TAG, xr.getAttribute(COLONY_TAG, null));
        for (int i = 0; i < n; ++i) {
            ret.put(Arrangement.unitKey(i), xr.getAttribute(Arrangement.unitKey(i), null));
            ret.put(Arrangement.locKey(i), xr.getAttribute(Arrangement.locKey(i), null));
            ret.put(Arrangement.workKey(i), xr.getAttribute(Arrangement.workKey(i), null));
            ret.put(Arrangement.roleKey(i), xr.getAttribute(Arrangement.roleKey(i), null));
            ret.put(Arrangement.roleCountKey(i), xr.getAttribute(Arrangement.roleCountKey(i), null));
        }
        return ret;
    }

    private void setArrangementAttributes(List<Arrangement> arrangements) {
        int i = 0;
        for (Arrangement a : arrangements) {
            this.setStringAttribute(Arrangement.unitKey(i), a.unit.getId());
            this.setStringAttribute(Arrangement.locKey(i), a.loc.getId());
            if (a.work != null) {
                this.setStringAttribute(Arrangement.workKey(i), a.work.getId());
            }
            this.setStringAttribute(Arrangement.roleKey(i), a.role.toString());
            this.setStringAttribute(Arrangement.roleCountKey(i), String.valueOf(a.roleCount));
            ++i;
        }
        this.setIntegerAttribute("xLength", i);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Colony colony;
        String colonyId = this.getStringAttribute(COLONY_TAG);
        Game game = serverPlayer.getGame();
        List<Arrangement> arrangements = this.getArrangements(game);
        try {
            colony = serverPlayer.getOurFreeColGameObject(colonyId, Colony.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (arrangements.isEmpty()) {
            return serverPlayer.clientError("Empty rearrangement list.");
        }
        int i = 0;
        for (Arrangement uc : arrangements) {
            if (uc.unit == null) {
                return serverPlayer.clientError("Invalid unit " + i);
            }
            if (uc.loc == null) {
                return serverPlayer.clientError("Invalid location " + i);
            }
            if (uc.role == null) {
                return serverPlayer.clientError("Invalid role " + i);
            }
            if (uc.roleCount >= 0) continue;
            return serverPlayer.clientError("Invalid role count " + i);
        }
        return this.igc(freeColServer).rearrangeColony(serverPlayer, colony, arrangements);
    }

    @Override
    public boolean isEmpty() {
        return this.getIntegerAttribute("xLength", 0) == 0;
    }

    public List<Arrangement> getArrangements(Game game) {
        int n = this.getIntegerAttribute("xLength", 0);
        ArrayList<Arrangement> ret = new ArrayList<Arrangement>(n);
        for (int i = 0; i < n; ++i) {
            ret.add(new Arrangement(game, this.getStringAttribute(Arrangement.unitKey(i)), this.getStringAttribute(Arrangement.locKey(i)), this.getStringAttribute(Arrangement.workKey(i)), this.getStringAttribute(Arrangement.roleKey(i)), this.getStringAttribute(Arrangement.roleCountKey(i))));
        }
        return ret;
    }

    public static class Arrangement {
        public Unit unit;
        public Location loc;
        public GoodsType work;
        public Role role;
        public int roleCount;

        public Arrangement() {
        }

        public Arrangement(Unit unit, Location loc, GoodsType work, Role role, int roleCount) {
            this.unit = unit;
            this.loc = loc;
            this.work = work;
            this.role = role;
            this.roleCount = roleCount;
        }

        public Arrangement(Game game, String unitId, String locId, String workId, String roleId, String roleCount) {
            this.init(game, unitId, locId, workId, roleId, roleCount);
        }

        public final void init(Game game, String unitId, String locId, String workId, String roleId, String roleCount) {
            this.unit = game.getFreeColGameObject(unitId, Unit.class);
            this.loc = game.findFreeColLocation(locId);
            this.work = workId == null || workId.isEmpty() ? null : game.getSpecification().getGoodsType(workId);
            this.role = game.getSpecification().getRole(roleId);
            try {
                this.roleCount = Integer.parseInt(roleCount);
            }
            catch (NumberFormatException nfe) {
                this.roleCount = 0;
            }
        }

        public static String unitKey(int i) {
            return FreeColObject.arrayKey(i) + "unit";
        }

        public static String locKey(int i) {
            return FreeColObject.arrayKey(i) + "loc";
        }

        public static String workKey(int i) {
            return FreeColObject.arrayKey(i) + "work";
        }

        public static String roleKey(int i) {
            return FreeColObject.arrayKey(i) + "role";
        }

        public static String roleCountKey(int i) {
            return FreeColObject.arrayKey(i) + "count";
        }

        public static List<Arrangement> getArrangements(Colony colony, List<Unit> workers, Colony scratch) {
            ArrayList<Arrangement> ret = new ArrayList<Arrangement>(workers.size());
            for (Unit u : workers) {
                Unit su = scratch.getCorresponding(u);
                if (u.getLocation().getId().equals(su.getLocation().getId()) && u.getWorkType() == su.getWorkType() && u.getRole() == su.getRole() && u.getRoleCount() == su.getRoleCount()) continue;
                ret.add(new Arrangement(u, (Location)((Object)colony.getCorresponding((FreeColObject)((Object)su.getLocation()))), su.getWorkType(), su.getRole(), su.getRoleCount()));
            }
            return ret;
        }

        public int roleComparison(Arrangement other) {
            int cmp = this.role.compareTo(other.role);
            if (cmp == 0) {
                cmp = this.roleCount - other.roleCount;
            }
            return cmp;
        }

        public String toString() {
            return "[Arrangement " + this.unit.getId() + " at " + this.loc.getId() + " " + this.role.getRoleSuffix() + "." + this.roleCount + (String)(this.work == null ? "" : " work " + this.work.getId()) + "]";
        }
    }
}

