/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public final class EscortUnitMission
extends Mission {
    private static final Logger logger = Logger.getLogger(EscortUnitMission.class.getName());
    public static final String TAG = "escortUnitMission";
    private static final String tag = "AI escorter";
    private Location target;
    private Location transportTarget;
    private static final String TARGET_TAG = "target";

    public EscortUnitMission(AIMain aiMain, AIUnit aiUnit, Unit target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
    }

    public EscortUnitMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private static String invalidUnitReason(AIUnit aiUnit) {
        String reason = EscortUnitMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isOffensiveUnit() ? "unit-not-offensive" : null);
    }

    private static String invalidTargetReason(AIUnit aiUnit, Unit unit) {
        String reason = EscortUnitMission.invalidTargetReason(unit);
        if (reason != null) {
            return reason;
        }
        Tile tile = unit.getTile();
        return tile == null ? "target-not-on-map" : (aiUnit.getUnit().getOwner() != unit.getOwner() ? "target-ownership" : (aiUnit.getUnit().isNaval() != unit.isNaval() ? "target-incompatible" : null));
    }

    public static String invalidMissionReason(AIUnit aiUnit) {
        return EscortUnitMission.invalidUnitReason(aiUnit);
    }

    public static String invalidMissionReason(AIUnit aiUnit, Location loc) {
        String reason = EscortUnitMission.invalidMissionReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        return EscortUnitMission.invalidTargetReason(aiUnit, (Unit)loc);
    }

    @Override
    public int getBaseTransportPriority() {
        return 100;
    }

    @Override
    public Location getTransportDestination() {
        if (!this.isValid()) {
            return null;
        }
        Location loc = this.transportTarget != null ? this.transportTarget : this.target;
        return this.getUnit().shouldTakeTransportTo(loc) ? loc : null;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target != null && !(target instanceof Unit)) {
            throw new IllegalArgumentException("Target not supported: " + target);
        }
        this.target = target;
    }

    @Override
    public Location findTarget() {
        return null;
    }

    @Override
    public String invalidReason() {
        return EscortUnitMission.invalidMissionReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        AIUnit aiUnit = this.getAIUnit();
        String reason = this.invalidReason();
        if (EscortUnitMission.isTargetReason(reason)) {
            return this.lbDrop(lb, reason);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Location currentTarget = this.getTarget();
        Unit.MoveType mt = this.travelToTarget(currentTarget, CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_ILLEGAL: {
                this.lbWait(lb, new Object[0]);
                break;
            }
            case MOVE_NO_REPAIR: {
                return this.lbFail(lb, false, "aiUnit-died");
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                break;
            }
            case ATTACK_UNIT: 
            case ATTACK_SETTLEMENT: {
                Tile unitTile = this.getUnit().getTile();
                Direction d = unitTile.getDirection(currentTarget.getTile());
                if (d == null) {
                    logger.warning("SDDM bogus " + mt + " with " + this.getUnit() + " from " + unitTile + " to " + currentTarget + " at " + currentTarget.getTile());
                    return this.lbWait(lb, new Object[0]);
                }
                AIMessage.askAttack(aiUnit, d);
                return this.lbAttack(lb, currentTarget);
            }
            default: {
                this.lbMove(lb, mt);
            }
        }
        return this;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

