/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.util.test;

import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.generator.MapGenerator;

public class MockMapGenerator
implements MapGenerator {
    private Map map;

    public MockMapGenerator(Map map) {
        this.map = map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    @Override
    public Map generateMap(Game game, Map importMap, boolean generateEuropeanPlayerUnits, LogBuilder lb) {
        Game oldGame = this.map.getGame();
        game.changeMap(this.map);
        for (FreeColGameObject fcgo : oldGame.getFreeColGameObjectList()) {
            if (fcgo instanceof Europe || fcgo instanceof HighSeas || fcgo instanceof Market || fcgo instanceof MarketData || fcgo instanceof Monarch || fcgo instanceof Player) continue;
            fcgo.setGame(game);
            FreeColGameObject other = game.getFreeColGameObject(fcgo.getId());
            if (other == fcgo) continue;
            if (other != null) {
                game.removeFreeColGameObject(other.getId(), "mock");
            }
            game.addFreeColGameObject(fcgo.getId(), fcgo);
        }
        return this.map;
    }

    @Override
    public Map generateEmptyMap(Game game, int width, int height, LogBuilder lb) {
        return this.map;
    }
}

