/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.FreeplaneResourceAccessor;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryNavigator;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconNotFound;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.ScriptingMenuUtils;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;

public class AddOnDetailsPanel
extends JPanel {
    private int maxWidth = 500;
    private String warning;

    public AddOnDetailsPanel(AddOnProperties addOn, String warning) {
        this.warning = warning;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, RowSpec.decode((String)"top:default:grow")}));
        if (warning != null) {
            JLabel warningLabel = this.createWarningLabel(addOn);
            this.add((Component)warningLabel, "3, 2");
        }
        JLabel imageLabel = this.createImageLabel(addOn);
        this.add((Component)imageLabel, "1, 4");
        JLabel title = this.createTitleLabel(addOn);
        this.add((Component)title, "3, 4");
        JLabel author = this.createAuthorLabel(addOn);
        this.add((Component)author, "3, 6");
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(AddOnDetailsPanel.getText("homepage", new Object[0])));
        box.add(this.createAddOnHomepageButton(addOn));
        this.add((Component)box, "3, 8, left, default");
        JComponent details = this.createDetails(addOn);
        this.add((Component)details, "3, 9");
    }

    private JLabel createImageLabel(AddOnProperties addOn) {
        JLabel label = new JLabel("");
        label.setIcon(IconNotFound.createIconOrReturnNotFoundIcon((String[])new String[]{addOn.getName() + ".svg", addOn.getName() + ".png"}));
        return label;
    }

    public AddOnDetailsPanel(AddOnProperties addOn) {
        this(addOn, null);
    }

    private JLabel createWarningLabel(AddOnProperties addOn) {
        return new JLabel("<html><body>" + this.warning.replaceAll("</?(html|body)>", "") + "</body></html>");
    }

    private JLabel createTitleLabel(AddOnProperties addOn) {
        return new JLabel("<html><body><b><font size='+2'>" + this.toHtml(addOn.getTranslatedName()) + " " + addOn.getVersion().replaceAll("^v", "") + "</font></b></body></html>");
    }

    private JLabel createAuthorLabel(AddOnProperties addOn) {
        String text = addOn.getAuthor() == null ? "" : "<html><body><strong><font size='-1'>" + AddOnDetailsPanel.getText("authored.by", this.toHtml(addOn.getAuthor())) + "</font></strong></body></html>";
        return new JLabel(text);
    }

    private JComponent createAddOnHomepageButton(AddOnProperties addOn) {
        try {
            return UITools.createHtmlLinkStyleButton((URI)addOn.getHomepage().toURI(), (String)addOn.getHomepage().toString());
        }
        catch (Exception e) {
            LogUtils.warn((String)("add-on " + addOn + " has no valid homepage: " + e));
            return new JLabel("-");
        }
    }

    private JComponent createDetails(AddOnProperties addOn) {
        List<ScriptAddOnProperties.Script> scripts;
        StringBuilder text = new StringBuilder(1024);
        text.append("<html><body>");
        text.append(this.toHtml(addOn.getDescription()));
        text.append("<p>");
        if (addOn instanceof ScriptAddOnProperties && !(scripts = ((ScriptAddOnProperties)addOn).getScripts()).isEmpty()) {
            text.append("<table border='1'>");
            text.append(this.row("th", AddOnDetailsPanel.getText("header.function", new Object[0]), AddOnDetailsPanel.getText("header.menu", new Object[0]), AddOnDetailsPanel.getText("header.shortcut", new Object[0])));
            for (ScriptAddOnProperties.Script script : scripts) {
                text.append(this.row("td", this.bold(TextUtils.getText((String)script.menuTitleKey)), HtmlUtils.toXMLEscapedText((String)this.formatMenuLocation(script)), this.formatShortcut(script)));
            }
            text.append("</table>");
        }
        text.append("</body></html>");
        JLabel label = new JLabel(text.toString());
        label.setAutoscrolls(true);
        Icon icon = AddOnDetailsPanel.createIconOrReturnNull(addOn.getName() + "-screenshot-1.png");
        if (icon != null) {
            label.setIcon(icon);
        }
        return label;
    }

    private static Icon createIconOrReturnNull(String fileName) {
        URL resource = ResourceController.getResourceController().getResource("/images/" + fileName);
        return resource == null ? null : new ImageIcon(resource);
    }

    private String toHtml(String htmlOrPlainText) {
        if (HtmlUtils.isHtml((String)htmlOrPlainText)) {
            return htmlOrPlainText.replaceAll("</?(html|body)>", "");
        }
        return HtmlUtils.toHTMLEscapedText((String)htmlOrPlainText);
    }

    private String formatShortcut(ScriptAddOnProperties.Script script) {
        String menuItemKey = ExecuteScriptAction.makeMenuItemKey(script.menuTitleKey, script.executionMode);
        ActionAcceleratorManager acceleratorManager = ResourceController.getResourceController().getAcceleratorManager();
        KeyStroke userDefinedKeystroke = acceleratorManager.getAccelerator(menuItemKey);
        KeyStroke keyStroke = userDefinedKeystroke != null ? userDefinedKeystroke : UITools.getKeyStroke((String)script.keyboardShortcut);
        return UITools.keyStrokeToString((KeyStroke)keyStroke);
    }

    private String formatMenuLocation(ScriptAddOnProperties.Script script) {
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        Entry top = modeController.getUserInputListenerFactory().getGenericMenuStructure();
        String canonicalPath = EntryNavigator.instance().replaceAliases(script.menuLocation);
        String[] pathElements = canonicalPath.split("/");
        Entry entry = top;
        ListIterator<String> pathIterator = Arrays.asList(pathElements).listIterator();
        while (pathIterator.hasNext()) {
            String name = pathIterator.next();
            if (name.isEmpty()) continue;
            Entry child = entry.getChild(name);
            if (child == null) {
                pathIterator.previous();
                break;
            }
            entry = child;
        }
        if (entry == null) {
            return script.menuLocation;
        }
        FreeplaneResourceAccessor resourceAccessor = new FreeplaneResourceAccessor();
        EntryAccessor entryAccessor = new EntryAccessor((ResourceAccessor)resourceAccessor);
        String entryLocationDescription = entryAccessor.getLocationDescription(entry);
        if (!pathIterator.hasNext()) {
            return entryLocationDescription;
        }
        StringBuilder menuLocationDescription = new StringBuilder(entryLocationDescription);
        while (pathIterator.hasNext()) {
            menuLocationDescription.append(" -> ");
            menuLocationDescription.append(ScriptingMenuUtils.scriptNameToMenuItemTitle(pathIterator.next()));
        }
        return menuLocationDescription.toString();
    }

    private String bold(String text) {
        return "<b>" + text + "</b>";
    }

    private String row(String td, Object ... columns) {
        String separator = "</" + td + "><" + td + ">";
        return "<tr><" + td + ">" + StringUtils.join((Object[])columns, (String)separator) + "</" + td + "></tr>";
    }

    private static String getText(String key, Object ... parameters) {
        if (parameters.length == 0) {
            return TextUtils.getRawText((String)AddOnDetailsPanel.getResourceKey(key));
        }
        return TextUtils.format((String)AddOnDetailsPanel.getResourceKey(key), (Object[])parameters);
    }

    private static String getResourceKey(String key) {
        return "AddOnDetailsPanel." + key;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.min(preferredSize.width, this.maxWidth);
        return preferredSize;
    }
}

