/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class CompositeArchRule
implements ArchRule {
    private final Priority priority;
    private final List<ArchRule> rules;
    private final String description;

    private CompositeArchRule(Priority priority, List<ArchRule> rules, String description) {
        this.priority = priority;
        this.rules = Preconditions.checkNotNull(rules);
        this.description = Preconditions.checkNotNull(description);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static CompositeArchRule of(ArchRule rule) {
        return CompositeArchRule.priority(Priority.MEDIUM).of(rule);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static CompositeArchRule of(Iterable<? extends ArchRule> rules) {
        Iterator<? extends ArchRule> iterator = rules.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Iterable must be non-empty");
        }
        CompositeArchRule composite = CompositeArchRule.of(iterator.next());
        while (iterator.hasNext()) {
            composite = composite.and(iterator.next());
        }
        return composite;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Creator priority(Priority priority) {
        return new Creator(priority);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public CompositeArchRule and(ArchRule rule) {
        ImmutableCollection newRules = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.rules)).add(rule)).build();
        String newDescription = this.description + " and " + rule.getDescription();
        return new CompositeArchRule(this.priority, (List<ArchRule>)((Object)newRules), newDescription);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void check(JavaClasses classes) {
        ArchRule.Assertions.check(this, classes);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public CompositeArchRule because(String reason) {
        return new CompositeArchRule(this.priority, this.rules, ArchRule.Factory.createBecauseDescription(this, reason));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ArchRule allowEmptyShould(boolean allowEmptyShould) {
        ImmutableList.Builder rulesWithOverriddenAllowEmptyShould = ImmutableList.builder();
        for (ArchRule rule : this.rules) {
            rulesWithOverriddenAllowEmptyShould.add(rule.allowEmptyShould(allowEmptyShould));
        }
        return new CompositeArchRule(this.priority, (List<ArchRule>)((Object)rulesWithOverriddenAllowEmptyShould.build()), this.description);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public EvaluationResult evaluate(JavaClasses classes) {
        EvaluationResult result = new EvaluationResult(this, this.priority);
        for (ArchRule rule : this.rules) {
            result.add(rule.evaluate(classes));
        }
        return result;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public CompositeArchRule as(String newDescription) {
        return new CompositeArchRule(this.priority, this.rules, newDescription);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return this.description;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Creator {
        private final Priority priority;

        private Creator(Priority priority) {
            this.priority = priority;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public CompositeArchRule of(ArchRule rule) {
            return new CompositeArchRule(this.priority, Collections.singletonList(rule), rule.getDescription());
        }
    }
}

