/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode.clipboard;

import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorKit;
import com.lightdev.app.shtm.SHTMLWriter;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.html.HTMLDocument;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.HtmlProcessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.CloneEncryptedNodeException;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.SummaryGroupEdgeListAdder;
import org.freeplane.features.map.mindmapmode.clipboard.CloneAction;
import org.freeplane.features.map.mindmapmode.clipboard.MoveAction;
import org.freeplane.features.map.mindmapmode.clipboard.SelectedPasteAction;
import org.freeplane.features.map.mindmapmode.clipboard.TargetFileCreator;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.view.swing.features.filepreview.ImageAdder;
import org.freeplane.view.swing.features.filepreview.ViewerController;

public class MMapClipboardController
extends MapClipboardController
implements MClipboardController {
    public static final String RESOURCES_REMIND_USE_RICH_TEXT_IN_NEW_NODES = "remind_use_rich_text_in_new_nodes";
    private static final String FIND_EMAILS_IN_TEXT_PROPERTY = "findEmailsInText";
    private static final Pattern ATTRIBUTE_REGEX = Pattern.compile("\\s*\\+\t(\\S[^\t]*)(?:\t(.*?))\\s*");
    private static final Pattern HEADER_REGEX = Pattern.compile("h(\\d)", 2);
    private static final String RESOURCE_UNFOLD_ON_PASTE = "unfold_on_paste";
    public static final String RESOURCES_CUT_NODES_WITHOUT_QUESTION = "cut_nodes_without_question";
    private static final int AS_NEW_BRANCH = -1;
    private List<NodeModel> newNodes;

    public static String firstLetterCapitalized(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1, text.length());
    }

    public MMapClipboardController(MModeController modeController) {
        super((ModeController)modeController);
        this.createActions();
    }

    private String cleanHtml(String content) {
        String contentWithoutImages;
        boolean contentContainsOnlyImages;
        if (!(content = content.replaceFirst("(?i)(?s)<head>.*</head>", "").replaceFirst("(?i)(?s)^.*<html[^>]*>", "<html>").replaceFirst("(?i)(?s)<body [^>]*>", "<body>").replaceAll("(?i)(?s)<script.*?>.*?</script>", "").replaceAll("(?i)(?s)<meta.*?>", "").replaceAll("(?i)(?s)</?tbody.*?>", "").replaceAll("(?i)(?s)<!--.*?-->", "").replaceAll("(?i)(?s)</?o[^>]*>", "")).contains("<html>")) {
            content = "<html>" + content;
        }
        if (!content.contains("<body>")) {
            content = content.replaceFirst("<html>", "<html><body>");
        }
        if (ResourceController.getResourceController().getBooleanProperty("cut_out_pictures_when_pasting_html") && !(contentContainsOnlyImages = HtmlUtils.htmlToPlain((String)(contentWithoutImages = content.replaceAll("(?i)(?s)<img[^>]*>", ""))).trim().isEmpty())) {
            content = contentWithoutImages;
        }
        content = HtmlUtils.unescapeHTMLUnicodeEntity((String)content);
        return content;
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new SelectedPasteAction());
        modeController.addAction((AFreeplaneAction)new CloneAction());
        modeController.addAction((AFreeplaneAction)new MoveAction());
    }

    public Transferable copy(IMapSelection selection) {
        List collection = selection.getSortedSelection(true);
        MindMapNodesSelection transferable = this.copy(new SummaryGroupEdgeListAdder(collection).addSummaryEdgeNodes());
        transferable.setNodeObjects((Collection)collection, false);
        return transferable;
    }

    public Transferable copySingle(Collection<NodeModel> source) {
        MindMapNodesSelection transferable = (MindMapNodesSelection)super.copySingle(source);
        transferable.setNodeObjects(new ArrayList<NodeModel>(source), true);
        return transferable;
    }

    private void cut(IMapSelection selection) {
        List collection = selection.getSortedSelection(true);
        MindMapNodesSelection transferable = this.copy(new SummaryGroupEdgeListAdder(collection).addSummaryEdgeNodes(), MapClipboardController.CopiedNodeSet.ALL_NODES, MapClipboardController.CopiedNodeSet.ALL_NODES);
        ((MMapController)Controller.getCurrentModeController().getMapController()).deleteNodes(collection);
        this.setClipboardContents((Transferable)transferable);
    }

    private IDataFlavorHandler getFlavorHandler(Transferable t) {
        if (t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor)) {
            try {
                String textFromClipboard = t.getTransferData(MindMapNodesSelection.mindMapNodesFlavor).toString();
                return new MindMapNodesFlavorHandler(textFromClipboard);
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(TagSelection.tagFlavor)) {
            try {
                String textFromClipboard = t.getTransferData(TagSelection.tagFlavor).toString();
                return new TagSelectionHandler(textFromClipboard);
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        ResourceController resourceController = ResourceController.getResourceController();
        DataFlavor supportedHtmlFlavor = this.getSupportedHtmlFlavor(t);
        if (supportedHtmlFlavor != null) {
            try {
                MTextController textController;
                boolean richText;
                String textFromClipboard = t.getTransferData(supportedHtmlFlavor).toString();
                if (textFromClipboard.isEmpty()) {
                    return null;
                }
                if (textFromClipboard.charAt(0) != '\ufffd' && t.isDataFlavorSupported(DataFlavor.stringFlavor) && (richText = (textController = (MTextController)TextController.getController()).useRichTextInEditor(RESOURCES_REMIND_USE_RICH_TEXT_IN_NEW_NODES))) {
                    boolean structuredHtmlImport = resourceController.getBooleanProperty("structured_html_import");
                    IDataFlavorHandler htmlFlavorHandler = structuredHtmlImport ? new StructuredHtmlFlavorHandler(textFromClipboard) : new DirectHtmlFlavorHandler(textFromClipboard);
                    return htmlFlavorHandler;
                }
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
            try {
                List<File> fileList = this.castToFileList(t.getTransferData(MindMapNodesSelection.fileListFlavor));
                if (!this.shouldIgnoreFileListFlavor(fileList)) {
                    return new FileListFlavorHandler(fileList);
                }
            }
            catch (UnsupportedFlavorException fileList) {
            }
            catch (IOException fileList) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String plainTextFromClipboard = t.getTransferData(DataFlavor.stringFlavor).toString();
                return new StringFlavorHandler(plainTextFromClipboard);
            }
            catch (UnsupportedFlavorException plainTextFromClipboard) {
            }
            catch (IOException plainTextFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                return new ImageFlavorHandler(image);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean shouldIgnoreFileListFlavor(List<File> fileList) {
        if (fileList == null || fileList.isEmpty()) {
            return true;
        }
        File file = fileList.get(0);
        if (file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        return name.endsWith(".URL") || name.endsWith(".url");
    }

    private List<File> castToFileList(Object transferData) {
        return (List)transferData;
    }

    Collection<IDataFlavorHandler> getFlavorHandlers() {
        DataFlavor supportedHtmlFlavor;
        Transferable t = this.getClipboardContents();
        LinkedList<IDataFlavorHandler> handlerList = new LinkedList<IDataFlavorHandler>();
        if (t == null) {
            return handlerList;
        }
        if (t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor)) {
            try {
                String textFromClipboard = t.getTransferData(MindMapNodesSelection.mindMapNodesFlavor).toString();
                handlerList.add(new MindMapNodesFlavorHandler(textFromClipboard));
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if ((supportedHtmlFlavor = this.getSupportedHtmlFlavor(t)) != null) {
            try {
                String textFromClipboard = t.getTransferData(supportedHtmlFlavor).toString();
                if (textFromClipboard.length() > 0 && textFromClipboard.charAt(0) != '\ufffd' && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    handlerList.add(new StructuredHtmlFlavorHandler(textFromClipboard));
                    handlerList.add(new StructuredTextFromHtmlFlavorHandler(textFromClipboard));
                    handlerList.add(new DirectHtmlFlavorHandler(textFromClipboard));
                }
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String plainTextFromClipboard = t.getTransferData(DataFlavor.stringFlavor).toString();
                handlerList.add(new StringFlavorHandler(plainTextFromClipboard));
            }
            catch (UnsupportedFlavorException plainTextFromClipboard) {
            }
            catch (IOException plainTextFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
            try {
                List<File> fileList = this.castToFileList(t.getTransferData(MindMapNodesSelection.fileListFlavor));
                if (fileList != null) {
                    handlerList.add(new FileListFlavorHandler(fileList));
                }
            }
            catch (UnsupportedFlavorException fileList) {
            }
            catch (IOException fileList) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                handlerList.add(new ImageFlavorHandler(image));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return handlerList;
    }

    private DataFlavor getSupportedHtmlFlavor(Transferable t) {
        for (DataFlavor dataFlavor : t.getTransferDataFlavors()) {
            if (!dataFlavor.getPrimaryType().equals(MindMapNodesSelection.htmlFlavor.getPrimaryType()) || !dataFlavor.getSubType().equals(MindMapNodesSelection.htmlFlavor.getSubType()) || !dataFlavor.getRepresentationClass().equals(MindMapNodesSelection.htmlFlavor.getRepresentationClass())) continue;
            return dataFlavor;
        }
        return null;
    }

    public void paste(Transferable t, NodeModel target, NodeModel.Side side) {
        this.paste(t, target, side, 0);
    }

    public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
        if (t == null) {
            return;
        }
        IDataFlavorHandler handler = this.getFlavorHandler(t);
        this.paste(t, handler, target, side, dropAction);
    }

    void paste(Transferable t, IDataFlavorHandler handler, NodeModel target, NodeModel.Side side) {
        this.paste(t, handler, target, side, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paste(Transferable t, IDataFlavorHandler handler, NodeModel target, NodeModel.Side side, int dropAction) {
        if (handler == null) {
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        if (side == NodeModel.Side.AS_SIBLING && !mapController.isWriteable(target.getParentNode()) || side != NodeModel.Side.AS_SIBLING && !mapController.isWriteable(target)) {
            String message = TextUtils.getText((String)"node_is_write_protected");
            UITools.errorMessage((Object)message);
            return;
        }
        Controller controller = Controller.getCurrentController();
        try {
            controller.getViewController().setWaitingCursor(true);
            if (this.newNodes == null) {
                this.newNodes = new LinkedList<NodeModel>();
            }
            boolean hadChildren = target.hasChildren();
            this.newNodes.clear();
            handler.paste(t, target, side, dropAction);
            if (side != NodeModel.Side.AS_SIBLING) {
                if (mapController.isFolded(target)) {
                    if (ResourceController.getResourceController().getBooleanProperty(RESOURCE_UNFOLD_ON_PASTE)) {
                        mapController.unfoldAndScroll(target, controller.getSelection().getFilter());
                    }
                } else if (!hadChildren && !ResourceController.getResourceController().getBooleanProperty(RESOURCE_UNFOLD_ON_PASTE)) {
                    mapController.fold(target);
                }
            }
            for (NodeModel child : this.newNodes) {
                AttributeController.getController().performRegistrySubtreeAttributes(child);
            }
        }
        finally {
            controller.getViewController().setWaitingCursor(false);
        }
    }

    private void pasteStringWithoutRedisplay(TextFragment[] textFragments, NodeModel target, NodeModel.Side side) {
        int insertionIndex;
        NodeModel parent;
        if (side == NodeModel.Side.AS_SIBLING) {
            NodeModel childNode = target;
            parent = target.getParentNode();
            insertionIndex = parent.getIndex(childNode);
        } else {
            parent = target;
            insertionIndex = -1;
        }
        ArrayList<NodeModel> parentNodes = new ArrayList<NodeModel>();
        ArrayList<Integer> parentNodesDepths = new ArrayList<Integer>();
        parentNodes.add(parent);
        parentNodesDepths.add(new Integer(-1));
        for (int i = 0; i < textFragments.length; ++i) {
            NodeModel node;
            TextFragment textFragment = textFragments[i];
            if (textFragment.isNode()) {
                insertionIndex = this.addNode(parent, insertionIndex, parentNodes, parentNodesDepths, textFragment);
                continue;
            }
            if (!textFragment.isAttribute()) continue;
            this.addAttribute(node, textFragment, parent == (node = parentNodes.get(parentNodes.size() - 1)));
        }
        this.insertNewNodes(parent, insertionIndex, side == NodeModel.Side.AS_SIBLING ? target.getSide() : side, parentNodes);
    }

    private void addAttribute(NodeModel node, TextFragment textFragment, boolean toExistingNode) {
        String name = textFragment.text;
        Object value = ScannerController.getController().parse(textFragment.link);
        Attribute atribute = new Attribute(name, value);
        if (toExistingNode) {
            MAttributeController.getController().addAttribute(node, atribute);
        } else {
            NodeAttributeTableModel attributes = (NodeAttributeTableModel)node.getExtension(NodeAttributeTableModel.class);
            if (attributes == null) {
                attributes = new NodeAttributeTableModel();
                node.addExtension((IExtension)attributes);
            }
            attributes.addRowNoUndo(node, atribute);
        }
    }

    private int addNode(NodeModel parent, int insertionIndex, ArrayList<NodeModel> parentNodes, ArrayList<Integer> parentNodesDepths, TextFragment textFragment) {
        MapModel map = parent.getMap();
        NodeModel node = this.createNode(map, textFragment);
        return this.insertNode(parent, insertionIndex, parentNodes, parentNodesDepths, textFragment, node);
    }

    private int insertNode(NodeModel parent, int insertionIndex, ArrayList<NodeModel> parentNodes, ArrayList<Integer> parentNodesDepths, TextFragment textFragment, NodeModel node) {
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        if (insertionIndex == -1) {
            insertionIndex = mapController.findNewNodePosition(parent);
        }
        for (int parentNodeIndex = parentNodes.size() - 1; parentNodeIndex >= 0; --parentNodeIndex) {
            int firstCompletedIndex;
            if (textFragment.depth <= parentNodesDepths.get(parentNodeIndex)) continue;
            for (int completedParentNodeIndex = firstCompletedIndex = parentNodeIndex + 1; completedParentNodeIndex < parentNodes.size(); ++completedParentNodeIndex) {
                NodeModel n = parentNodes.get(completedParentNodeIndex);
                if (n.getParentNode() != null) continue;
                mapController.insertNode(n, parent, insertionIndex++);
            }
            parentNodes.subList(firstCompletedIndex, parentNodes.size()).clear();
            parentNodesDepths.subList(firstCompletedIndex, parentNodesDepths.size()).clear();
            NodeModel target = parentNodes.get(parentNodeIndex);
            if (target != parent) {
                target.setFolded(true);
                target.insert(node, target.getChildCount());
            }
            parentNodes.add(node);
            parentNodesDepths.add(new Integer(textFragment.depth));
            break;
        }
        return insertionIndex;
    }

    private NodeModel createNode(MapModel map, TextFragment textFragment) {
        String text = textFragment.text;
        String link = textFragment.link;
        URI uri = null;
        if (link != null) {
            try {
                URI linkUri;
                uri = linkUri = new URI(link);
                File absoluteFile = UrlManager.getController().getAbsoluteFile(map, uri);
                if (absoluteFile != null) {
                    File mapFile = map.getFile();
                    uri = LinkController.toLinkTypeDependantURI((File)mapFile, (File)absoluteFile);
                    if (link.equals(text)) {
                        text = uri.toString();
                    }
                }
            }
            catch (Exception linkUri) {
                // empty catch block
            }
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        NodeModel node = mapController.newNode(text, map);
        if (uri != null) {
            NodeLinks.createLinkExtension((NodeModel)node).setHyperLink(new Hyperlink(uri));
        }
        return node;
    }

    private void insertNewNodes(NodeModel parent, int insertionIndex, NodeModel.Side side, ArrayList<NodeModel> parentNodes) {
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        MapModel map = parent.getMap();
        for (int k = 0; k < parentNodes.size(); ++k) {
            NodeModel node = parentNodes.get(k);
            if (map.getRootNode() == node || node.getParentNode() != null) continue;
            node.setSide(side);
            mapController.insertNode(node, parent, insertionIndex++);
        }
    }

    public void addClone(Transferable transferable, NodeModel target) {
        this.processTransferable(transferable, target, Operation.CLONE);
    }

    public void move(Transferable transferable, NodeModel target) {
        this.processTransferable(transferable, target, Operation.MOVE);
    }

    private void processTransferable(Transferable transferable, NodeModel target, Operation operation) {
        try {
            boolean asSingleNodes;
            Collection clonedNodes;
            if (operation == Operation.CLONE && transferable.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeSingleObjectsFlavor)) {
                clonedNodes = (Collection)transferable.getTransferData(MindMapNodesSelection.mindMapNodeSingleObjectsFlavor);
                asSingleNodes = true;
            } else if (transferable.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
                clonedNodes = (Collection)transferable.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
                asSingleNodes = false;
            } else {
                return;
            }
            ArrayList<NodeModel> movedNodes = new ArrayList<NodeModel>(clonedNodes.size());
            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
            int newNodePosition = mapController.findNewNodePosition(target);
            for (NodeModel clonedNode : clonedNodes) {
                if (!asSingleNodes && clonedNode.getParentNode() == null || !clonedNode.getMap().equals(target.getMap())) {
                    return;
                }
                if (!asSingleNodes && (clonedNode.isRoot() || clonedNode.subtreeContainsCloneOf(target))) continue;
                switch (operation.ordinal()) {
                    case 0: {
                        try {
                            NodeModel clone = asSingleNodes ? clonedNode.cloneContent() : clonedNode.cloneTree();
                            mapController.addNewNode(clone, target, newNodePosition++);
                        }
                        catch (CloneEncryptedNodeException e) {
                            UITools.errorMessage((Object)TextUtils.getText((String)"can_not_clone_encrypted_node"));
                        }
                        break;
                    }
                    case 1: {
                        movedNodes.add(clonedNode);
                    }
                }
            }
            switch (operation.ordinal()) {
                case 1: {
                    mapController.moveNodesAsChildren(movedNodes, target);
                    break;
                }
            }
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }

    public Transferable getClipboardContents() {
        return ClipboardAccessor.getInstance().getClipboardContents();
    }

    @Override
    public boolean canCut() {
        return true;
    }

    @Override
    public void cut() {
        Controller controller = Controller.getCurrentController();
        NodeModel root = controller.getMap().getRootNode();
        IMapSelection selection = controller.getSelection();
        if (selection.isSelected(root)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_delete_root"));
            return;
        }
        int showResult = OptionalDontShowMeAgainDialog.show((String)"really_cut_node", (String)RESOURCES_CUT_NODES_WITHOUT_QUESTION, (OptionalDontShowMeAgainDialog.MessageType)OptionalDontShowMeAgainDialog.MessageType.ONLY_OK_SELECTION_IS_STORED);
        if (showResult != 0) {
            return;
        }
        this.cut(selection);
        controller.getMapViewManager().obtainFocusForSelected();
    }

    @Override
    public boolean canPaste(Transferable t) {
        return true;
    }

    @Override
    public void paste(ActionEvent event, Transferable t) {
        this.paste(t);
    }

    public void paste(Transferable t) {
        NodeModel parent = Controller.getCurrentController().getSelection().getSelected();
        if (parent != null) {
            this.paste(t, parent);
        }
    }

    public void paste(Transferable t, NodeModel parent) {
        this.paste(t, parent, MapController.suggestNewChildSide((NodeModel)parent, (NodeModel.Side)NodeModel.Side.DEFAULT));
    }

    private String findLink(String string, boolean isHtml) {
        boolean findsEmailsInText = ResourceController.getResourceController().getBooleanProperty(FIND_EMAILS_IN_TEXT_PROPERTY);
        return LinkController.findLink((String)string, (boolean)isHtml, (boolean)findsEmailsInText);
    }

    private static class TextFragment {
        static final int ATTRIBUTE_DEPTH = -2;
        String text;
        String link;
        int depth;

        public TextFragment(String text, String link, int depth) {
            this.text = text;
            this.link = link;
            this.depth = depth;
        }

        boolean isAttribute() {
            return this.depth == -2;
        }

        boolean isNode() {
            return !this.isAttribute();
        }

        public String toString() {
            return "TextFragment [" + this.text + (this.link != null ? " [" + this.link + "]" : "") + "," + this.depth + "]";
        }
    }

    private class MindMapNodesFlavorHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public MindMapNodesFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        @Override
        public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
            if (this.textFromClipboard != null) {
                this.paste(target, side);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paste(NodeModel target, NodeModel.Side side) {
            ArrayList<String> textLines = new ArrayList<String>(Arrays.asList(this.textFromClipboard.split("<nodeseparator>")));
            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
            MapReader mapReader = mapController.getMapReader();
            if (side != NodeModel.Side.AS_SIBLING && mapController.placesNewChildFirst(target)) {
                Collections.reverse(textLines);
            }
            MapReader mapReader2 = mapReader;
            synchronized (mapReader2) {
                MapReader.NodeTreeCreator nodeTreeCreator = mapReader.nodeTreeCreator(target.getMap());
                nodeTreeCreator.setHint((Object)MapWriter.Hint.MODE, (Object)MapWriter.Mode.CLIPBOARD);
                for (int i = 0; i < textLines.size(); ++i) {
                    try {
                        NodeModel newModel = nodeTreeCreator.create((Reader)new StringReader(textLines.get(i)));
                        newModel.removeExtension(FreeNode.class);
                        newModel.setSide(side == NodeModel.Side.AS_SIBLING ? target.getSide() : side);
                        mapController.insertNode(newModel, target, side == NodeModel.Side.AS_SIBLING);
                        continue;
                    }
                    catch (XMLException e) {
                        LogUtils.severe((String)"error on paste", (Throwable)e);
                    }
                }
                nodeTreeCreator.finish(target);
            }
            mapController.balanceFirstGroupNodes(target);
        }
    }

    private class TagSelectionHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public TagSelectionHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        @Override
        public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
            if (this.textFromClipboard != null) {
                Set selection = Controller.getCurrentController().getSelection().getSelection();
                if (selection.contains(target)) {
                    selection.forEach(this::paste);
                } else {
                    this.paste(target);
                }
            }
        }

        private void paste(NodeModel target) {
            ((MIconController)IconController.getController()).addTagsFromSpec(target, this.textFromClipboard);
        }
    }

    private class StructuredHtmlFlavorHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public StructuredHtmlFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        private void addFragment(HTMLDocument doc, Element element, int depth, int start, int end, LinkedList<TextFragment> htmlFragments) throws BadLocationException, IOException {
            String paragraphText = doc.getText(start, end - start).trim();
            if (paragraphText.length() > 0 || element.getName().equals("img")) {
                StringWriter out = new StringWriter();
                new PasteHtmlWriter(out, element, doc, start, end - start).write();
                String string = out.toString();
                if (!string.equals("")) {
                    String link = MMapClipboardController.this.findLink(string, true);
                    TextFragment htmlFragment = this.createNodeTextFragment(depth, string, link);
                    htmlFragments.add(htmlFragment);
                }
            }
        }

        protected TextFragment createNodeTextFragment(int depth, String string, String link) {
            return new TextFragment(string, link, depth);
        }

        private Element getParentElement(HTMLDocument doc) {
            Element bodyElement;
            Element htmlRoot = doc.getDefaultRootElement();
            Element parentCandidate = bodyElement = htmlRoot.getElement(htmlRoot.getElementCount() - 1);
            do {
                if (parentCandidate.getElementCount() <= 1) continue;
                return parentCandidate;
            } while (!(parentCandidate = parentCandidate.getElement(0)).isLeaf() && !parentCandidate.getName().equalsIgnoreCase("p-implied"));
            return bodyElement;
        }

        private boolean isSeparateElement(Element current) {
            return !current.isLeaf();
        }

        @Override
        public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
            this.pasteHtmlWithoutRedisplay(this.textFromClipboard, target, side);
        }

        private void pasteHtmlWithoutRedisplay(Object t, NodeModel parent, NodeModel.Side side) {
            String textFromClipboard = (String)t;
            String cleanedTextFromClipboard = MMapClipboardController.this.cleanHtml(textFromClipboard);
            TextFragment[] htmlFragments = this.split(cleanedTextFromClipboard);
            MMapClipboardController.this.pasteStringWithoutRedisplay(htmlFragments, parent, side);
        }

        private void split(HTMLDocument doc, Element parent, LinkedList<TextFragment> htmlFragments, int depth) throws BadLocationException, IOException {
            int elementCount = parent.getElementCount();
            int headerDepth = 0;
            boolean headerFound = false;
            int start = -1;
            int end = -1;
            Element last = null;
            for (int i = 0; i < elementCount; ++i) {
                boolean separateElement;
                Element current = parent.getElement(i);
                String name = current.getName();
                Matcher matcher = HEADER_REGEX.matcher(name);
                if (matcher.matches()) {
                    try {
                        if (!headerFound) {
                            --depth;
                        }
                        int newHeaderDepth = Integer.parseInt(matcher.group(1));
                        depth += newHeaderDepth - headerDepth;
                        headerDepth = newHeaderDepth;
                        headerFound = true;
                    }
                    catch (NumberFormatException e) {
                        LogUtils.severe((Throwable)e);
                    }
                } else if (headerFound) {
                    headerFound = false;
                    ++depth;
                }
                if ((separateElement = this.isSeparateElement(current)) && current.getElementCount() != 0) {
                    start = -1;
                    last = null;
                    this.split(doc, current, htmlFragments, depth + 1);
                    continue;
                }
                if (separateElement && start != -1) {
                    this.addFragment(doc, last, depth, start, end, htmlFragments);
                }
                if (start == -1 || separateElement) {
                    start = current.getStartOffset();
                    last = current;
                }
                end = current.getEndOffset();
                if (!separateElement) continue;
                this.addFragment(doc, current, depth, start, end, htmlFragments);
            }
            if (start != -1) {
                this.addFragment(doc, last, depth, start, end, htmlFragments);
            }
        }

        private TextFragment[] split(String text) {
            LinkedList<TextFragment> htmlFragments = new LinkedList<TextFragment>();
            SHTMLEditorKit kit = new SHTMLEditorKit();
            SHTMLDocument doc = new SHTMLDocument();
            HtmlProcessor.configureUnknownTags((HTMLDocument)doc);
            StringReader buf = new StringReader(text);
            try {
                kit.read(buf, (Document)doc, 0);
                Element parent = this.getParentElement((HTMLDocument)doc);
                this.split((HTMLDocument)doc, parent, htmlFragments, 0);
            }
            catch (Exception e) {
                LogUtils.severe((Throwable)e);
            }
            return htmlFragments.toArray(new TextFragment[htmlFragments.size()]);
        }
    }

    private class DirectHtmlFlavorHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public DirectHtmlFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        void paste(NodeModel target) {
            String text = MMapClipboardController.this.cleanHtml(this.textFromClipboard);
            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
            NodeModel node = mapController.newNode(text, Controller.getCurrentController().getMap());
            node.setSide(MapController.suggestNewChildSide((NodeModel)target, (NodeModel.Side)NodeModel.Side.DEFAULT));
            mapController.insertNode(node, target);
        }

        @Override
        public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
            this.paste(target);
        }
    }

    private class FileListFlavorHandler
    implements IDataFlavorHandler {
        final ArrayList<File> fileList;

        public FileListFlavorHandler(List<File> fileList) {
            this.fileList = new ArrayList<File>(fileList);
        }

        @Override
        public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
            boolean copyFile = dropAction == 1;
            File mapFile = target.getMap().getFile();
            if ((copyFile || LinkController.getLinkType() == 1) && mapFile == null) {
                JOptionPane.showMessageDialog(Controller.getCurrentController().getViewController().getCurrentRootComponent(), TextUtils.getText((String)"map_not_saved"), "Freeplane", 2);
                return;
            }
            ViewerController viewerController = (ViewerController)Controller.getCurrentModeController().getExtension(ViewerController.class);
            boolean pasteImagesFromFiles = ResourceController.getResourceController().getBooleanProperty("pasteImagesFromFiles");
            NodeModel.Side newChildSide = side == NodeModel.Side.AS_SIBLING ? target.getSide() : side;
            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
            if (side != NodeModel.Side.AS_SIBLING && mapController.placesNewChildFirst(target)) {
                Collections.reverse(this.fileList);
            }
            for (File sourceFile : this.fileList) {
                File file;
                block6: {
                    if (copyFile) {
                        try {
                            file = new TargetFileCreator().createTargetFile(mapFile, sourceFile.getName());
                            file.getParentFile().mkdirs();
                            FileUtils.copyFile((File)sourceFile, (File)file);
                            break block6;
                        }
                        catch (IOException e) {
                            LogUtils.warn((Throwable)e);
                            continue;
                        }
                    }
                    file = sourceFile;
                }
                if (pasteImagesFromFiles && dropAction != 0x40000000 && viewerController.paste(file, target, ViewerController.PasteMode.valueOf((NodeModel.Side)side))) continue;
                NodeModel node = mapController.newNode(file.getName(), target.getMap());
                ((MLinkController)LinkController.getController()).setLinkTypeDependantLink(node, file);
                node.setSide(newChildSide);
                mapController.insertNode(node, target, side == NodeModel.Side.AS_SIBLING);
            }
        }
    }

    private class StringFlavorHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public StringFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        @Override
        public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
            TextFragment[] textFragments = this.split(this.textFromClipboard);
            MMapClipboardController.this.pasteStringWithoutRedisplay(textFragments, target, side);
        }

        private TextFragment[] split(String textFromClipboard) {
            LinkedList<TextFragment> textFragments = new LinkedList<TextFragment>();
            String[] textLines = textFromClipboard.split("\n");
            for (int i = 0; i < textLines.length; ++i) {
                int depth;
                String text = textLines[i];
                Matcher matcher = ATTRIBUTE_REGEX.matcher(text);
                if (matcher.matches()) {
                    textFragments.add(new TextFragment(matcher.group(1), matcher.group(2), -2));
                    continue;
                }
                if ((text = text.replaceAll("\t", "        ")).matches(" *")) continue;
                for (depth = 0; depth < text.length() && text.charAt(depth) == ' '; ++depth) {
                }
                String visibleText = text.trim();
                String link = MMapClipboardController.this.findLink(text, false);
                if (visibleText.equals("")) continue;
                textFragments.add(new TextFragment(visibleText, link, depth));
            }
            return textFragments.toArray(new TextFragment[textFragments.size()]);
        }
    }

    private class ImageFlavorHandler
    implements IDataFlavorHandler {
        private final Image image;

        public ImageFlavorHandler(Image img) {
            this.image = img;
        }

        @Override
        public void paste(Transferable t, NodeModel target, NodeModel.Side side, int dropAction) {
            ModeController modeController = Controller.getCurrentModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            File mindmapFile = target.getMap().getFile();
            if (mindmapFile == null) {
                UITools.errorMessage((Object)TextUtils.getRawText((String)"map_not_saved"));
                return;
            }
            try {
                File imageFile = new TargetFileCreator().createTargetFile(mindmapFile, "png");
                imageFile.getParentFile().mkdirs();
                String imgfilepath = imageFile.getAbsolutePath();
                File tempFile = imageFile = new File(imgfilepath);
                JFileChooser fileChooser = UITools.newFileChooser((File)imageFile);
                CaseSensitiveFileNameExtensionFilter filter = new CaseSensitiveFileNameExtensionFilter();
                filter.addExtension("png");
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setFileFilter((FileFilter)filter);
                fileChooser.setSelectedFile(imageFile);
                int returnVal = fileChooser.showSaveDialog(UITools.getCurrentRootComponent());
                if (returnVal != 0) {
                    tempFile.delete();
                    return;
                }
                imageFile = fileChooser.getSelectedFile();
                if (tempFile.exists() && !imageFile.getAbsoluteFile().equals(tempFile)) {
                    tempFile.delete();
                }
                if (imageFile.isDirectory()) {
                    return;
                }
                if (!FileUtils.getExtension((String)imageFile.getName()).equals("png")) {
                    imageFile = new File(imageFile.getPath() + '.' + "png");
                }
                NodeModel node = mapController.newNode(imageFile.getName(), target.getMap());
                node.setSide(side == NodeModel.Side.AS_SIBLING ? target.getSide() : side);
                mapController.insertNode(node, target, side == NodeModel.Side.AS_SIBLING);
                new ImageAdder(this.image, mapController, mindmapFile, imageFile).attachImageToNode(node);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class StructuredTextFromHtmlFlavorHandler
    extends StructuredHtmlFlavorHandler
    implements IDataFlavorHandler {
        public StructuredTextFromHtmlFlavorHandler(String textFromClipboard) {
            super(textFromClipboard);
        }

        @Override
        protected TextFragment createNodeTextFragment(int depth, String string, String link) {
            return new TextFragment(HtmlUtils.htmlToPlain((String)string, (boolean)true, (boolean)true, (String)""), link, depth);
        }
    }

    static interface IDataFlavorHandler {
        public void paste(Transferable var1, NodeModel var2, NodeModel.Side var3, int var4);
    }

    private static enum Operation {
        CLONE,
        MOVE;

    }

    private static class PasteHtmlWriter
    extends SHTMLWriter {
        private final Element element;

        public PasteHtmlWriter(Writer writer, Element element, HTMLDocument doc, int pos, int len) {
            super(writer, doc, pos, len);
            this.element = this.getStandAloneElement(element);
        }

        protected ElementIterator getElementIterator() {
            return new ElementIterator(this.element);
        }

        private Element getStandAloneElement(Element element) {
            String name = element.getName();
            if (name.equals("ul") || name.equals("ol") || name.equals("table") || name.equals("html")) {
                return element;
            }
            return this.getStandAloneElement(element.getParentElement());
        }

        public void write() throws IOException, BadLocationException {
            if (this.element.getName().equals("html")) {
                super.write();
                return;
            }
            this.write("<html>");
            super.write();
            this.write("</html>");
        }
    }
}

