/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPrefsChangeListener;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.ui.components.html.StyleSheetConfigurer;
import org.freeplane.core.util.HtmlProcessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.note.mindmapmode.NoteManager;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.text.mindmapmode.FreeplaneToSHTMLPropertyChangeAdapter;
import org.freeplane.features.text.mindmapmode.MTextController;

class NotePanel
extends JPanel {
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    static final Pattern HEAD = Pattern.compile("<head>.*</head>\n", 32);
    private static final long serialVersionUID = 1L;
    private final SHTMLPanel htmlEditorPanel;
    private final JScrollPane viewerScrollPanel;
    private final JEditorPane htmlViewerPanel;
    private final JLabel iconViewerPanel;
    private final Color defaultCaretColor;
    private final MNoteController.NoteDocumentListener noteDocumentListener;
    private final NoteManager noteManager;
    private final StyleSheet ownStyleSheet;
    private FocusListener textPanelFocusListener;
    private boolean isEditing = false;

    NotePanel(NoteManager noteManager, MNoteController.NoteDocumentListener noteDocumentListener) {
        super(new CardLayout());
        this.noteManager = noteManager;
        this.noteDocumentListener = noteDocumentListener;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.htmlEditorPanel = this.createHtmlEditorComponent(noteManager);
        this.ownStyleSheet = StyleSheetConfigurer.createDefaultStyleSheet();
        this.defaultCaretColor = this.htmlEditorPanel.getEditorPane().getCaretColor();
        this.htmlEditorPanel.setVisible(false);
        this.add((Component)this.htmlEditorPanel);
        this.viewerScrollPanel = new JScrollPane(22, 32);
        this.viewerScrollPanel.setVisible(false);
        this.add(this.viewerScrollPanel);
        this.htmlViewerPanel = new JEditorPane();
        this.htmlViewerPanel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.htmlViewerPanel.setOpaque(true);
        this.htmlViewerPanel.setEditable(false);
        this.htmlViewerPanel.setEditorKitForContentType(CONTENT_TYPE_TEXT_HTML, (EditorKit)ScaledEditorKit.create());
        this.iconViewerPanel = new JLabel();
        this.iconViewerPanel.setVerticalAlignment(1);
        MouseAdapter editStarter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NotePanel.this.editNote();
                }
            }
        };
        this.htmlViewerPanel.addMouseListener(editStarter);
        this.iconViewerPanel.addMouseListener(editStarter);
        ResourceController.getResourceController().setProperty("use_split_pane", "true");
    }

    private SHTMLPanel createHtmlEditorComponent(final NoteManager noteManager) {
        SHTMLPanel htmlEditorPanel = MTextController.getController().createSHTMLPanel("Note");
        htmlEditorPanel.shtmlPrefChanged("show_toolbars", ResourceController.getResourceController().getProperty("simplyhtml.note.show_toolbars"), ResourceController.getResourceController().getProperty("simplyhtml.show_toolbars"));
        htmlEditorPanel.shtmlPrefChanged("show_menu", ResourceController.getResourceController().getProperty("simplyhtml.note.show_menu"), ResourceController.getResourceController().getProperty("simplyhtml.show_menu"));
        ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)new FreeplaneToSHTMLPropertyChangeAdapter("simplyhtml.", (SHTMLPrefsChangeListener)htmlEditorPanel));
        ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)new FreeplaneToSHTMLPropertyChangeAdapter("simplyhtml.note.", (SHTMLPrefsChangeListener)htmlEditorPanel));
        htmlEditorPanel.setMinimumSize(new Dimension(100, 100));
        final SHTMLEditorPane editorPane = (SHTMLEditorPane)htmlEditorPanel.getEditorPane();
        for (InputMap inputMap = editorPane.getInputMap(); inputMap != null; inputMap = inputMap.getParent()) {
            inputMap.remove(KeyStroke.getKeyStroke("ctrl pressed T"));
            inputMap.remove(KeyStroke.getKeyStroke("ctrl shift pressed T"));
            inputMap.remove(KeyStroke.getKeyStroke("ctrl pressed SPACE"));
        }
        editorPane.addFocusListener(new FocusListener(){
            private SpellCheckerController spellCheckerController = null;
            private boolean enabled = false;

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    this.spellCheckerController.enableAutoSpell((JTextComponent)editorPane, false);
                    this.enabled = false;
                    noteManager.saveNote();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!this.enabled) {
                    this.initSpellChecker();
                    this.spellCheckerController.enableAutoSpell((JTextComponent)editorPane, true);
                    this.enabled = true;
                }
            }

            private void initSpellChecker() {
                if (this.spellCheckerController != null) {
                    return;
                }
                this.spellCheckerController = SpellCheckerController.getController();
                this.spellCheckerController.addSpellCheckerMenu(editorPane.getPopup());
                this.spellCheckerController.enableShortKey((JTextComponent)editorPane, true);
            }
        });
        this.textPanelFocusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!NotePanel.this.isEditing) {
                    return;
                }
                Component oppositeComponent = e.getOppositeComponent();
                if (oppositeComponent == null) {
                    return;
                }
                if (oppositeComponent.getClass().equals(JRootPane.class)) {
                    return;
                }
                if (SwingUtilities.getWindowAncestor(oppositeComponent) instanceof JFrame) {
                    noteManager.saveNote();
                    noteManager.updateEditor();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        htmlEditorPanel.setOpenHyperlinkHandler(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                try {
                    String uriText = pE.getActionCommand();
                    LinkController.getController().loadURI(noteManager.getNode(), LinkController.createHyperlink((String)uriText));
                }
                catch (Exception e) {
                    LogUtils.severe((Throwable)e);
                }
            }
        });
        return htmlEditorPanel;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        if (o != super.getComponentOrientation()) {
            this.htmlEditorPanel.getEditorPane().setComponentOrientation(o);
            this.htmlViewerPanel.setComponentOrientation(o);
            this.iconViewerPanel.setComponentOrientation(o);
            super.setComponentOrientation(o);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return super.processKeyBinding(ks, e, condition, pressed) || e.getKeyChar() == ' ' || e.getKeyChar() == '\u0012';
    }

    private HTMLDocument getDocument() {
        Document document;
        if (this.htmlEditorPanel.isVisible()) {
            return this.htmlEditorPanel.getDocument();
        }
        if (this.htmlViewerPanel.isVisible() && (document = this.htmlViewerPanel.getDocument()) instanceof HTMLDocument) {
            return (HTMLDocument)document;
        }
        return new HTMLDocument();
    }

    private JComponent getMostRecentFocusOwner() {
        if (this.htmlEditorPanel.isVisible()) {
            return this.htmlEditorPanel.getMostRecentFocusOwner();
        }
        if (this.htmlViewerPanel.isVisible()) {
            return this.htmlViewerPanel;
        }
        if (this.iconViewerPanel.isVisible()) {
            return this.iconViewerPanel;
        }
        return null;
    }

    private boolean needsSaving() {
        if (this.htmlEditorPanel.isVisible() && this.htmlEditorPanel.needsSaving()) {
            return true;
        }
        if (this.viewerScrollPanel.isVisible()) {
            Component view = this.viewerScrollPanel.getViewport().getView();
            if (view instanceof JTextComponent) {
                return ((JTextComponent)view).isEditable();
            }
            return false;
        }
        return false;
    }

    void setEditedContent(String note, String ownRule, StyleSheet customStyleSheet, Color foreground, Color background) {
        this.isEditing = true;
        this.setVisible((JComponent)this.htmlEditorPanel);
        this.htmlEditorPanel.setCurrentDocumentContent("");
        this.updateStyleSheet(ownRule, customStyleSheet);
        this.updateColors(foreground, background);
        HtmlProcessor.configureUnknownTags((HTMLDocument)this.htmlEditorPanel.getDocument());
        this.htmlEditorPanel.setCurrentDocumentContent(note);
        if (note.isEmpty()) {
            JEditorPane editorPane = this.htmlEditorPanel.getEditorPane();
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        }
    }

    void removeViewedContent() {
        this.setVisible(this.htmlViewerPanel);
        String contentType = CONTENT_TYPE_TEXT_PLAIN;
        this.htmlViewerPanel.setText("");
        if (!this.htmlViewerPanel.getContentType().equals(contentType)) {
            this.htmlViewerPanel.setContentType(contentType);
        }
    }

    void setViewedContent(String note, String ownRule, StyleSheet customStyleSheet, Color foreground, Color background) {
        this.setVisible(this.htmlViewerPanel);
        String contentType = HtmlUtils.isHtml((String)note) ? CONTENT_TYPE_TEXT_HTML : CONTENT_TYPE_TEXT_PLAIN;
        this.htmlViewerPanel.setText("");
        if (!this.htmlViewerPanel.getContentType().equals(contentType)) {
            this.htmlViewerPanel.setContentType(contentType);
        }
        if (contentType == CONTENT_TYPE_TEXT_HTML) {
            HtmlProcessor.configureUnknownTags((HTMLDocument)((HTMLDocument)this.htmlViewerPanel.getDocument()));
            this.updateStyleSheet(ownRule, customStyleSheet);
        }
        this.updateColors(foreground, background);
        this.htmlViewerPanel.setText(note);
        if (note.isEmpty()) {
            this.htmlViewerPanel.putClientProperty("JEditorPane.honorDisplayProperties", false);
            this.htmlViewerPanel.putClientProperty("JEditorPane.honorDisplayProperties", true);
        }
    }

    void setViewedImage(Icon icon, HorizontalTextAlignment alignment) {
        this.setVisible(this.iconViewerPanel);
        this.iconViewerPanel.setIcon(icon);
        this.iconViewerPanel.setHorizontalAlignment(alignment.swingConstant);
    }

    private void setVisible(JComponent component) {
        this.htmlEditorPanel.setVisible(component == this.htmlEditorPanel);
        this.viewerScrollPanel.setVisible(component != this.htmlEditorPanel);
        this.htmlViewerPanel.setVisible(component == this.htmlViewerPanel);
        this.iconViewerPanel.setVisible(component == this.iconViewerPanel);
        if (!this.htmlEditorPanel.isVisible()) {
            this.htmlEditorPanel.setCurrentDocumentContent("");
        }
        if (this.htmlViewerPanel.isVisible()) {
            this.setViewerComponent(this.htmlViewerPanel);
        } else {
            this.htmlViewerPanel.setText("");
        }
        if (this.iconViewerPanel.isVisible()) {
            this.setViewerComponent(this.iconViewerPanel);
        } else {
            this.iconViewerPanel.setIcon(null);
        }
        this.revalidate();
    }

    private String getDocumentText() {
        Component view;
        if (this.htmlEditorPanel.isVisible()) {
            return this.htmlEditorPanel.getDocumentText();
        }
        if (this.viewerScrollPanel.isVisible() && (view = this.viewerScrollPanel.getViewport().getView()) instanceof JTextComponent) {
            return ((JTextComponent)view).getText();
        }
        return "";
    }

    private JEditorPane getEditorPane() {
        if (this.htmlEditorPanel.isVisible()) {
            return this.htmlEditorPanel.getMostRecentFocusOwner();
        }
        return this.htmlViewerPanel;
    }

    private void updateColors(Color noteForeground, Color noteBackground) {
        Color caretColor = noteForeground != null ? noteForeground : this.defaultCaretColor;
        JEditorPane editorPane = this.htmlEditorPanel.isVisible() ? this.htmlEditorPanel.getEditorPane() : this.htmlViewerPanel;
        editorPane.setCaretColor(caretColor);
        editorPane.setForeground(noteForeground);
        editorPane.setBackground(noteBackground);
    }

    private void updateStyleSheet(String ownRule, StyleSheet customStyleSheet) {
        HTMLDocument document = this.getDocument();
        StyleSheet styleSheet = document.getStyleSheet();
        StyleSheetConfigurer.resetStyles((StyleSheet)styleSheet, (int)1);
        this.ownStyleSheet.removeStyle("body");
        this.ownStyleSheet.removeStyle("p");
        this.ownStyleSheet.addRule(ownRule);
        styleSheet.addStyleSheet(this.ownStyleSheet);
        styleSheet.addStyleSheet(customStyleSheet);
    }

    void removeDocumentListener() {
        if (this.htmlEditorPanel.isVisible()) {
            this.htmlEditorPanel.getDocument().removeDocumentListener(this.noteDocumentListener);
        }
    }

    private void requestFocusInEditorPane() {
        if (ResourceController.getResourceController().getBooleanProperty("goto_note_end_on_edit")) {
            JEditorPane editorPane = this.getEditorPane();
            editorPane.setCaretPosition(editorPane.getDocument().getLength());
        }
        this.getMostRecentFocusOwner().requestFocus();
    }

    void installDocumentListener() {
        if (this.htmlEditorPanel.isVisible()) {
            this.htmlEditorPanel.getDocument().addDocumentListener(this.noteDocumentListener);
        }
    }

    void updateBaseUrl(URL url) {
        try {
            HTMLDocument document = this.getDocument();
            if (url != null) {
                document.setBase(url);
            } else {
                document.setBase(new URL("file: "));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void editNote() {
        if (this.htmlEditorPanel.isVisible()) {
            this.requestFocusInEditorPane();
            return;
        }
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return;
        }
        NodeModel node = selection.getSelected();
        if (node != null) {
            NoteModel note = NoteModel.getNote((NodeModel)node);
            if (note == null) {
                note = new NoteModel();
            }
            final Component view = this.viewerScrollPanel.getViewport().getView();
            JEditorPane textPane = MTextController.getController().createEditorPane(() -> this.viewerScrollPanel, node, note, note.getTextOr(""));
            if (textPane != null) {
                textPane.requestFocus();
                textPane.addFocusListener(this.textPanelFocusListener);
                textPane.getDocument().addDocumentListener(this.noteDocumentListener);
                textPane.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        if (e.getKeyCode() == 27) {
                            NotePanel.this.isEditing = false;
                        }
                        NotePanel.this.setViewerComponent(view);
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                });
                this.isEditing = true;
            }
        }
    }

    private void setViewerComponent(Component view) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (this.isEditing && focusOwner instanceof JTextComponent && ((JTextComponent)focusOwner).isEditable() && SwingUtilities.isDescendingFrom(focusOwner, this)) {
            return;
        }
        this.isEditing = false;
        this.viewerScrollPanel.setViewportView(view);
        if (this.viewerScrollPanel.getRowHeader() != null) {
            this.viewerScrollPanel.setRowHeader(null);
        }
    }

    void saveNote() {
        if (!this.needsSaving()) {
            return;
        }
        String documentText = this.getDocumentText();
        String text = HtmlUtils.isHtml((String)documentText) ? HEAD.matcher(documentText).replaceFirst("") : documentText;
        this.noteManager.saveNote(text);
    }

    void stopEditing() {
        this.isEditing = false;
    }
}

