/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.mindmapmode;

import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.bugfix.MapElementRemovingWorkaround;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.UndoEnabler;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.ui.components.html.StyleSheetConfigurer;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlProcessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EventBuffer;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.ZoomableLabelUI;
import org.freeplane.view.swing.map.mindmapmode.CharacterColorAction;
import org.freeplane.view.swing.map.mindmapmode.ExtendedEditorKit;

public class EditNodeTextField
extends EditNodeBase {
    private int extraWidth;
    private final boolean layoutMapOnTextChange;
    private static final int SPLIT_KEY_CODE;
    private JEditorPane textfield;
    private final InputMethodInUseListener inputMethodInUseListener;
    private final DocumentListener documentListener;
    private int maxWidth;
    private final ZoomableLabel parent;
    private NodeView nodeView;
    private Font font;
    private float zoom;
    private final DefaultEditorKit.PasteAction pasteAction;
    private final StyledEditorKit.BoldAction boldAction;
    private final StyledEditorKit.ItalicAction italicAction;
    private final StyledEditorKit.UnderlineAction underlineAction;
    private final CharacterColorAction redAction;
    private final CharacterColorAction greenAction;
    private final CharacterColorAction blueAction;
    private final CharacterColorAction blackAction;
    private final StyledEditorKit.StyledTextAction defaultColorAction;
    private final CharacterColorAction redHighlightAction;
    private final CharacterColorAction greenHighlightAction;
    private final CharacterColorAction blueHighlightAction;
    private final CharacterColorAction yellowHighlightAction;
    private final StyledEditorKit.StyledTextAction removeHighlightAction;
    private StyledEditorKit.StyledTextAction removeFormattingAction;
    private int verticalSpace;
    private int horizontalSpace;
    private MapViewChangeListener mapViewChangeListener;

    private void layout() {
        if (this.textfield == null) {
            return;
        }
        int lastWidth = this.textfield.getWidth();
        int lastHeight = this.textfield.getHeight();
        boolean lineWrap = lastWidth == this.maxWidth;
        Dimension preferredSize = this.textfield.getPreferredSize();
        if (!lineWrap) {
            ++preferredSize.width;
            if (preferredSize.width > this.maxWidth) {
                this.setLineWrap();
                preferredSize = this.textfield.getPreferredSize();
            } else if (preferredSize.width < lastWidth) {
                preferredSize.width = lastWidth;
            } else {
                preferredSize.width = Math.min(preferredSize.width + this.extraWidth, this.maxWidth);
                if (preferredSize.width == this.maxWidth) {
                    this.setLineWrap();
                }
            }
        } else {
            preferredSize.width = Math.max(this.maxWidth, preferredSize.width);
        }
        if (preferredSize.width != lastWidth) {
            preferredSize.height = lastHeight;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditNodeTextField.this.layout();
                }
            });
        } else {
            preferredSize.height = Math.max(preferredSize.height, lastHeight);
        }
        if (preferredSize.width == lastWidth && preferredSize.height == lastHeight) {
            this.textfield.repaint();
            return;
        }
        this.textfield.setSize(preferredSize);
        if (this.layoutMapOnTextChange) {
            this.parent.setPreferredSize(new Dimension(preferredSize.width + this.horizontalSpace, preferredSize.height + this.verticalSpace));
        }
        this.textfield.revalidate();
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, (Component)this.parent);
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, (Component)nodeView);
        if (mapView == null) {
            return;
        }
        if (this.layoutMapOnTextChange) {
            mapView.scrollNodeToVisible(nodeView);
        } else {
            mapView.scrollRectToVisible(this.textfield.getBounds());
        }
    }

    private void setLineWrap() {
        if (null != this.textfield.getClientProperty("EditNodeTextField.linewrap") || this.inputMethodInUseListener.isIMEInUse()) {
            return;
        }
        HTMLDocument document = (HTMLDocument)this.textfield.getDocument();
        document.getStyleSheet().addRule("body { width: " + (this.maxWidth - 1) + "}");
        this.textfield.setEditable(false);
        this.textfield.setEditable(true);
        this.textfield.putClientProperty("EditNodeTextField.linewrap", true);
    }

    public EditNodeTextField(NodeModel node, ZoomableLabel parent, String text, EditNodeBase.IEditControl editControl) {
        super(node, text, true, editControl);
        this.parent = parent;
        this.layoutMapOnTextChange = ResourceController.getResourceController().getBooleanProperty("layout_map_on_text_change");
        this.documentListener = new MyDocumentListener();
        this.pasteAction = new DefaultEditorKit.PasteAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent target = this.getTextComponent(e);
                if (target == null) {
                    return;
                }
                Transferable contents = ClipboardAccessor.getInstance().getClipboardContents();
                if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                        target.replaceSelection(text);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.boldAction = new StyledEditorKit.BoldAction();
        this.boldAction.putValue("Name", TextUtils.getText((String)"BoldAction.text"));
        this.boldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control B"));
        this.italicAction = new StyledEditorKit.ItalicAction();
        this.italicAction.putValue("Name", TextUtils.getText((String)"ItalicAction.text"));
        this.italicAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control I"));
        this.underlineAction = new StyledEditorKit.UnderlineAction();
        this.underlineAction.putValue("Name", TextUtils.getText((String)"UnderlineAction.text"));
        this.underlineAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control U"));
        this.redAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.redFontColorLabel"), CSS.Attribute.COLOR, SHTMLPanel.DARK_RED, SHTMLPanel.LIGHT_RED);
        this.redAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control R"));
        this.greenAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.greenFontColorLabel"), CSS.Attribute.COLOR, SHTMLPanel.DARK_GREEN, SHTMLPanel.LIGHT_GREEN);
        this.greenAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control G"));
        this.blueAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.blueFontColorLabel"), CSS.Attribute.COLOR, SHTMLPanel.DARK_BLUE, SHTMLPanel.LIGHT_BLUE);
        this.blueAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control L"));
        this.blackAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.blackFontColorLabel"), CSS.Attribute.COLOR, Color.BLACK, Color.WHITE);
        this.blackAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control K"));
        this.defaultColorAction = new ExtendedEditorKit.RemoveStyleAttributeAction(CSS.Attribute.COLOR, TextUtils.getText((String)"simplyhtml.removeFontColorLabel"));
        this.defaultColorAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
        this.redHighlightAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.redHighlightColorLabel"), CSS.Attribute.BACKGROUND_COLOR, SHTMLPanel.LIGHT_RED.brighter(), SHTMLPanel.DARK_RED.darker());
        this.redHighlightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift R"));
        this.greenHighlightAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.greenHighlightColorLabel"), CSS.Attribute.BACKGROUND_COLOR, SHTMLPanel.LIGHT_GREEN.brighter(), SHTMLPanel.DARK_GREEN.darker());
        this.greenHighlightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift G"));
        this.blueHighlightAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.blueHighlightColorLabel"), CSS.Attribute.BACKGROUND_COLOR, SHTMLPanel.LIGHT_BLUE.brighter(), SHTMLPanel.LIGHT_BLUE.darker());
        this.blueHighlightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift L"));
        this.yellowHighlightAction = new CharacterColorAction(TextUtils.getText((String)"simplyhtml.yellowHighlightColorLabel"), CSS.Attribute.BACKGROUND_COLOR, Color.YELLOW, Color.ORANGE.darker());
        this.yellowHighlightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift Y"));
        this.removeHighlightAction = new ExtendedEditorKit.RemoveStyleAttributeAction(CSS.Attribute.BACKGROUND_COLOR, TextUtils.getText((String)"simplyhtml.removeHighlightColorLabel"));
        this.removeHighlightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift D"));
        this.removeFormattingAction = new ExtendedEditorKit.RemoveStyleAttributeAction(null, TextUtils.getText((String)"simplyhtml.clearFormatLabel"));
        this.removeFormattingAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control T"));
        this.inputMethodInUseListener = new InputMethodInUseListener();
        if (editControl != null) {
            ModeController modeController = Controller.getCurrentModeController();
            MTextController textController = (MTextController)TextController.getController((ModeController)modeController);
            this.textfield = textController.createEditorPane("NodeText");
            this.textfield.setNavigationFilter(new MyNavigationFilter(this.textfield));
            this.textfield.addInputMethodListener(this.inputMethodInUseListener);
        }
    }

    public String getNewText() {
        SHTMLWriter shtmlWriter = new SHTMLWriter((HTMLDocument)this.textfield.getDocument());
        try {
            shtmlWriter.write();
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
        return shtmlWriter.toString();
    }

    private void hideMe() {
        if (this.textfield == null) {
            return;
        }
        ModeController modeController = this.nodeView.getMap().getModeController();
        modeController.setBlocked(false);
        ((MTextController)modeController.getExtension(TextController.class)).unsetCurrentBlockingEditor(this);
        JEditorPane textfield = this.textfield;
        this.textfield = null;
        textfield.getDocument().removeDocumentListener(this.documentListener);
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        mapViewManager.removeMapViewChangeListener((IMapViewChangeListener)this.mapViewChangeListener);
        this.mapViewChangeListener = null;
        this.parent.setPreferredSize(null);
        if (this.nodeView.isShowing()) {
            this.nodeView.update();
            this.preserveRootNodeLocationOnScreen();
        }
        Dimension textFieldSize = textfield.getSize();
        Point textFieldCoordinate = new Point();
        MapView mapView = this.nodeView.getMap();
        UITools.convertPointToAncestor((Component)textfield, (Point)textFieldCoordinate, (Component)mapView);
        Container textFieldParentComponent = textfield.getParent();
        if (textFieldParentComponent != null) {
            textFieldParentComponent.remove(textfield);
        }
        mapView.onEditingFinished(this.parent);
        this.parent.revalidate();
        this.parent.repaint();
        mapView.repaint(textFieldCoordinate.x, textFieldCoordinate.y, textFieldSize.width, textFieldSize.height);
    }

    @Override
    protected JPopupMenu createPopupMenu(JComponent component) {
        Action redoAction;
        JPopupMenu menu = super.createPopupMenu(component);
        Action undoAction = component.getActionMap().get("Undo");
        if (undoAction != null) {
            menu.add(undoAction);
        }
        if ((redoAction = component.getActionMap().get("Redo")) != null) {
            menu.add(redoAction);
        }
        JMenu formatMenu = new JMenu(TextUtils.getText((String)"simplyhtml.formatLabel"));
        menu.add(formatMenu);
        if (this.textfield.getSelectionStart() == this.textfield.getSelectionEnd()) {
            formatMenu.setEnabled(false);
            return menu;
        }
        formatMenu.add(this.boldAction);
        formatMenu.add(this.italicAction);
        formatMenu.add(this.underlineAction);
        formatMenu.add(this.redAction);
        formatMenu.add(this.greenAction);
        formatMenu.add(this.blueAction);
        formatMenu.add(this.blackAction);
        formatMenu.add(this.defaultColorAction);
        formatMenu.add(this.redHighlightAction);
        formatMenu.add(this.greenHighlightAction);
        formatMenu.add(this.blueHighlightAction);
        formatMenu.add(this.yellowHighlightAction);
        formatMenu.add(this.removeHighlightAction);
        formatMenu.add(this.removeFormattingAction);
        return menu;
    }

    @Override
    public void show(Window window) {
        MouseEvent mouseEvent;
        MouseEvent currentEvent;
        Icon icon;
        ModeController modeController = Controller.getCurrentModeController();
        IMapViewManager viewController = modeController.getController().getMapViewManager();
        MTextController textController = (MTextController)TextController.getController((ModeController)modeController);
        this.nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, (Component)this.parent);
        this.font = this.parent.getFont();
        this.zoom = viewController.getZoom();
        if (this.zoom != 1.0f) {
            float fontSize = (int)Math.rint((float)this.font.getSize() * this.zoom);
            this.font = this.font.deriveFont(fontSize);
        }
        ScaledEditorKit kit = new ScaledEditorKit(){

            public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
                if (doc instanceof HTMLDocument) {
                    SHTMLWriter w = new SHTMLWriter(out, (HTMLDocument)doc, pos, len);
                    w.write();
                } else {
                    super.write(out, doc, pos, len);
                }
            }
        };
        this.textfield.setEditorKit((EditorKit)kit);
        this.textfield.setComponentOrientation(this.nodeView.getMainView().getComponentOrientation());
        InputMap inputMap = this.textfield.getInputMap();
        ActionMap actionMap = this.textfield.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "ignore-insert-tab");
        inputMap.put(KeyStroke.getKeyStroke('\t'), "ignore-insert-tab");
        actionMap.put("paste-from-clipboard", this.pasteAction);
        inputMap.put((KeyStroke)this.boldAction.getValue("AcceleratorKey"), "boldAction");
        actionMap.put("boldAction", this.boldAction);
        inputMap.put((KeyStroke)this.italicAction.getValue("AcceleratorKey"), "italicAction");
        actionMap.put("italicAction", this.italicAction);
        inputMap.put((KeyStroke)this.underlineAction.getValue("AcceleratorKey"), "underlineAction");
        actionMap.put("underlineAction", this.underlineAction);
        inputMap.put((KeyStroke)this.redAction.getValue("AcceleratorKey"), "redAction");
        actionMap.put("redAction", this.redAction);
        inputMap.put((KeyStroke)this.greenAction.getValue("AcceleratorKey"), "greenAction");
        actionMap.put("greenAction", this.greenAction);
        inputMap.put((KeyStroke)this.blueAction.getValue("AcceleratorKey"), "blueAction");
        actionMap.put("blueAction", this.blueAction);
        inputMap.put((KeyStroke)this.blackAction.getValue("AcceleratorKey"), "blackAction");
        actionMap.put("blackAction", this.blackAction);
        inputMap.put((KeyStroke)this.defaultColorAction.getValue("AcceleratorKey"), "defaultColorAction");
        actionMap.put("defaultColorAction", this.defaultColorAction);
        inputMap.put((KeyStroke)this.redHighlightAction.getValue("AcceleratorKey"), "redHighlightAction");
        actionMap.put("redHighlightAction", this.redHighlightAction);
        inputMap.put((KeyStroke)this.greenHighlightAction.getValue("AcceleratorKey"), "greenHighlightAction");
        actionMap.put("greenHighlightAction", this.greenHighlightAction);
        inputMap.put((KeyStroke)this.blueHighlightAction.getValue("AcceleratorKey"), "blueHighlightAction");
        actionMap.put("blueHighlightAction", this.blueHighlightAction);
        inputMap.put((KeyStroke)this.yellowHighlightAction.getValue("AcceleratorKey"), "yellowHighlightAction");
        actionMap.put("yellowHighlightAction", this.yellowHighlightAction);
        inputMap.put((KeyStroke)this.removeHighlightAction.getValue("AcceleratorKey"), "removeHighlightAction");
        actionMap.put("removeHighlightAction", this.removeHighlightAction);
        inputMap.put((KeyStroke)this.removeFormattingAction.getValue("AcceleratorKey"), "removeFormattingAction");
        actionMap.put("removeFormattingAction", this.removeFormattingAction);
        Color nodeTextColor = this.parent.getUnselectedForeground();
        this.textfield.setCaretColor(nodeTextColor);
        StringBuilder ruleBuilder = new StringBuilder(100);
        ruleBuilder.append("body {");
        int labelHorizontalAlignment = this.parent.getHorizontalAlignment();
        ruleBuilder.append(new CssRuleBuilder().withCSSFont(this.font, UITools.FONT_SCALE_FACTOR).withColor(nodeTextColor).withBackground(this.getBackground()).withAlignment(labelHorizontalAlignment));
        ruleBuilder.append("}\n");
        HTMLDocument document = (HTMLDocument)this.textfield.getDocument();
        StyleSheet styleSheet = document.getStyleSheet();
        StyleSheet ownStyleSheet = StyleSheetConfigurer.createDefaultStyleSheet();
        ownStyleSheet.addRule(ruleBuilder.toString());
        styleSheet.addStyleSheet(ownStyleSheet);
        styleSheet.addStyleSheet(this.parent.getStyleSheet());
        MapElementRemovingWorkaround.removeAllMapElements((HTMLDocument)document);
        HtmlProcessor.configureUnknownTags((HTMLDocument)document);
        this.textfield.setText(this.getText());
        UndoEnabler.addUndoRedoFunctionality((JTextComponent)this.textfield);
        MapView mapView = this.nodeView.getMap();
        if (!mapView.isValid()) {
            mapView.validate();
        }
        NodeStyleController nsc = NodeStyleController.getController((ModeController)modeController);
        this.maxWidth = Math.max(mapView.getLayoutSpecificMaxNodeWidth(), Math.max(mapView.getZoomed(nsc.getMaxWidth(this.node, this.nodeView.getStyleOption()).toBaseUnitsRounded()), this.parent.getWidth()));
        boolean isTextPlacedUnderIcon = this.parent.getVerticalTextPosition() == 3;
        int reservedIconSpace = 0;
        if (!isTextPlacedUnderIcon && (icon = this.parent.getIcon()) != null) {
            reservedIconSpace = mapView.getZoomed(icon.getIconWidth() + this.parent.getIconTextGap());
            this.maxWidth -= reservedIconSpace;
        }
        Insets parentInsets = this.parent.getZoomedInsets();
        this.maxWidth -= parentInsets.left + parentInsets.right;
        this.extraWidth = ResourceController.getResourceController().getIntProperty("editor_extra_width", 80);
        this.extraWidth = mapView.getZoomed(this.extraWidth);
        TextFieldListener textFieldListener = new TextFieldListener();
        this.textFieldListener = textFieldListener;
        this.textfield.addFocusListener(textFieldListener);
        this.textfield.addKeyListener(textFieldListener);
        this.textfield.addMouseListener(textFieldListener);
        this.mapViewChangeListener = new MapViewChangeListener();
        Controller.getCurrentController().getMapViewManager().addMapViewChangeListener((IMapViewChangeListener)this.mapViewChangeListener);
        SpellCheckerController.getController().enableAutoSpell(this.textfield, true);
        mapView.scrollNodeToVisible(this.nodeView);
        assert (this.parent.isValid());
        int textFieldBorderWidth = 2;
        this.textfield.setBorder(new MatteBorder(2, 2, 2, 2, MapView.drawsRectangleForSelection() ? MapView.getSelectionRectangleColor() : this.nodeView.getTextBackground()));
        Dimension textFieldMinimumSize = this.textfield.getPreferredSize();
        textFieldMinimumSize.width = 1 + textFieldMinimumSize.width * 21 / 20;
        if (textFieldMinimumSize.width < this.extraWidth) {
            textFieldMinimumSize.width = this.extraWidth;
        }
        int minWidth = mapView.getZoomed(10);
        this.maxWidth = Math.max(this.maxWidth, minWidth);
        if (textFieldMinimumSize.width < minWidth) {
            textFieldMinimumSize.width = minWidth;
        }
        if (textFieldMinimumSize.width > this.maxWidth) {
            textFieldMinimumSize.width = this.maxWidth;
            this.setLineWrap();
            textFieldMinimumSize.height = this.textfield.getPreferredSize().height;
        }
        EventBuffer eventQueue = MTextController.getController().getEventQueue();
        KeyEvent firstEvent = eventQueue.getFirstEvent();
        ZoomableLabelUI parentUI = (ZoomableLabelUI)this.parent.getUI();
        ZoomableLabelUI.LayoutData layoutData = parentUI.getLayoutData(this.parent);
        Rectangle textR = layoutData.textR;
        Rectangle viewR = layoutData.viewR;
        Point mouseEventPoint = null;
        if (firstEvent == null && (currentEvent = eventQueue.getMouseEvent()) != null && (mouseEvent = currentEvent).getComponent().equals(this.parent)) {
            mouseEventPoint = mouseEvent.getPoint();
            mouseEventPoint.x -= textR.x;
            mouseEventPoint.y -= textR.y;
        }
        int textFieldX = parentInsets.left - 2;
        if (this.parent.getEffectiveHorizontalTextPosition() == 4) {
            textFieldX += reservedIconSpace;
        }
        int textFieldY = (isTextPlacedUnderIcon ? textR.y : viewR.y) - 2;
        textFieldMinimumSize.width = Math.max(textFieldMinimumSize.width, isTextPlacedUnderIcon ? viewR.width : viewR.width - reservedIconSpace);
        textFieldMinimumSize.height = Math.max(textFieldMinimumSize.height, isTextPlacedUnderIcon ? textR.height : viewR.height);
        this.textfield.setSize(textFieldMinimumSize.width, textFieldMinimumSize.height);
        this.verticalSpace = Math.max(textFieldY, this.parent.getHeight() - textFieldMinimumSize.height);
        Dimension newParentSize = new Dimension(textFieldX + textFieldMinimumSize.width + parentInsets.right, this.verticalSpace + textFieldMinimumSize.height);
        if (this.parent.getEffectiveHorizontalTextPosition() == 2) {
            newParentSize.width += reservedIconSpace;
        }
        this.horizontalSpace = newParentSize.width - textFieldMinimumSize.width;
        Point location = new Point(textFieldX, textFieldY);
        int widthAddedToTextField = textFieldMinimumSize.width - (textR.width + 4);
        if (widthAddedToTextField > 0) {
            switch (labelHorizontalAlignment) {
                case 0: {
                    if (mouseEventPoint == null) break;
                    mouseEventPoint.x += widthAddedToTextField / 2;
                    break;
                }
                case 4: {
                    if (mouseEventPoint == null) break;
                    mouseEventPoint.x += widthAddedToTextField;
                }
            }
        }
        this.preserveRootNodeLocationOnScreen();
        this.parent.setPreferredSize(newParentSize);
        this.parent.setText("");
        mapView.onEditingStarted(this.parent);
        if (this.getEditControl().getEditType() == EditNodeBase.EditedComponent.TEXT) {
            this.nodeView.setTextBackground(this.getBackground());
        }
        if (!this.layoutMapOnTextChange) {
            mapView.doLayout();
            UITools.convertPointToAncestor((Component)this.parent, (Point)location, (Component)mapView);
        }
        this.textfield.setBounds(location.x, location.y, textFieldMinimumSize.width, textFieldMinimumSize.height);
        if (this.layoutMapOnTextChange) {
            this.parent.add((Component)this.textfield, 0);
        } else {
            mapView.add((Component)this.textfield, 0);
        }
        this.redispatchKeyEvents(this.textfield, firstEvent);
        if (firstEvent == null) {
            int textLength = document.getLength();
            int caretPosition = mouseEventPoint != null ? Math.max(0, Math.min(textLength, this.textfield.viewToModel(mouseEventPoint))) : textLength;
            this.textfield.setCaretPosition(caretPosition);
        }
        document.addDocumentListener(this.documentListener);
        if (textController.isMinimized(this.node) || this.textfield.getPreferredSize().height > this.textfield.getHeight()) {
            this.layout();
        }
        this.textfield.repaint();
        this.textfield.requestFocusInWindow();
    }

    private void preserveRootNodeLocationOnScreen() {
        this.nodeView.getMap().preserveRootNodeLocationOnScreen();
    }

    static {
        char charAfterMnemoSign;
        String rawLabel = TextUtils.getRawText((String)"split");
        int mnemoSignIndex = rawLabel.indexOf(38);
        SPLIT_KEY_CODE = mnemoSignIndex >= 0 && mnemoSignIndex + 1 < rawLabel.length() ? ((charAfterMnemoSign = rawLabel.charAt(mnemoSignIndex + 1)) != ' ' ? (int)charAfterMnemoSign : -1) : -1;
    }

    private static class InputMethodInUseListener
    implements InputMethodListener {
        private boolean imeInUse = false;

        private InputMethodInUseListener() {
        }

        @Override
        public void inputMethodTextChanged(InputMethodEvent event) {
            this.updateImeInUseState(event);
        }

        @Override
        public void caretPositionChanged(InputMethodEvent event) {
            this.updateImeInUseState(event);
        }

        public boolean isIMEInUse() {
            return this.imeInUse;
        }

        private void updateImeInUseState(InputMethodEvent event) {
            AttributedCharacterIterator aci = event.getText();
            if (aci != null) {
                int inputLen = aci.getEndIndex() - aci.getBeginIndex();
                int committedLen = event.getCommittedCharacterCount();
                this.imeInUse = inputLen > 0 && inputLen != committedLen;
            } else {
                this.imeInUse = false;
            }
        }
    }

    private final class MyDocumentListener
    implements DocumentListener {
        private boolean updateRunning = false;

        private MyDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.onUpdate();
        }

        private void onUpdate() {
            if (this.updateRunning) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyDocumentListener.this.updateRunning = true;
                    EditNodeTextField.this.layout();
                    MyDocumentListener.this.updateRunning = false;
                }
            });
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.onUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.onUpdate();
        }
    }

    private class MyNavigationFilter
    extends NavigationFilter {
        private final JEditorPane textfield;

        public MyNavigationFilter(JEditorPane textfield) {
            this.textfield = textfield;
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            dot = this.getValidPosition(dot);
            super.moveDot(fb, dot, bias);
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            dot = this.getValidPosition(dot);
            super.setDot(fb, dot, bias);
        }

        private int getValidPosition(int position) {
            HTMLDocument doc = (HTMLDocument)this.textfield.getDocument();
            if (doc.getDefaultRootElement().getElementCount() > 1) {
                int startPos = doc.getDefaultRootElement().getElement(1).getStartOffset();
                int validPosition = Math.max(position, startPos);
                return validPosition;
            }
            return position;
        }
    }

    private class MapViewChangeListener
    implements IMapViewChangeListener {
        private MapViewChangeListener() {
        }

        public void beforeViewChange(Component oldView, Component newView) {
            String output = EditNodeTextField.this.getNewText();
            EditNodeTextField.this.hideMe();
            EditNodeTextField.this.getEditControl().ok(output);
        }
    }

    private class TextFieldListener
    implements KeyListener,
    FocusListener,
    MouseListener {
        private static final int KEYSTROKE_MODIFIERS = 960;
        final int CANCEL = 2;
        final int EDIT = 1;
        Integer eventSource = 1;
        private boolean popupShown;

        private void conditionallyShowPopup(MouseEvent e) {
            if (Compat.isPopupTrigger((MouseEvent)e)) {
                JComponent component = (JComponent)e.getComponent();
                JPopupMenu popupMenu = EditNodeTextField.this.createPopupMenu(component);
                this.popupShown = true;
                popupMenu.show(component, e.getX(), e.getY());
                e.consume();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.popupShown = false;
            ModeController modeController = Controller.getCurrentModeController();
            modeController.setBlocked(true);
            ((MTextController)modeController.getExtension(TextController.class)).setCurrentBlockingEditor(EditNodeTextField.this);
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (EditNodeTextField.this.textfield == null || !EditNodeTextField.this.textfield.isVisible() || this.eventSource == 2 || this.popupShown) {
                return;
            }
            if (e == null) {
                this.submitText();
                EditNodeTextField.this.hideMe();
                this.eventSource = 2;
                return;
            }
            Component oppositeComponent = e.getOppositeComponent();
            if (e.isTemporary() && oppositeComponent == null) {
                return;
            }
            final Window myWindow = SwingUtilities.getWindowAncestor(e.getComponent());
            if (oppositeComponent != null && SwingUtilities.getWindowAncestor(oppositeComponent) != myWindow) {
                myWindow.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        myWindow.removeWindowFocusListener(this);
                        MainView mainView = EditNodeTextField.this.nodeView.getMainView();
                        if (mainView != null) {
                            mainView.requestFocusInWindow();
                        }
                    }
                });
            }
            this.submitText();
            EditNodeTextField.this.hideMe();
        }

        private void submitText() {
            this.submitText(EditNodeTextField.this.getNewText());
        }

        private void submitText(String output) {
            EditNodeTextField.this.getEditControl().ok(output);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.eventSource == 2 || EditNodeTextField.this.textfield == null) {
                return;
            }
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 27: {
                    if (e.isControlDown() || e.isMetaDown()) break;
                    this.eventSource = 2;
                    EditNodeTextField.this.hideMe();
                    EditNodeTextField.this.getEditControl().cancel();
                    EditNodeTextField.this.nodeView.requestFocusInWindow();
                    e.consume();
                    break;
                }
                case 10: {
                    if (e.isControlDown() || e.isMetaDown()) break;
                    if (e.isAltDown() || e.isShiftDown()) {
                        e.consume();
                        Component component = e.getComponent();
                        KeyEvent keyEvent = new KeyEvent(component, e.getID(), e.getWhen(), 0, keyCode, e.getKeyChar(), e.getKeyLocation());
                        SwingUtilities.processKeyBindings(keyEvent);
                        break;
                    }
                    String output = EditNodeTextField.this.getNewText();
                    e.consume();
                    this.eventSource = 2;
                    EditNodeTextField.this.hideMe();
                    this.submitText(output);
                    EditNodeTextField.this.nodeView.requestFocusInWindow();
                    break;
                }
                case 32: {
                    if (e.isControlDown() || e.isMetaDown()) break;
                    e.consume();
                    break;
                }
                default: {
                    if (!this.isSplitActionTriggered(e) || !EditNodeTextField.this.getEditControl().canSplit()) break;
                    this.eventSource = 2;
                    String output = EditNodeTextField.this.getNewText();
                    int caretPosition = EditNodeTextField.this.textfield.getCaretPosition();
                    EditNodeTextField.this.hideMe();
                    EditNodeTextField.this.getEditControl().split(output, caretPosition);
                    EditNodeTextField.this.nodeView.requestFocusInWindow();
                    e.consume();
                }
            }
        }

        protected boolean isSplitActionTriggered(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == SPLIT_KEY_CODE && keyCode != -1 && e.isAltDown() && !e.isAltGraphDown() && !e.isControlDown() && !Compat.isMacOsX()) {
                return true;
            }
            KeyStroke splitNodeHotKey = ResourceController.getResourceController().getAcceleratorManager().getAccelerator("SplitNode");
            return splitNodeHotKey != null && splitNodeHotKey.getKeyCode() == keyCode && (e.getModifiersEx() & 0x3C0) == (splitNodeHotKey.getModifiers() & 0x3C0);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            String linkURL;
            if (EditNodeTextField.this.textfield != null && (ev.getModifiers() & 2) != 0 && (linkURL = HtmlUtils.getURLOfExistingLink((HTMLDocument)((HTMLDocument)EditNodeTextField.this.textfield.getDocument()), (int)EditNodeTextField.this.textfield.viewToModel(ev.getPoint()))) != null) {
                try {
                    LinkController.getController().loadURI(EditNodeTextField.this.nodeView.getNode(), LinkController.createHyperlink((String)linkURL));
                }
                catch (Exception e) {
                    LogUtils.warn((Throwable)e);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.conditionallyShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.conditionallyShowPopup(e);
        }
    }
}

