/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewIconListComponent;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.MouseEventActor;

public class MNodeDropListener
implements DropTargetListener {
    private static final int UNFOLD_DELAY_MILLISECONDS = 500;
    private Timer timer;

    public void addDropListener(MainView component) {
        this.addDropListener((Component)component);
    }

    public void addDropListener(MapViewIconListComponent component) {
        this.addDropListener((Component)component);
    }

    private void addDropListener(Component component) {
        DropTarget dropTarget = new DropTarget(component, this);
        dropTarget.setActive(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            this.supportFolding(dtde);
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    private void supportFolding(DropTargetDragEvent dtde) {
        MainView node = this.getMainView(dtde);
        if (this.isInFoldingRegion(dtde)) {
            this.startUnfoldTimer(node);
        } else {
            this.stopUnfoldTimer();
        }
    }

    private boolean isInFoldingRegion(DropTargetDragEvent dtde) {
        MainView node = this.getMainView(dtde);
        return node.dragOverRelation(dtde).isChild();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        MainView node = this.getMainView(e);
        this.stopUnfoldTimer();
        MainView mainView = node;
        mainView.stopDragOver();
        mainView.repaint();
    }

    private MainView getMainView(DropTargetEvent e) {
        DropTargetContext dropTargetContext = e.getDropTargetContext();
        return this.getMainView(dropTargetContext);
    }

    private MainView getMainView(DropTargetContext dropTargetContext) {
        Component component = dropTargetContext.getComponent();
        if (component instanceof MainView) {
            return (MainView)component;
        }
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, component);
        return nodeView.getMainView();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            this.supportFolding(dtde);
            MainView dropTarget = this.getMainView(dtde.getDropTargetContext());
            dropTarget.setDragOverDirection(dtde);
        }
    }

    private void startUnfoldTimer(final MainView mainView) {
        if (this.timer == null) {
            this.timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeView nodeView;
                    if (mainView.isDisplayable() && (nodeView = mainView.getNodeView()).isFolded()) {
                        NodeModel node = nodeView.getNode();
                        MapView map = nodeView.getMap();
                        if (map.isSelected()) {
                            map.getModeController().getMapController().unfold(node, map.getFilter());
                        } else {
                            nodeView.setFolded(false);
                        }
                    }
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
    }

    private void stopUnfoldTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        boolean containsTags = event.isDataFlavorSupported(TagSelection.tagFlavor);
        if (containsTags) {
            try {
                NodeView nodeView = this.getMainView(event.getDropTargetContext()).getNodeView();
                List nodeTags = ((IconController)nodeView.getMap().getModeController().getExtension(IconController.class)).getTags(nodeView.getNode());
                String tagData = (String)event.getTransferable().getTransferData(TagSelection.tagFlavor);
                Tag tag = TagCategories.readTag((String)tagData);
                if (nodeTags.contains(tag)) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        if (event.getDropTargetContext().getComponent() instanceof MainView) {
            return event.isDataFlavorSupported(DataFlavor.stringFlavor) || event.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor) || event.isDataFlavorSupported(DataFlavor.imageFlavor);
        }
        return containsTags;
    }

    private boolean isDropAcceptable(DropTargetDropEvent event, int dropAction) {
        List<NodeModel> droppedNodes;
        boolean containsTags = event.isDataFlavorSupported(TagSelection.tagFlavor);
        if (event.getDropTargetContext().getComponent() instanceof MapViewIconListComponent && !containsTags) {
            return false;
        }
        if (containsTags) {
            try {
                NodeView nodeView = this.getMainView(event.getDropTargetContext()).getNodeView();
                List nodeTags = ((IconController)nodeView.getMap().getModeController().getExtension(IconController.class)).getTags(nodeView.getNode());
                String tagData = (String)event.getTransferable().getTransferData(TagSelection.tagFlavor);
                Tag tag = TagCategories.readTag((String)tagData);
                if (nodeTags.contains(tag)) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        if (!event.isLocalTransfer()) {
            return true;
        }
        if (!event.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            return dropAction != 0x40000000;
        }
        try {
            Transferable t = event.getTransferable();
            droppedNodes = this.getNodeObjects(t);
        }
        catch (Exception e) {
            return dropAction != 0x40000000;
        }
        NodeModel node = this.getMainView(event.getDropTargetContext()).getNodeView().getNode();
        if (dropAction == 0x40000000) {
            return this.isFromSameMap(node, droppedNodes);
        }
        if (dropAction == 2) {
            return !this.isFromDescencantNode(node, droppedNodes);
        }
        return !this.droppedNodesContainTargetNode(node, droppedNodes);
    }

    private boolean droppedNodesContainTargetNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected) continue;
            return true;
        }
        return false;
    }

    private boolean isFromSameMap(NodeModel targetNode, Collection<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (selected.getMap() == targetNode.getMap()) continue;
            return false;
        }
        return true;
    }

    private boolean isFromDescencantNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected && !targetNode.isDescendantOf(selected)) continue;
            return true;
        }
        return false;
    }

    private List<NodeModel> getNodeObjects(Transferable t) throws UnsupportedFlavorException, IOException {
        return (List)t.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            boolean isTopOrLeft;
            this.stopUnfoldTimer();
            MainView mainView = this.getMainView(dtde.getDropTargetContext());
            NodeView targetNodeView = mainView.getNodeView();
            MapView mapView = targetNodeView.getMap();
            mapView.select();
            NodeModel targetNode = targetNodeView.getNode();
            Controller controller = Controller.getCurrentController();
            int dropAction = this.getDropAction(dtde);
            Transferable t = dtde.getTransferable();
            mainView.stopDragOver();
            mainView.repaint();
            if (!this.isDropAcceptable(dtde, dropAction)) {
                dtde.rejectDrop();
                return;
            }
            MainView.DragOverRelation dragOverRelation = mainView.dragOverRelation(dtde);
            if (dragOverRelation == MainView.DragOverRelation.NOT_AVAILABLE || dragOverRelation == MainView.DragOverRelation.SIBLING_AFTER) {
                dtde.rejectDrop();
                return;
            }
            boolean dropAsSibling = dragOverRelation == MainView.DragOverRelation.SIBLING_BEFORE;
            ModeController modeController = controller.getModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            if (dropAction == 2 || dropAction == 1) {
                NodeModel parent;
                NodeModel nodeModel = parent = dropAsSibling ? targetNode.getParentNode() : targetNode;
                if (!mapController.isWriteable(parent)) {
                    dtde.rejectDrop();
                    String message = TextUtils.getText((String)"node_is_write_protected");
                    UITools.errorMessage((Object)message);
                    return;
                }
            }
            boolean bl = isTopOrLeft = dragOverRelation == MainView.DragOverRelation.CHILD_BEFORE;
            if (!dtde.isLocalTransfer()) {
                dtde.acceptDrop(1);
                NodeModel.Side side = dropAsSibling ? NodeModel.Side.AS_SIBLING : (isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
                ((MMapClipboardController)MapClipboardController.getController()).paste(t, targetNode, dropAsSibling ? NodeModel.Side.AS_SIBLING : side, dropAction);
                dtde.dropComplete(true);
                return;
            }
            dtde.acceptDrop(dropAction);
            if (dropAction == 0x40000000) {
                int yesorno = 0;
                if (controller.getSelection().size() >= 5) {
                    yesorno = JOptionPane.showConfirmDialog(controller.getViewController().getCurrentRootComponent(), TextUtils.getText((String)"lots_of_links_warning"), Integer.toString(controller.getSelection().size()) + " links to the same node", 0);
                }
                if (yesorno == 0) {
                    for (NodeModel sourceNodeModel : this.getNodeObjects(t)) {
                        ((MLinkController)LinkController.getController((ModeController)modeController)).addConnector(sourceNodeModel, targetNode);
                    }
                }
            } else {
                List selecteds = mapController.getSelectedNodes();
                if (2 == dropAction && t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor) && this.isFromSameMap(targetNode, selecteds)) {
                    NodeModel[] array = selecteds.toArray(new NodeModel[selecteds.size()]);
                    this.moveNodes(mapController, targetNode, t, dropAsSibling, isTopOrLeft);
                    if (dropAsSibling || !targetNodeView.isFolded()) {
                        MouseEventActor.INSTANCE.withMouseEvent(() -> controller.getSelection().replaceSelection(array));
                    } else {
                        MouseEventActor.INSTANCE.withMouseEvent(() -> mapView.selectAsTheOnlyOneSelected(targetNodeView));
                    }
                } else if (1 == dropAction || 2 == dropAction) {
                    NodeModel.Side side = dropAsSibling ? NodeModel.Side.AS_SIBLING : (isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
                    ((MMapClipboardController)MapClipboardController.getController()).paste(t, targetNode, dropAsSibling ? NodeModel.Side.AS_SIBLING : side);
                    MouseEventActor.INSTANCE.withMouseEvent(() -> controller.getSelection().selectAsTheOnlyOneSelected(targetNode));
                }
            }
        }
        catch (Exception e) {
            LogUtils.severe((String)"Drop exception:", (Throwable)e);
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    private int getDropAction(DropTargetDropEvent dtde) throws UnsupportedFlavorException, IOException {
        int dropAction = dtde.getDropAction();
        Transferable t = dtde.getTransferable();
        if (t.isDataFlavorSupported(MindMapNodesSelection.dropActionFlavor)) {
            dropAction = (Integer)t.getTransferData(MindMapNodesSelection.dropActionFlavor);
        }
        return dropAction;
    }

    private void moveNodes(MMapController mapController, NodeModel targetNode, Transferable t, boolean dropAsSibling, boolean isTopOrLeft) throws UnsupportedFlavorException, IOException {
        List<NodeModel> movedNodes = this.getNodeObjects(t);
        MouseEventActor.INSTANCE.withMouseEvent(() -> {
            if (dropAsSibling) {
                mapController.moveNodesBefore(movedNodes, targetNode);
                mapController.setSide(movedNodes, targetNode.getSide());
            } else {
                List nodesChangingParent = movedNodes.stream().filter(node -> targetNode != node.getParentNode()).collect(Collectors.toList());
                mapController.moveNodesAsChildren(movedNodes, targetNode);
                NodeModel.Side side = isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT;
                mapController.setSide(side == NodeModel.Side.DEFAULT ? nodesChangingParent : movedNodes, side);
            }
        });
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

