/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.location;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.location.AbstractWindowLocation;
import net.infonode.docking.location.WindowLocation;
import net.infonode.util.Direction;

public class WindowSplitLocation
extends AbstractWindowLocation {
    private Direction direction;
    private float dividerLocation;

    public WindowSplitLocation(DockingWindow splitWith, WindowLocation parentLocation, Direction direction, float dividerLocation) {
        super(splitWith, parentLocation);
        this.direction = direction;
        this.dividerLocation = dividerLocation;
    }

    private WindowSplitLocation(Direction direction, float dividerLocation) {
        this.direction = direction;
        this.dividerLocation = dividerLocation;
    }

    @Override
    public boolean set(DockingWindow parent, DockingWindow child) {
        parent.split(child, this.direction, this.dividerLocation);
        return true;
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(2);
        this.direction.write(out);
        out.writeFloat(this.dividerLocation);
        super.write(out);
    }

    public static WindowSplitLocation decode(ObjectInputStream in, RootWindow rootWindow) throws IOException {
        WindowSplitLocation location = new WindowSplitLocation(Direction.decode(in), in.readFloat());
        location.read(in, rootWindow);
        return location;
    }
}

