/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.gui.ComponentPaintChecker;
import net.infonode.gui.draggable.DraggableComponentBoxAdapter;
import net.infonode.gui.draggable.DraggableComponentBoxEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.panel.HoverableShapedPanel;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelContentPanelProperties;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.internal.TabbedHoverUtil;
import net.infonode.util.Direction;
import net.infonode.util.ValueChange;

public class TabbedPanelContentPanel
extends BaseContainer {
    private final TabbedPanel tabbedPanel;
    private final HoverableShapedPanel shapedPanel;
    private final ComponentPaintChecker repaintChecker;
    private final PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        @Override
        public void propertyValuesChanged(Map changes) {
            Map m = (Map)changes.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getContentPanelProperties().getMap());
            if (m != null && m.keySet().contains(TabbedPanelContentPanelProperties.HOVER_LISTENER)) {
                TabbedPanelContentPanel.this.shapedPanel.setHoverListener((HoverListener)((ValueChange)m.get(TabbedPanelContentPanelProperties.HOVER_LISTENER)).getNewValue());
            }
            if ((m = (Map)changes.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getContentPanelProperties().getComponentProperties().getMap())) != null) {
                TabbedPanelContentPanel.this.update();
            }
            if ((m = (Map)changes.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getContentPanelProperties().getShapedPanelProperties().getMap())) != null) {
                TabbedPanelContentPanel.this.update();
            }
            if ((m = (Map)changes.get(TabbedPanelContentPanel.this.tabbedPanel.getProperties().getMap())) != null && m.keySet().contains(TabbedPanelProperties.TAB_AREA_ORIENTATION)) {
                TabbedPanelContentPanel.this.shapedPanel.setDirection(((Direction)((ValueChange)m.get(TabbedPanelProperties.TAB_AREA_ORIENTATION)).getNewValue()).getNextCW());
            }
        }
    };

    public TabbedPanelContentPanel(TabbedPanel tabbedPanel, JComponent component) {
        super(new BorderLayout());
        this.tabbedPanel = tabbedPanel;
        this.shapedPanel = new HoverableShapedPanel(new BorderLayout(), tabbedPanel.getProperties().getContentPanelProperties().getHoverListener(), tabbedPanel){

            @Override
            public boolean acceptHover(ArrayList enterableHoverables) {
                return TabbedHoverUtil.acceptTabbedPanelHover(TabbedPanelContentPanel.this.getTabbedPanel().getProperties().getHoverPolicy(), enterableHoverables, TabbedPanelContentPanel.this.getTabbedPanel(), this);
            }

            @Override
            protected void processMouseEvent(MouseEvent event) {
                super.processMouseEvent(event);
                if (TabbedPanelContentPanel.this.getTabbedPanel().hasContentArea()) {
                    TabbedPanelContentPanel.this.getTabbedPanel().doProcessMouseEvent(event);
                } else {
                    TabbedPanelContentPanel.this.doProcessMouseEvent(SwingUtilities.convertMouseEvent(this, event, TabbedPanelContentPanel.this));
                }
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent event) {
                super.processMouseMotionEvent(event);
                if (TabbedPanelContentPanel.this.getTabbedPanel().hasContentArea()) {
                    TabbedPanelContentPanel.this.getTabbedPanel().doProcessMouseMotionEvent(event);
                } else {
                    TabbedPanelContentPanel.this.doProcessMouseMotionEvent(SwingUtilities.convertMouseEvent(this, event, TabbedPanelContentPanel.this));
                }
            }
        };
        this.repaintChecker = new ComponentPaintChecker(this.shapedPanel);
        this.shapedPanel.add((Component)component, "Center");
        this.add((Component)this.shapedPanel, "Center");
        this.update();
        PropertyMapWeakListenerManager.addWeakTreeListener(tabbedPanel.getProperties().getMap(), this.propertiesListener);
        tabbedPanel.getDraggableComponentBox().addListener(new DraggableComponentBoxAdapter(){

            @Override
            public void changed(DraggableComponentBoxEvent event) {
                if (event.getDraggableComponent() == null || event.getDraggableComponentEvent().getType() == -1) {
                    TabbedPanelContentPanel.this.repaintBorder();
                }
            }
        });
        tabbedPanel.addTabListener(new TabAdapter(){

            @Override
            public void tabAdded(TabEvent event) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            @Override
            public void tabRemoved(TabRemovedEvent event) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            @Override
            public void tabSelected(TabStateChangedEvent event) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            @Override
            public void tabDeselected(TabStateChangedEvent event) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            @Override
            public void tabDehighlighted(TabStateChangedEvent event) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            @Override
            public void tabHighlighted(TabStateChangedEvent event) {
                TabbedPanelContentPanel.this.repaintBorder();
            }

            @Override
            public void tabMoved(TabEvent event) {
                TabbedPanelContentPanel.this.repaintBorder();
            }
        });
    }

    public TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    public TabbedPanelContentPanelProperties getProperties() {
        return this.tabbedPanel.getProperties().getContentPanelProperties();
    }

    private void update() {
        this.getProperties().getComponentProperties().applyTo(this.shapedPanel);
        InternalPropertiesUtil.applyTo(this.getProperties().getShapedPanelProperties(), this.shapedPanel, this.tabbedPanel.getProperties().getTabAreaOrientation().getNextCW());
        BaseContainerUtil.setForcedOpaque(this, this.getProperties().getShapedPanelProperties().getOpaque());
    }

    private void repaintBorder() {
        if (this.repaintChecker.isPaintingOk()) {
            Direction d = this.tabbedPanel.getProperties().getTabAreaOrientation();
            Rectangle r = d == Direction.UP ? new Rectangle(0, 0, this.shapedPanel.getWidth(), this.shapedPanel.getInsets().top) : (d == Direction.LEFT ? new Rectangle(0, 0, this.shapedPanel.getInsets().left, this.shapedPanel.getHeight()) : (d == Direction.DOWN ? new Rectangle(0, this.shapedPanel.getHeight() - this.shapedPanel.getInsets().bottom - 1, this.shapedPanel.getWidth(), this.shapedPanel.getHeight()) : new Rectangle(this.shapedPanel.getWidth() - this.shapedPanel.getInsets().right - 1, 0, this.shapedPanel.getWidth(), this.shapedPanel.getHeight())));
            this.shapedPanel.repaint(r);
        }
    }

    private void doProcessMouseEvent(MouseEvent event) {
        this.processMouseEvent(event);
    }

    private void doProcessMouseMotionEvent(MouseEvent event) {
        this.processMouseMotionEvent(event);
    }
}

