/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import org.freeplane.core.ui.AntiAliasingConfigurator;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.icon.Tag;

public class TagIcon
implements Icon {
    private static final int MARGIN = 2;
    private static final int DOUBLE_MARGIN = 4;
    private final Tag tag;
    private final Font font;
    private final int width;
    private final int height;
    private final Color tagTextColor;
    private final Color tagBackgroundColor;

    public TagIcon(Tag tag, Font font) {
        this(tag, font, null, null);
    }

    public TagIcon(Tag tag, Font font, Color tagTextColor, Color tagBackgroundColor) {
        this.tag = tag;
        this.font = font;
        this.tagTextColor = tagTextColor;
        this.tagBackgroundColor = tagBackgroundColor;
        String content = tag.isEmpty() ? "*" : tag.getContent();
        Rectangle2D rect = font.getStringBounds(content, 0, content.length(), new FontRenderContext(new AffineTransform(), true, true));
        double textHeight = rect.getHeight();
        this.width = tag.isEmpty() ? 0 : (int)Math.ceil(rect.getWidth() + textHeight) + 4;
        this.height = (int)Math.ceil(textHeight * 1.2) + 4;
    }

    @Override
    public void paintIcon(Component c, Graphics prototypeGraphics, int x, int y) {
        if (this.tag.isEmpty()) {
            return;
        }
        Graphics2D g = (Graphics2D)prototypeGraphics.create();
        AntiAliasingConfigurator.setAntialiasing(g);
        Color backgroundColor = this.tagBackgroundColor != null ? this.tagBackgroundColor : this.tag.getColor();
        Color textColor = this.tagTextColor != null ? this.tagTextColor : UITools.getTextColorForBackground(backgroundColor);
        g.setColor(backgroundColor);
        GeneralPath path = TagIcon.createTagIconShape(x + 2, y + 2, this.width - 4, this.height - 4);
        g.fill(path);
        g.setColor(textColor);
        g.draw(path);
        g.setFont(this.font);
        g.drawString(this.tag.getContent(), x + 2 + (this.height - 4) / 4, y + 2 + (this.height - 4) * 4 / 5);
        g.dispose();
    }

    public static GeneralPath createTagIconShape(int x, int y, int width, int height) {
        int r = (int)(UITools.FONT_SCALE_FACTOR * 10.0f);
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + width - r, y);
        path.quadTo(x + width, y, x + width, y + height / 2);
        path.quadTo(x + width, y + height, x + width - r, y + height);
        path.lineTo(x, y + height);
        path.closePath();
        return path;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public Tag getTag() {
        return this.tag;
    }

    public String toString() {
        return "TagIcon [tag=" + this.tag + ", font=" + this.font + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

